/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.tools;

import net.imagej.ChannelCollection;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.event.AxisPositionEvent;
import net.imagej.options.OptionsChannels;
import net.imagej.plugins.tools.PixelRecorder;
import org.scijava.app.StatusService;
import org.scijava.command.CommandService;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.display.event.input.MsClickedEvent;
import org.scijava.display.event.input.MsEvent;
import org.scijava.event.EventHandler;
import org.scijava.options.OptionsService;
import org.scijava.options.event.OptionsEvent;
import org.scijava.plugin.Parameter;
import org.scijava.tool.AbstractTool;
import org.scijava.tool.CustomDrawnTool;
import org.scijava.tool.IconDrawer;
import org.scijava.tool.IconService;
import org.scijava.tool.Tool;
import org.scijava.util.ColorRGB;

public abstract class AbstractColorTool
extends AbstractTool
implements CustomDrawnTool {
    public static final int BASE_PRIORITY = -500;
    @Parameter
    private StatusService statusService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private OptionsService optionsService;
    @Parameter
    private DisplayService displayService;
    @Parameter(required=false)
    private ImageDisplayService imageDisplayService;
    @Parameter(required=false)
    private IconService iconService;
    private IconDrawer drawer;
    private PixelRecorder recorder;

    abstract ColorRGB getEmptyColor();

    abstract ColorRGB getOutlineColor();

    abstract ChannelCollection getChannels(OptionsChannels var1);

    abstract void setChannels(OptionsChannels var1, ChannelCollection var2);

    abstract void setLastColor(OptionsChannels var1, ColorRGB var2);

    abstract String getLabel();

    public void configure() {
        this.commandService.run(OptionsChannels.class, true, new Object[0]);
    }

    public void onMouseClick(MsClickedEvent evt) {
        if (evt.getButton() != 0) {
            return;
        }
        if (this.recorder == null) {
            this.recorder = new PixelRecorder(this.getContext(), true);
        }
        if (!this.recorder.record((MsEvent)evt)) {
            evt.consume();
            return;
        }
        OptionsChannels options = this.getOptions();
        ChannelCollection values = this.recorder.getValues();
        this.setChannels(options, values);
        this.setLastColor(options, this.recorder.getColor());
        options.save();
        this.statusMessage(this.getLabel(), values);
        this.recorder.releaseDataset();
        evt.consume();
    }

    public String getDescription() {
        OptionsChannels opts = this.getOptions();
        ChannelCollection channels = this.getChannels(opts);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel());
        sb.append(" = ");
        sb.append(this.valuesString(channels));
        return sb.toString();
    }

    public void drawIcon() {
        DatasetView view = this.imageDisplayService == null ? null : this.imageDisplayService.getActiveDatasetView();
        ColorRGB color = this.getEmptyColor();
        if (view != null) {
            OptionsChannels options = this.getOptions();
            ChannelCollection channels = this.getChannels(options);
            color = view.getColor(channels);
        }
        this.draw(color);
    }

    @EventHandler
    protected void onEvent(DisplayActivatedEvent evt) {
        this.drawIcon();
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent evt) {
        if (this.displayService.getActiveDisplay() == null) {
            this.drawIcon();
        }
    }

    @EventHandler
    protected void onEvent(OptionsEvent evt) {
        if (evt.getOptions() instanceof OptionsChannels) {
            this.drawIcon();
        }
    }

    @EventHandler
    protected void onEvent(AxisPositionEvent evt) {
        Display activeDisplay = this.displayService.getActiveDisplay();
        if (evt.getDisplay() == activeDisplay) {
            this.drawIcon();
        }
    }

    private void draw(ColorRGB fillColor) {
        int x;
        if (this.drawer == null) {
            this.drawer = this.acquireDrawer();
        }
        if (this.drawer == null) {
            return;
        }
        int width = this.drawer.getIconRectangleWidth();
        int height = this.drawer.getIconRectangleHeight();
        for (int y = 0; y < height; ++y) {
            this.drawer.setIconPixel(0, y, this.getOutlineColor());
            this.drawer.setIconPixel(width - 1, y, this.getOutlineColor());
        }
        for (x = 0; x < width; ++x) {
            this.drawer.setIconPixel(x, 0, this.getOutlineColor());
            this.drawer.setIconPixel(x, height - 1, this.getOutlineColor());
        }
        for (x = 1; x < this.drawer.getIconRectangleWidth() - 1; ++x) {
            for (int y = 1; y < this.drawer.getIconRectangleHeight() - 1; ++y) {
                this.drawer.setIconPixel(x, y, fillColor);
            }
        }
    }

    private IconDrawer acquireDrawer() {
        return this.iconService == null ? null : this.iconService.acquireDrawer((Tool)this);
    }

    private String valuesString(ChannelCollection chans) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        int i = 0;
        while ((long)i < chans.getChannelCount()) {
            if (i != 0) {
                builder.append(",");
            }
            String valString = chans.areInteger() ? String.format("%d", (long)chans.getChannelValue((long)i)) : String.format("%f", chans.getChannelValue((long)i));
            builder.append(valString);
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }

    private void statusMessage(String label, ChannelCollection values) {
        StringBuilder builder = new StringBuilder();
        builder.append(label);
        builder.append(" = ");
        builder.append(this.valuesString(values));
        this.statusService.showStatus(builder.toString());
    }

    private OptionsChannels getOptions() {
        return (OptionsChannels)this.optionsService.getOptions(OptionsChannels.class);
    }
}

