/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics.geom;

import org.renjin.graphics.geom.Dimension;
import org.renjin.graphics.geom.Margins;
import org.renjin.graphics.geom.Point;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class Rectangle {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    public static final Rectangle UNIT_RECT = new Rectangle(0.0, 1.0, 0.0, 1.0);

    public Rectangle(double x1, double x2, double y1, double y2) {
        assert (x1 <= x2);
        assert (y1 <= y2);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static Rectangle from(SEXP exp2) {
        if (exp2 instanceof Vector) {
            throw new IllegalArgumentException();
        }
        return Rectangle.from((Vector)exp2);
    }

    public static Rectangle from(Vector vector2) {
        if (vector2.length() != 4) {
            throw new IllegalArgumentException("Expected vector of length 4 (x1, x2, y1, x2)");
        }
        return new Rectangle(vector2.getElementAsDouble(0), vector2.getElementAsDouble(1), vector2.getElementAsDouble(2), vector2.getElementAsDouble(3));
    }

    public static Rectangle from(Vector xlim, Vector ylim) {
        return new Rectangle(xlim.getElementAsDouble(0), xlim.getElementAsDouble(1), ylim.getElementAsDouble(0), ylim.getElementAsDouble(1));
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public double getWidth() {
        return this.x2 - this.x1;
    }

    public double getHeight() {
        return this.y2 - this.y1;
    }

    public DoubleVector toVector() {
        return new DoubleArrayVector(this.x1, this.x2, this.y1, this.y2);
    }

    public Rectangle normalize(Rectangle rect2) {
        return new Rectangle(this.normalizeX(rect2.getX1()), this.normalizeX(rect2.getX2()), this.normalizeY(rect2.getY2()), this.normalizeY(rect2.getY1()));
    }

    public Point normalize(Point point) {
        return new Point(this.normalizeX(point.getX()), this.normalizeY(point.getY()));
    }

    private double normalizeX(double x) {
        return (x - this.x1) / this.getWidth();
    }

    private double normalizeY(double y) {
        return (this.y2 - y) / this.getHeight();
    }

    private double denormalizeX(double x) {
        return this.x1 + x * this.getWidth();
    }

    private double denormalizeY(double y) {
        return this.y2 - y * this.getHeight();
    }

    public Rectangle denormalize(Rectangle rect2) {
        return new Rectangle(this.denormalizeX(rect2.x1), this.denormalizeX(rect2.x2), this.denormalizeY(rect2.y2), this.denormalizeY(rect2.y1));
    }

    public Point denormalize(Point point) {
        return new Point(this.denormalizeX(point.getX()), this.denormalizeY(point.getY()));
    }

    public Dimension size() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Rectangle apply(Margins margins) {
        return new Rectangle(this.x1 + margins.getLeft(), this.x2 - margins.getRight(), this.y1 + margins.getTop(), this.y2 - margins.getBottom());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x1);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y1);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y2);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (Double.doubleToLongBits(this.x1) != Double.doubleToLongBits(other.x1)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x2) != Double.doubleToLongBits(other.x2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y1) != Double.doubleToLongBits(other.y1)) {
            return false;
        }
        return Double.doubleToLongBits(this.y2) == Double.doubleToLongBits(other.y2);
    }

    public String toString() {
        return "Rectangle [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }

    public Rectangle withXLimits(double newX1, double newX2) {
        return new Rectangle(newX1, newX2, this.y1, this.y2);
    }

    public Rectangle withYLimits(double newY1, double newY2) {
        return new Rectangle(this.x1, this.x2, newY1, newY2);
    }
}

