/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;

public class TextConnection
implements Connection {
    private final String objectName;
    private PushbackBufferedReader reader;

    public TextConnection(String objectName, String text) {
        this.objectName = objectName;
        this.reader = new PushbackBufferedReader(new StringReader(text));
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
        if (!spec.forReading()) {
            throw new EvalException("Only read support for text connections is implemented, sorry!", new Object[0]);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new EvalException("reading bytes from TextConnections is not supported", new Object[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new EvalException("Writing to textConnections is not currently implemented", new Object[0]);
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public String getClassName() {
        return "textConnection";
    }

    @Override
    public String getDescription() {
        return this.objectName;
    }

    @Override
    public Connection.Type getType() {
        return Connection.Type.TEXT;
    }

    @Override
    public PushbackBufferedReader getReader() throws IOException {
        return this.reader;
    }

    @Override
    public PrintWriter getPrintWriter() throws IOException {
        throw new EvalException("reading bytes from TextConnections is not supported", new Object[0]);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getMode() {
        return "r";
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }
}

