/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.CompleteSelection;
import org.renjin.primitives.subset.CoordinateMatrixSelection;
import org.renjin.primitives.subset.DimensionSelection;
import org.renjin.primitives.subset.Selection;
import org.renjin.primitives.subset.VectorIndexSelection;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;
import org.renjin.util.NamesBuilder;

public class SubscriptOperation {
    private Vector source;
    private boolean drop = true;
    private List<SEXP> subscripts;
    private Selection selection;

    public SubscriptOperation setSource(SEXP source, ListVector arguments, int skipBeginning, int skipEnd) {
        SEXP subscript;
        if (source instanceof PairList.Node) {
            this.source = ((PairList.Node)source).toVector();
        } else if (source instanceof Vector) {
            this.source = (Vector)source;
        } else {
            throw new EvalException("Invalid source: " + source, new Object[0]);
        }
        this.subscripts = Lists.newArrayList();
        int i = skipBeginning;
        while (i + skipEnd < arguments.length()) {
            this.subscripts.add(arguments.getElementAsSEXP(i));
            ++i;
        }
        this.selection = this.subscripts.isEmpty() ? new CompleteSelection(source) : (this.subscripts.size() == 1 ? (CoordinateMatrixSelection.isCoordinateMatrix(source, subscript = this.subscripts.get(0)) ? new CoordinateMatrixSelection(source, subscript) : new VectorIndexSelection(source, subscript)) : new DimensionSelection(source, this.subscripts));
        return this;
    }

    public SubscriptOperation setSource(SEXP source, ListVector arguments) {
        return this.setSource(source, arguments, 0, 0);
    }

    public SubscriptOperation setDrop(boolean drop2) {
        this.drop = drop2;
        return this;
    }

    public SEXP extractSingle() {
        if ((this.selection instanceof VectorIndexSelection || this.selection instanceof CoordinateMatrixSelection) && this.selection.getElementCount() > 1) {
            throw new EvalException("attempt to select more than one element", new Object[0]);
        }
        if (this.selection.getElementCount() < 1) {
            throw new EvalException("attempt to select less than one element", new Object[0]);
        }
        int index = (Integer)this.selection.iterator().next();
        if (index < 0 || index >= this.source.length()) {
            throw new EvalException("subscript out of bounds", new Object[0]);
        }
        return this.source.getElementAsSEXP(index);
    }

    public Vector extract() {
        if (this.source == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        StringVector.Builder names2 = null;
        if (this.source.getAttribute(Symbols.NAMES) != Null.INSTANCE) {
            names2 = new StringVector.Builder();
        }
        Vector.Builder result = this.source.newBuilderWithInitialSize(this.selection.getElementCount());
        int count = 0;
        for (Integer index : this.selection) {
            if (!IntVector.isNA(index) && index < this.source.length()) {
                result.setFrom(count++, this.source, index);
                if (names2 == null) continue;
                names2.add(this.source.getName(index));
                continue;
            }
            result.setNA(count++);
            if (names2 == null) continue;
            names2.addNA();
        }
        result.setAttribute(Symbols.DIM, (SEXP)this.extractionDimension());
        if (this.subscripts.size() == 1 && !this.sourceIsSingleDimensionArray()) {
            if (names2 != null) {
                result.setAttribute(Symbols.NAMES, (SEXP)names2.build());
            }
        } else {
            IntArrayVector.Builder dim2 = new IntArrayVector.Builder();
            ListVector.Builder dimNames = new ListVector.Builder();
            boolean hasDimNames = false;
            int[] selectedDim = this.selection.getSubscriptDimensions();
            for (int d = 0; d != selectedDim.length; ++d) {
                if (selectedDim[d] <= 1 && this.drop) continue;
                dim2.add(selectedDim[d]);
                Vector dimNamesElement = this.selection.getDimensionNames(d);
                hasDimNames |= dimNamesElement != Null.INSTANCE;
                dimNames.add(dimNamesElement);
            }
            if (dim2.length() > 1 || !this.drop) {
                result.setAttribute(Symbols.DIM, (SEXP)dim2.build());
                if (hasDimNames) {
                    result.setAttribute(Symbols.DIMNAMES, (SEXP)dimNames.build());
                }
            } else if (hasDimNames) {
                result.setAttribute(Symbols.NAMES, dimNames.build().getElementAsSEXP(0));
            }
        }
        return result.build();
    }

    private boolean sourceIsSingleDimensionArray() {
        return this.source.getAttribute(Symbols.DIM).length() == 1;
    }

    private Vector extractionDimension() {
        if (this.source.getAttribute(Symbols.DIM) == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        int[] selectedDim = this.selection.getSubscriptDimensions();
        IntArrayVector.Builder result = new IntArrayVector.Builder();
        for (int i = 0; i != selectedDim.length; ++i) {
            if (this.drop && selectedDim[i] == 1) continue;
            result.add(selectedDim[i]);
        }
        if (result.length() == 0) {
            return Null.INSTANCE;
        }
        if (this.drop && result.length() == 1 && this.source.getAttribute(Symbols.DIM).length() != 1) {
            return Null.INSTANCE;
        }
        return result.build();
    }

    public Vector replace(SEXP elements) {
        if (this.source instanceof ListVector && elements == Null.INSTANCE) {
            return this.remove();
        }
        if (this.subscripts.size() == 1 && this.subscripts.get(0) instanceof StringVector) {
            return this.replaceByName(elements);
        }
        if (!this.selection.isEmpty() && elements.length() == 0) {
            throw new EvalException("replacement has zero length", new Object[0]);
        }
        Vector.Builder result = this.createReplacementBuilder(elements);
        int replacement = 0;
        Iterator i$ = this.selection.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            assert (index < this.source.length() || this.selection.getSourceDimensions() == 1);
            if (IntVector.isNA(index)) continue;
            result.setFrom(index, elements, replacement++);
            if (replacement < elements.length()) continue;
            replacement = 0;
        }
        return result.build();
    }

    private Vector replaceByName(SEXP elements) {
        StringVector namesToReplace = (StringVector)this.subscripts.get(0);
        Vector.Builder result = this.createReplacementBuilder(elements);
        NamesBuilder names2 = NamesBuilder.clonedFrom(this.source);
        int replacementIndex = 0;
        for (String nameToReplace : namesToReplace) {
            int index = this.source.getIndexByName(nameToReplace);
            if (index == -1) {
                index = result.length();
                names2.set(index, nameToReplace);
            }
            result.setFrom(index, elements, replacementIndex++);
            if (replacementIndex < elements.length()) continue;
            replacementIndex = 0;
        }
        result.setAttribute(Symbols.NAMES, (SEXP)names2.build());
        return result.build();
    }

    public Vector remove() {
        HashSet indicesToRemove = Sets.newHashSet();
        Iterator i$ = this.selection.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            if (IntVector.isNA(index)) continue;
            indicesToRemove.add(index);
        }
        Vector.Builder result = this.source.newBuilderWithInitialSize(0);
        result.copyAttributesFrom(this.source);
        for (int i = 0; i != this.source.length(); ++i) {
            if (indicesToRemove.contains(i)) continue;
            result.addFrom(this.source, i);
        }
        return result.build();
    }

    private Vector.Builder createReplacementBuilder(SEXP elements) {
        Vector.Builder result;
        Vector.Type replacementType = elements instanceof AtomicVector ? ((AtomicVector)elements).getVectorType() : ListVector.VECTOR_TYPE;
        if (this.source.getVectorType().isWiderThanOrEqualTo(replacementType)) {
            result = this.source.newCopyBuilder();
        } else {
            result = replacementType.newBuilderWithInitialSize(this.source.length());
            result.copyAttributesFrom(this.source);
            for (int i = 0; i != this.source.length(); ++i) {
                result.setFrom(i, this.source, i);
            }
        }
        return result;
    }
}

