/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.renjin.primitives.subset.Selection;
import org.renjin.primitives.subset.Subscript;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;

public class VectorIndexSelection
extends Selection {
    private final SEXP source;
    private final Subscript subscript;

    public VectorIndexSelection(SEXP source, SEXP subscript) {
        super(source);
        this.source = source;
        this.subscript = this.parseSubscript(subscript, 0, source.length());
    }

    @Override
    public Iterator<Integer> iterator() {
        return new UnmodifiableIterator<Integer>(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < VectorIndexSelection.this.subscript.getCount();
            }

            public Integer next() {
                return VectorIndexSelection.this.subscript.getAt(this.i++);
            }
        };
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getElementCount() {
        return this.subscript.getCount();
    }

    @Override
    public int[] getSubscriptDimensions() {
        return new int[]{this.getElementCount()};
    }

    @Override
    protected AtomicVector getNames(int dimensionIndex) {
        return (AtomicVector)this.source.getAttribute(Symbols.NAMES);
    }

    @Override
    public Iterable<Integer> getSelectionAlongDimension(int dimensionIndex) {
        if (dimensionIndex != 0) {
            throw new IllegalArgumentException("dimensionIndex: " + dimensionIndex);
        }
        return this;
    }
}

