/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.apache.commons.math.distribution.ContinuousDistribution;

public class UniformDistribution
implements ContinuousDistribution {
    private final double min;
    private final double max;
    private final double range;

    public UniformDistribution(double min2, double max2) {
        this.min = min2;
        this.max = max2;
        this.range = max2 - min2;
    }

    public double cumulativeProbability(double x) {
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        return (x - this.min) / this.range;
    }

    public double density(double x) {
        if (x < this.min || x > this.max) {
            return 0.0;
        }
        return 1.0 / this.range;
    }

    public double inverseCumulativeProbability(double p) {
        return this.min + p * this.range;
    }

    public double cumulativeProbability(double x0, double x1) {
        if (x0 < this.min) {
            x0 = this.min;
        }
        if (x0 > this.max) {
            x0 = this.max;
        }
        if (x1 < this.min) {
            x1 = this.min;
        }
        if (x1 > this.max) {
            x1 = this.max;
        }
        return (x1 - x0) / this.range;
    }
}

