/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util.iterationcode;

import gnu.trove.list.array.TIntArrayList;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Iterator;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.roi.util.iterationcode.IterationCode;

public class IterationCodeIterator<P extends Positionable & Localizable>
extends AbstractEuclideanSpace
implements Iterator {
    private final TIntArrayList itcode;
    private final long[] offset;
    private final P position;
    private int itcodeIndex;
    private int itcodeOffsetX;
    private long maxX;
    private boolean hasNextRaster;

    public IterationCodeIterator(IterationCode iterationCode, long[] offset, P position) {
        this(iterationCode.getItcode(), offset, position);
    }

    public IterationCodeIterator(TIntArrayList itcode, long[] offset, P position) {
        super(position.numDimensions());
        this.position = position;
        this.itcode = itcode;
        this.offset = offset;
        this.reset();
    }

    public IterationCodeIterator(IterationCodeIterator<?> copyFrom, P position) {
        super(position.numDimensions());
        this.itcode = copyFrom.itcode;
        this.offset = copyFrom.offset;
        this.position = position;
        this.position.setPosition((Localizable)copyFrom.position);
        this.itcodeIndex = copyFrom.itcodeIndex;
        this.itcodeOffsetX = copyFrom.itcodeOffsetX;
        this.maxX = copyFrom.maxX;
        this.hasNextRaster = copyFrom.hasNextRaster;
    }

    private void nextRasterStretch() {
        int minItcodeX;
        if ((minItcodeX = this.itcode.get(this.itcodeIndex++)) < 0) {
            for (int d = 1; d <= -minItcodeX; ++d) {
                this.position.setPosition((long)this.itcode.get(this.itcodeIndex++) + this.offset[d], d);
            }
            minItcodeX = this.itcode.get(this.itcodeIndex++);
        }
        this.position.setPosition((long)(minItcodeX + this.itcodeOffsetX) + this.offset[0], 0);
        this.maxX = (long)(this.itcode.get(this.itcodeIndex++) + this.itcodeOffsetX) + this.offset[0];
        this.hasNextRaster = this.itcodeIndex < this.itcode.size();
    }

    public void jumpFwd(long steps) {
        for (long j = 0L; j < steps; ++j) {
            this.fwd();
        }
    }

    public void fwd() {
        this.position.fwd(0);
        if (((Localizable)this.position).getLongPosition(0) > this.maxX) {
            this.nextRasterStretch();
        }
    }

    public void reset() {
        this.itcodeIndex = 0;
        if (!this.itcode.isEmpty()) {
            this.itcodeOffsetX = this.itcode.get(this.itcodeIndex++);
            for (int d = 1; d < this.n; ++d) {
                this.position.setPosition((long)this.itcode.get(this.itcodeIndex++) + this.offset[d], d);
            }
            this.nextRasterStretch();
            this.position.bck(0);
        } else {
            this.hasNextRaster = false;
            this.position.setPosition(0, 0);
            this.maxX = 0L;
        }
    }

    public boolean hasNext() {
        return this.hasNextRaster || ((Localizable)this.position).getLongPosition(0) < this.maxX;
    }
}

