/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.util.Arrays;
import java.util.Formatter;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SmartArrayInt {
    private final int[] raw;
    private final int start;
    private final boolean isSequential;
    private final boolean isConstant;
    private final boolean isSorted;
    private final int n;

    public SmartArrayInt(int[] raw) {
        this.n = raw.length;
        if (raw.length == 0) {
            this.start = -1;
            this.isConstant = true;
            this.isSequential = false;
            this.isSorted = false;
            this.raw = null;
            return;
        }
        boolean isC = true;
        boolean isSeq = true;
        boolean isSort = true;
        this.start = raw[0];
        for (int i = 0; i < raw.length; ++i) {
            if (raw[i] != this.start + i) {
                isSeq = false;
            }
            if (raw[i] != this.start) {
                isC = false;
            }
            if (i <= 0 || raw[i] >= raw[i - 1]) continue;
            isSort = false;
        }
        this.raw = !isSeq && !isC ? raw : null;
        this.isSequential = isSeq;
        this.isConstant = isC;
        this.isSorted = isSort;
    }

    public int get(int idx) {
        if (this.isConstant) {
            return this.start;
        }
        if (this.isSequential) {
            return this.start + idx;
        }
        return this.raw[idx];
    }

    public int getN() {
        return this.n;
    }

    public void show(Formatter f) {
        if (this.isConstant) {
            f.format("isConstant=%d", this.start);
        } else if (this.isSequential) {
            f.format("isSequential start=%d", this.start);
        } else {
            f.format("isSorted=%s %s", this.isSorted, Arrays.toString(this.raw));
        }
    }

    public int findIdx(int want) {
        if (this.isConstant) {
            return want == this.start ? 0 : -1;
        }
        if (this.isSequential) {
            return want - this.start;
        }
        if (this.isSorted) {
            return Arrays.binarySearch(this.raw, want);
        }
        for (int i = 0; i < this.raw.length; ++i) {
            if (this.raw[i] != want) continue;
            return i;
        }
        return -1;
    }
}

