/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.container;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonN5Reader;
import org.janelia.saalfeldlab.n5.GsonN5Writer;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;

public class ContainerMetadataNode
implements GsonN5Writer {
    protected String path;
    protected HashMap<String, JsonElement> attributes;
    protected Map<String, ContainerMetadataNode> children;
    protected final transient Gson gson;

    public ContainerMetadataNode() {
        this.gson = JqUtils.buildGson(null);
        this.attributes = new HashMap();
        this.children = new HashMap<String, ContainerMetadataNode>();
        this.path = "";
        this.addPathsRecursive();
    }

    public ContainerMetadataNode(HashMap<String, JsonElement> attributes, Map<String, ContainerMetadataNode> children, Gson gson) {
        this.attributes = attributes;
        this.children = children;
        this.gson = gson;
    }

    public ContainerMetadataNode(JsonObject attributes, Map<String, ContainerMetadataNode> children, Gson gson) {
        this.attributes = (HashMap)gson.fromJson((JsonElement)attributes, TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{String.class, JsonElement.class}).getType());
        this.children = children;
        this.gson = gson;
    }

    public ContainerMetadataNode(ContainerMetadataNode other) {
        this.gson = other.gson;
        this.attributes = other.attributes;
        this.children = other.children;
    }

    public HashMap<String, JsonElement> getContainerAttributes() {
        return this.attributes;
    }

    public JsonElement getAttributes(String pathName) throws N5Exception.N5IOException {
        String groupPath = N5URI.normalizeGroupPath((String)pathName);
        Optional<ContainerMetadataNode> nodeOpt = this.getNode(groupPath);
        if (nodeOpt.isPresent()) {
            ContainerMetadataNode node = nodeOpt.get();
            return this.gson.toJsonTree(node.getContainerAttributes());
        }
        return null;
    }

    public Map<String, ContainerMetadataNode> getChildren() {
        return this.children;
    }

    public Stream<ContainerMetadataNode> getChildrenStream() {
        return this.children.entrySet().stream().map(e -> (ContainerMetadataNode)e.getValue());
    }

    public Stream<ContainerMetadataNode> flatten() {
        return Stream.concat(Stream.of(this), this.getChildrenStream().flatMap(ContainerMetadataNode::flatten));
    }

    public Stream<ContainerMetadataNode> flattenLeaves() {
        return this.flatten().filter(x -> x.getChildren().isEmpty());
    }

    public void addChild(String relativepath, ContainerMetadataNode child) {
        this.children.put(relativepath, child);
    }

    public Stream<ContainerMetadataNode> pathToChild(String path) {
        String groupSeparator = "/";
        String normPath = path.replaceAll("^(/*)|(/*$)", "");
        String thisNodePath = this.getPath();
        String relativePath = normPath;
        if (!thisNodePath.isEmpty() && normPath.startsWith(thisNodePath)) {
            relativePath = normPath.replaceFirst(thisNodePath, "");
        }
        return Stream.concat(Stream.of(this), this.children.get(relativePath).pathToChild(relativePath));
    }

    public String getPath() {
        return this.path;
    }

    public Stream<String> getChildPathsRecursive(String thisPath) {
        return Stream.concat(Stream.of(thisPath), this.children.keySet().stream().flatMap(k -> this.children.get(k).getChildPathsRecursive(thisPath + "/" + k)));
    }

    public void addPathsRecursive() {
        this.addPathsRecursive(this.getPath());
    }

    public void addPathsRecursive(String thisPath) {
        this.path = thisPath;
        for (String childPath : this.children.keySet()) {
            this.children.get(childPath).addPathsRecursive(thisPath + "/" + childPath);
        }
    }

    public Optional<ContainerMetadataNode> getParent(String path) {
        String groupSeparator = "/";
        String normPath = path.replaceAll("^(/*)|(/*$)", "");
        String parentPath = normPath.substring(0, normPath.lastIndexOf("/"));
        return this.getNode(parentPath);
    }

    public Optional<ContainerMetadataNode> getNode(String path) {
        String thisNodePath;
        String groupSeparator = "/";
        String normPath = path.replaceAll("^(/*)|(/*$)", "");
        if (normPath.startsWith(thisNodePath = this.getPath())) {
            return this.getChild(normPath.replaceFirst(thisNodePath, ""));
        }
        return Optional.empty();
    }

    public Optional<ContainerMetadataNode> getChild(String relativePath) {
        return this.getChild(relativePath, "/");
    }

    public ContainerMetadataNode childRelative(String normRelativePath) {
        String childName = normRelativePath.substring(0, normRelativePath.indexOf(47));
        if (this.children.containsKey(childName)) {
            return this.children.get(childName);
        }
        return null;
    }

    public Optional<ContainerMetadataNode> getChild(String relativePath, String groupSeparator) {
        String relToChild;
        String cpath;
        if (relativePath.isEmpty()) {
            return Optional.of(this);
        }
        String normPath = relativePath.replaceAll("^(" + groupSeparator + "*)|(" + groupSeparator + "*$)", "");
        int i = normPath.indexOf(groupSeparator);
        if (i < 0) {
            cpath = normPath;
            relToChild = "";
        } else {
            String[] pathSplit = normPath.split(groupSeparator);
            String[] relToChildList = new String[pathSplit.length - 1];
            cpath = pathSplit[0];
            System.arraycopy(pathSplit, 1, relToChildList, 0, relToChildList.length);
            relToChild = Arrays.stream(relToChildList).collect(Collectors.joining("/"));
        }
        ContainerMetadataNode c = this.children.get(cpath);
        if (c == null) {
            return Optional.empty();
        }
        return c.getChild(relToChild, groupSeparator);
    }

    public boolean exists(String pathName) {
        return this.getNode(pathName).isPresent();
    }

    public String[] list(String pathName) throws N5Exception.N5IOException {
        Optional<ContainerMetadataNode> node = this.getNode(pathName);
        if (node.isPresent()) {
            Set<String> set = node.get().getChildren().keySet();
            return set.toArray(new String[set.size()]);
        }
        return new String[0];
    }

    public <T> void setAttribute(String pathName, String key, T attribute) {
        this.setAttributes(pathName, Collections.singletonMap(key, attribute));
    }

    public void setAttributes(String pathName, Map<String, ?> attributes) {
        Type mapType = new TypeToken<HashMap<String, JsonElement>>(){}.getType();
        JsonElement json = this.gson.toJsonTree(attributes);
        HashMap map = (HashMap)this.gson.fromJson(json, mapType);
        this.getNode(pathName).ifPresent(x -> x.attributes.putAll(map));
    }

    public boolean removeAttribute(String pathName, String key) {
        Optional<ContainerMetadataNode> node = this.getNode(pathName);
        if (node.isPresent()) {
            return node.get().remove(key);
        }
        return false;
    }

    public <T> T removeAttribute(String pathName, String key, Class<T> clazz) {
        Optional<ContainerMetadataNode> node = this.getNode(pathName);
        Object t = this.getAttribute(pathName, key, clazz);
        if (t != null) {
            node.get().remove(key);
        }
        return (T)t;
    }

    public boolean removeAttributes(String pathName, List<String> attributes) {
        boolean removed = false;
        for (String attribute : attributes) {
            removed |= this.removeAttribute(pathName, attribute);
        }
        return removed;
    }

    public void createGroup(String pathName) {
        String thisNodePath;
        String groupSeparator = "/";
        String normPath = pathName.replaceAll("^(/*)|(/*$)", "");
        String relativePath = normPath.startsWith(thisNodePath = this.getPath()) ? normPath.replaceFirst(thisNodePath, "") : normPath;
        String[] parts = relativePath.split("/");
        ContainerMetadataNode.createGroupHelper(this, parts, 0);
        this.addPathsRecursive();
    }

    private static void createGroupHelper(ContainerMetadataNode node, String[] parts, int i) {
        ContainerMetadataNode child;
        if (i >= parts.length) {
            return;
        }
        String childRelpath = parts[i];
        if (!node.children.containsKey(childRelpath)) {
            child = new ContainerMetadataNode();
            node.addChild(childRelpath, child);
        } else {
            child = node.children.get(childRelpath);
        }
        ContainerMetadataNode.createGroupHelper(child, parts, i + 1);
    }

    public boolean remove(String pathName) {
        String groupSeparator = "/";
        if (this.exists(pathName)) {
            String normPath = pathName.replaceAll("^(/*)|(/*$)", "");
            if (normPath.isEmpty()) {
                return this.remove();
            }
            String name = pathName.substring(pathName.lastIndexOf("/") + 1);
            this.getParent(pathName).ifPresent(x -> x.children.remove(name));
            return !this.exists(pathName);
        }
        return false;
    }

    public boolean remove() {
        this.attributes.clear();
        this.children.clear();
        return true;
    }

    public <T> void writeBlock(String pathName, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) {
    }

    public boolean deleteBlock(String pathName, long ... gridPosition) {
        return false;
    }

    public DataBlock<?> readBlock(String pathName, DatasetAttributes datasetAttributes, long ... gridPosition) {
        return null;
    }

    public static <N extends GsonN5Reader & N5Reader> ContainerMetadataNode build(N5Reader n5, String dataset, Gson gson) {
        if (n5 instanceof GsonN5Reader) {
            try {
                return ContainerMetadataNode.buildGson((GsonN5Reader)n5, dataset, gson);
            }
            catch (Exception exception) {
            }
        } else {
            try {
                return ContainerMetadataNode.buildN5(n5, dataset, gson);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static ContainerMetadataNode build(N5Reader n5, Gson gson) {
        return ContainerMetadataNode.build(n5, "", gson);
    }

    public static <N extends GsonN5Reader & N5Reader> ContainerMetadataNode buildGson(N n5, String dataset, Gson gson) throws InterruptedException, ExecutionException {
        try {
            String[] datasets = n5.deepList(dataset, Executors.newSingleThreadExecutor());
            N5TreeNode root = N5TreeNode.fromFlatList(dataset, datasets, "/");
            ContainerMetadataNode containerRoot = ContainerMetadataNode.buildHelper(n5, root);
            containerRoot.addPathsRecursive(dataset);
            return containerRoot;
        }
        catch (N5Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <N extends GsonN5Reader> ContainerMetadataNode buildHelper(N n5, N5TreeNode baseNode) {
        JsonElement attrsRaw = n5.getAttributes(baseNode.getPath());
        JsonObject attrs = attrsRaw != null && attrsRaw.isJsonObject() ? attrsRaw.getAsJsonObject() : new JsonObject();
        List<N5TreeNode> children = baseNode.childrenList();
        HashMap<String, ContainerMetadataNode> childMap = new HashMap<String, ContainerMetadataNode>();
        for (N5TreeNode child : children) {
            childMap.put(child.getNodeName(), ContainerMetadataNode.buildHelper(n5, child));
        }
        if (attrs != null) {
            return new ContainerMetadataNode(attrs, childMap, n5.getGson());
        }
        return new ContainerMetadataNode(new HashMap<String, JsonElement>(), childMap, n5.getGson());
    }

    public static <T extends N5Reader> ContainerMetadataNode buildN5(T n5, String dataset, Gson gson) throws InterruptedException, ExecutionException {
        try {
            String[] datasets = n5.deepList(dataset, Executors.newSingleThreadExecutor());
            N5TreeNode root = N5TreeNode.fromFlatList(dataset, datasets, "/");
            ContainerMetadataNode containerRoot = ContainerMetadataNode.buildHelperN5(n5, root, gson);
            containerRoot.addPathsRecursive(dataset);
            return containerRoot;
        }
        catch (N5Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ContainerMetadataNode buildHelperN5(N5Reader n5, N5TreeNode baseNode, Gson gson) {
        Optional<HashMap<String, JsonElement>> attrs = ContainerMetadataNode.getMetadataMapN5(n5, baseNode.getPath(), gson);
        List<N5TreeNode> children = baseNode.childrenList();
        HashMap<String, ContainerMetadataNode> childMap = new HashMap<String, ContainerMetadataNode>();
        for (N5TreeNode child : children) {
            childMap.put(child.getNodeName(), ContainerMetadataNode.buildHelperN5(n5, child, gson));
        }
        if (attrs.isPresent()) {
            return new ContainerMetadataNode(attrs.get(), childMap, gson);
        }
        return new ContainerMetadataNode(new HashMap<String, JsonElement>(), childMap, gson);
    }

    public static Optional<HashMap<String, JsonElement>> getMetadataMapN5(N5Reader n5, String dataset, Gson gson) {
        try {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            Map attrClasses = n5.listAttributes(dataset);
            for (String k : attrClasses.keySet()) {
                if (((Class)attrClasses.get(k)).equals(String.class)) {
                    String s = (String)n5.getAttribute(dataset, k, String.class);
                    Optional<JsonObject> elem = ContainerMetadataNode.stringToJson(s, gson);
                    if (elem.isPresent()) {
                        attrs.put(k, elem.get());
                        continue;
                    }
                    attrs.put(k, gson.toJsonTree((Object)s));
                    continue;
                }
                attrs.put(k, gson.toJsonTree(n5.getAttribute(dataset, k, (Class)attrClasses.get(k))));
            }
            if (attrs != null) {
                return Optional.of(attrs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<JsonObject> stringToJson(String s, Gson gson) {
        try {
            JsonObject elem = (JsonObject)gson.fromJson(s, JsonObject.class);
            return Optional.of(elem);
        }
        catch (JsonSyntaxException e) {
            return Optional.empty();
        }
    }

    public String groupPath(String ... nodes) {
        return Arrays.stream(nodes).collect(Collectors.joining(","));
    }

    public Gson getGson() {
        return this.gson;
    }

    public URI getURI() {
        throw new UnsupportedOperationException("getURI not supported by ContainerMetadataNode");
    }

    public void setAttributes(String groupPath, JsonElement attributes) throws N5Exception {
    }
}

