/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.translation.JqUtils;
import org.janelia.saalfeldlab.n5.universe.translation.TranslatedN5Reader;
import picocli.CommandLine;

public class TranslateN5Tree
implements Callable<Void> {
    @CommandLine.Option(names={"-i", "--input"}, required=true, description={"N5 container."})
    private String n5ContainerPath;
    @CommandLine.Option(names={"-t", "--translation"}, required=false, description={"Translation."})
    private String translationIn;
    @CommandLine.Option(names={"-f", "--translation-file"}, required=false, description={"Translation file."})
    private String translationFilePath;

    @Override
    public Void call() throws Exception {
        N5Reader n5Base = new N5Factory().openReader(this.n5ContainerPath);
        String translation = null;
        if (this.translationIn != null) {
            translation = this.translationIn;
        } else if (this.translationFilePath != null) {
            translation = new String(Files.readAllBytes(Paths.get(this.translationFilePath, new String[0])), StandardCharsets.US_ASCII);
        }
        Gson gson = JqUtils.buildGson((N5Reader)n5Base);
        if (translation == null) {
            TranslatedN5Reader n5 = new TranslatedN5Reader(n5Base, gson, ".", ".");
            System.out.println(gson.toJson((Object)n5.getTranslation().getOrig()));
            n5.close();
        } else {
            TranslatedN5Reader n5 = new TranslatedN5Reader(n5Base, gson, translation, ".");
            System.out.println(gson.toJson((Object)n5.getTranslation().getTranslated()));
            n5.close();
        }
        return null;
    }

    public static void main(String[] args) {
        new CommandLine((Object)new TranslateN5Tree()).execute(args);
    }
}

