/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import java.text.DecimalFormat;

public class FFT_
implements PlugInFilter {
    private ImagePlus image;

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        int y;
        int x;
        int y2;
        int z;
        System.out.println("input data");
        new StackConverter(this.image).convertToGray32();
        TestData data = new TestData(this.image);
        System.out.println("output data");
        int w = this.image.getWidth();
        int h = this.image.getHeight();
        int d = this.image.getStackSize();
        for (z = 0; z < d; ++z) {
            for (y2 = 0; y2 < h; ++y2) {
                data.setOffset(z * w * h + y2 * w);
                data.setIncrement(1);
                this.four1(data, w, false);
            }
            for (x = 0; x < w; ++x) {
                data.setOffset(z * w * h + x);
                data.setIncrement(w);
                this.four1(data, h, false);
            }
            IJ.showProgress((int)z, (int)(d - 1));
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                data.setOffset(y * w + x);
                data.setIncrement(w * h);
                this.four1(data, d, false);
            }
            IJ.showProgress((int)y, (int)(h - 1));
        }
        data.show();
        for (z = 0; z < d; ++z) {
            for (y2 = 0; y2 < h; ++y2) {
                data.setOffset(z * w * h + y2 * w);
                data.setIncrement(1);
                this.four1(data, w, true);
            }
            for (x = 0; x < w; ++x) {
                data.setOffset(z * w * h + x);
                data.setIncrement(w);
                this.four1(data, h, true);
            }
        }
        for (y = 0; y < h; ++y) {
            for (x = 0; x < w; ++x) {
                data.setOffset(y * w + x);
                data.setIncrement(w * h);
                this.four1(data, d, true);
            }
        }
        data.show();
    }

    public void four1(TestData d, int nn, boolean reverse) {
        int isign = reverse ? -1 : 1;
        int j = 1;
        for (int i = 1; i < nn; ++i) {
            int m;
            if (j > i) {
                d.swap(j, i);
            }
            for (m = nn >> 1; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        for (int mmax = 2; nn >= mmax; mmax <<= 1) {
            int istep = mmax;
            double theta = (double)isign * (Math.PI * 2 / (double)mmax);
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (int m = 1; m <= mmax >> 1; ++m) {
                for (int i = m; i <= nn; i += mmax) {
                    j = i + (mmax >> 1);
                    float tempr = (float)(wr * (double)d.getRe(j) - wi * (double)d.getIm(j));
                    float tempi = (float)(wr * (double)d.getIm(j) + wi * (double)d.getRe(j));
                    d.setRe(j, d.getRe(i) - tempr);
                    d.setIm(j, d.getIm(i) - tempi);
                    d.setRe(i, d.getRe(i) + tempr);
                    d.setIm(i, d.getIm(i) + tempi);
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
        }
        if (reverse) {
            for (int i = 1; i <= nn; ++i) {
                d.setRe(i, d.getRe(i) / (float)nn);
                d.setIm(i, d.getIm(i) / (float)nn);
            }
        }
    }

    public class TestData {
        private float[][] re;
        private float[][] im;
        private int w;
        private int h;
        private int d;
        private int wh;
        private int offset = 0;
        private int incr = 1;
        DecimalFormat df = new DecimalFormat("###.##");

        public TestData(ImagePlus imp) {
            this.w = imp.getWidth();
            this.h = imp.getHeight();
            this.d = imp.getStackSize();
            this.wh = this.w * this.h;
            this.re = new float[this.d][];
            this.im = new float[this.d][];
            for (int z = 0; z < this.d; ++z) {
                this.re[z] = (float[])imp.getStack().getPixels(z + 1);
                this.im[z] = new float[this.wh];
            }
        }

        public TestData(ImageProcessor ip) {
            this.w = ip.getWidth();
            this.h = ip.getHeight();
            this.d = 1;
            this.wh = this.w * this.h;
            this.re = new float[this.d][];
            this.im = new float[this.d][];
            this.re[0] = (float[])ip.getPixels();
            this.im[0] = new float[this.wh];
        }

        public void setIncrement(int i) {
            this.incr = i;
        }

        public void setOffset(int o) {
            this.offset = o;
        }

        public float getRe(int i) {
            int j = this.offset + (i - 1) * this.incr;
            try {
                return this.re[j / this.wh][j % this.wh];
            }
            catch (RuntimeException e) {
                System.out.println("offset = " + this.offset);
                System.out.println("incr = " + this.incr);
                System.out.println("j / wh = " + j / this.wh);
                System.out.println("j % wh = " + j % this.wh);
                System.out.println(i);
                System.out.println(j);
                throw e;
            }
        }

        public float getIm(int i) {
            i = this.offset + (i - 1) * this.incr;
            return this.im[i / this.wh][i % this.wh];
        }

        public void setRe(int i, float v) {
            i = this.offset + (i - 1) * this.incr;
            this.re[i / this.wh][i % this.wh] = v;
        }

        public void setIm(int i, float v) {
            i = this.offset + (i - 1) * this.incr;
            this.im[i / this.wh][i % this.wh] = v;
        }

        public void swap(int i, int j) {
            float tmp = this.getRe(i);
            this.setRe(i, this.getRe(j));
            this.setRe(j, tmp);
            tmp = this.getIm(i);
            this.setIm(i, this.getIm(j));
            this.setIm(j, tmp);
        }

        public void show() {
            ImageStack rest = new ImageStack(this.w, this.h);
            ImageStack imst = new ImageStack(this.w, this.h);
            for (int z = 0; z < this.d; ++z) {
                rest.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, this.re[z], null));
                imst.addSlice("", (ImageProcessor)new FloatProcessor(this.w, this.h, this.im[z], null));
            }
            new ImagePlus("re", rest).show();
            new ImagePlus("im", imst).show();
        }
    }
}

