/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import process3d.Gradient;
import process3d.Rebin;

public class Gradient_
extends Gradient
implements PlugInFilter {
    private static final String CALIBRATION_KEY = "VIB.Gradient.calibration";
    private static final boolean DEFAULT_CALIBRATION = true;
    private ImagePlus image;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 5;
    }

    public void run(ImageProcessor ip) {
        boolean useCalibration = Prefs.get((String)CALIBRATION_KEY, (boolean)true);
        GenericDialog gd = new GenericDialog("Gradient_");
        gd.addCheckbox("Use calibration", useCalibration);
        gd.addHelp("http://imagej.net/3D_Binary_Filters");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        useCalibration = gd.getNextBoolean();
        Prefs.set((String)CALIBRATION_KEY, (boolean)useCalibration);
        ImagePlus grad = Gradient_.calculateGrad((ImagePlus)this.image, (boolean)useCalibration);
        Rebin.rebin((ImagePlus)grad, (int)256).show();
    }
}

