/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import process3d.Convolve3d;
import process3d.Rebin_;

public class Laplace_
implements PlugInFilter {
    private ImagePlus image;
    float tolerance = 5.0f;

    public int setup(String arg, ImagePlus img) {
        this.image = img;
        return 5;
    }

    public void run(ImageProcessor ip) {
        ImagePlus laplace = Laplace_.calculateLaplace_(this.image);
        ImagePlus rebinned = Rebin_.rebin((ImagePlus)laplace, (int)256);
        rebinned.show();
    }

    public static ImagePlus calculateLaplace_(ImagePlus imp) {
        IJ.showStatus((String)"Calculating laplace");
        float[] H_x = new float[]{1.0f, -2.0f, 1.0f};
        ImagePlus g_x = Convolve3d.convolveX((ImagePlus)imp, (float[])H_x);
        float[] H_y = new float[]{1.0f, -2.0f, 1.0f};
        ImagePlus g_y = Convolve3d.convolveY((ImagePlus)imp, (float[])H_y);
        float[] H_z = new float[]{1.0f, -2.0f, 1.0f};
        ImagePlus g_z = Convolve3d.convolveZ((ImagePlus)imp, (float[])H_z);
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getStackSize();
        ImageStack grad = new ImageStack(w, h);
        for (int z = 0; z < d; ++z) {
            FloatProcessor res = new FloatProcessor(w, h);
            grad.addSlice("", (ImageProcessor)res);
            float[] values = (float[])res.getPixels();
            float[] x_ = (float[])g_x.getStack().getProcessor(z + 1).getPixels();
            float[] y_ = (float[])g_y.getStack().getProcessor(z + 1).getPixels();
            float[] z_ = (float[])g_z.getStack().getProcessor(z + 1).getPixels();
            for (int i = 0; i < w * h; ++i) {
                values[i] = (float)Math.sqrt(x_[i] * x_[i] + y_[i] * y_[i] + z_[i] * z_[i]);
            }
        }
        return new ImagePlus("Laplacian", grad);
    }
}

