/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.image.ColorModel;
import java.util.Arrays;
import util.Limits;

public class Histogram_2D
implements PlugIn {
    int binsA;
    int binsB;
    long totalValues;
    long[][] counts;
    double minValueA;
    double maxValueA;
    double minValueB;
    double maxValueB;
    double rangeWidthA;
    double rangeWidthB;
    long countMin;
    long countMax;
    int[] dimensions;
    int width;
    int depth;
    int height;
    int typeA;
    int typeB;
    int bitDepthA;
    int bitDepthB;
    byte[] pixelsABytes;
    byte[] pixelsBBytes;
    short[] pixelsAShorts;
    short[] pixelsBShorts;
    float[] pixelsAFloats;
    float[] pixelsBFloats;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int CHANNELS = 2;
    public static final int SLICES = 3;
    public static final int FRAMES = 4;
    public static final int PROBABILITIES = 0;
    public static final int LOG_PROBABILITIES = 1;
    public static final int SELF_INFORMATION = 2;

    public Histogram_2D() {
        this.counts = new long[this.binsA][this.binsB];
        this.pixelsABytes = null;
        this.pixelsBBytes = null;
        this.pixelsAShorts = null;
        this.pixelsBShorts = null;
        this.pixelsAFloats = null;
        this.pixelsBFloats = null;
    }

    public Statistics getStatistics(double minimumXThreshold, double maximumXThreshold, double minimumYThreshold, double maximumYThreshold) {
        Statistics result = new Statistics();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumXX = 0.0;
        double sumYY = 0.0;
        long n = 0L;
        IJ.showStatus((String)"Calculating statistics");
        IJ.showProgress((double)0.0);
        double meanX = 0.0;
        double meanY = 0.0;
        double varX = 0.0;
        double varY = 0.0;
        double sdX = 0.0;
        double sdY = 0.0;
        double correlation = 0.0;
        double numeratorSum = 0.0;
        double denominatorSum = 0.0;
        double covarianceSum = 0.0;
        double covariance = 0.0;
        for (int pass = 0; pass < 2; ++pass) {
            for (int z = 0; z < this.depth; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        float valueA = -1.0f;
                        float valueB = -1.0f;
                        if (this.bitDepthA == 8) {
                            valueA = this.pixelsABytes[y * this.width + x] & 0xFF;
                        } else if (this.bitDepthA == 16) {
                            valueA = this.pixelsAShorts[y * this.width + x];
                        } else if (this.bitDepthA == 32) {
                            valueA = this.pixelsAFloats[y * this.width + x];
                        }
                        if (this.bitDepthB == 8) {
                            valueB = this.pixelsBBytes[y * this.width + x] & 0xFF;
                        } else if (this.bitDepthB == 16) {
                            valueB = this.pixelsBShorts[y * this.width + x];
                        } else if (this.bitDepthB == 32) {
                            valueB = this.pixelsBFloats[y * this.width + x];
                        }
                        if (pass == 0) {
                            if (!((double)valueA >= minimumXThreshold) || !((double)valueB >= minimumYThreshold) || !((double)valueA <= maximumXThreshold) || !((double)valueB <= maximumYThreshold)) continue;
                            sumX += (double)valueA;
                            sumY += (double)valueB;
                            sumXX += (double)(valueA * valueA);
                            sumXY += (double)(valueA * valueB);
                            sumYY += (double)(valueB * valueB);
                            ++n;
                            continue;
                        }
                        double xResidual = (double)valueA - meanX;
                        double yResidual = (double)valueB - meanY;
                        numeratorSum += xResidual * yResidual;
                        denominatorSum += xResidual * xResidual;
                        covarianceSum += xResidual * yResidual;
                    }
                }
                IJ.showProgress((double)((double)z / (double)this.depth));
            }
            if (pass != 0) continue;
            meanX = sumX / (double)n;
            meanY = sumY / (double)n;
            varX = sumXX / (double)n - meanX * meanX;
            varY = sumYY / (double)n - meanY * meanY;
            sdX = Math.sqrt(varX);
            sdY = Math.sqrt(varY);
        }
        IJ.showProgress((double)1.0);
        result.sumX = sumX;
        result.sumY = sumY;
        result.sumXX = sumXX;
        result.sumXY = sumXY;
        result.sumYY = sumYY;
        result.n = n;
        result.minimumXThreshold = minimumXThreshold;
        result.minimumYThreshold = minimumYThreshold;
        result.maximumXThreshold = maximumXThreshold;
        result.maximumYThreshold = maximumYThreshold;
        result.meanX = meanX;
        result.meanY = meanY;
        result.varX = varX;
        result.varY = varY;
        result.sdX = sdX;
        result.sdY = sdY;
        result.numeratorSum = numeratorSum;
        result.denominatorSum = denominatorSum;
        result.covariance = covarianceSum / (double)n;
        result.correlation = covarianceSum / (double)n / (sdX * sdY);
        return result;
    }

    public double[] getMinimumThresholdsForCorrelation(Statistics overall) {
        double[] result = new double[2];
        double thresholdA = this.maxValueA;
        do {
            double thresholdB = thresholdA * overall.getFittedGradient() + overall.getFittedYIntercept();
            Statistics s = this.getStatistics(this.minValueA, thresholdA, this.minValueB, thresholdB);
            System.out.println("Width thresholdA: " + thresholdA + ", thresholdB: " + thresholdB + " got correlation: " + s.correlation);
            thresholdA -= this.rangeWidthA / (double)this.binsA;
            if (!(s.correlation <= 0.0)) continue;
            result[0] = thresholdA;
            result[1] = thresholdB;
            return result;
        } while (!(thresholdA < this.minValueA));
        result[0] = this.minValueA;
        result[1] = this.minValueB;
        return result;
    }

    protected void start2DHistogram(double minValueA, double maxValueA, double minValueB, double maxValueB, int binsA, int binsB) {
        this.binsA = binsA;
        this.binsB = binsB;
        this.totalValues = 0L;
        this.counts = new long[binsA][binsB];
        this.minValueA = minValueA;
        this.maxValueA = maxValueA;
        this.minValueB = minValueB;
        this.maxValueB = maxValueB;
        this.rangeWidthA = maxValueA - minValueA;
        this.rangeWidthB = maxValueB - minValueB;
        this.countMin = Long.MAX_VALUE;
        this.countMax = Long.MIN_VALUE;
    }

    public boolean allowedBitDepth(int bitDepth) {
        return bitDepth == 8 || bitDepth == 16 || bitDepth == 32;
    }

    public boolean addImagePlusPair(ImagePlus imageA, ImagePlus imageB) {
        return this.addImagePlusPair(imageA, imageB, 256);
    }

    public boolean addImagePlusPair(ImagePlus imageA, ImagePlus imageB, int bins) {
        float[] valueRangeA = Limits.getStackLimits((ImagePlus)imageA, (boolean)true);
        float[] valueRangeB = Limits.getStackLimits((ImagePlus)imageB, (boolean)true);
        return this.addImagePlusPair(imageA, imageB, valueRangeA[0], valueRangeA[1], valueRangeB[0], valueRangeB[1], bins, bins);
    }

    public boolean addImagePlusPair(ImagePlus imageA, ImagePlus imageB, double minimumA, double maximumA, double minimumB, double maximumB, int binsA, int binsB) {
        imageA.getProcessor().setMinAndMax(minimumA, maximumA);
        imageB.getProcessor().setMinAndMax(minimumB, maximumB);
        ImageStack stackA = imageA.getStack();
        ImageStack stackB = imageB.getStack();
        this.dimensions = imageA.getDimensions();
        int[] dimensionsB = imageB.getDimensions();
        if (!Arrays.equals(this.dimensions, dimensionsB)) {
            IJ.error((String)"The two images must be of the same dimensions.");
            return false;
        }
        if (this.dimensions[4] != 1) {
            IJ.error((String)"Currently this plugin does not work with time series");
            return false;
        }
        if (this.dimensions[2] != 1) {
            IJ.error((String)"Currently this plugin does not work with composite images (i.e. those with multiple channels)");
            return false;
        }
        this.depth = imageA.getStackSize();
        this.width = imageA.getWidth();
        this.height = imageA.getHeight();
        this.typeA = imageA.getType();
        this.typeB = imageB.getType();
        this.bitDepthA = imageA.getBitDepth();
        this.bitDepthB = imageB.getBitDepth();
        this.pixelsABytes = null;
        this.pixelsBBytes = null;
        this.pixelsAShorts = null;
        this.pixelsBShorts = null;
        this.pixelsAFloats = null;
        this.pixelsBFloats = null;
        if (!this.allowedBitDepth(this.bitDepthA)) {
            IJ.error((String)("" + imageA.getTitle() + " has an unsupported bit depth: " + this.bitDepthA));
            return false;
        }
        if (!this.allowedBitDepth(this.bitDepthB)) {
            IJ.error((String)("" + imageB.getTitle() + " has an unsupported bit depth: " + this.bitDepthB));
            return false;
        }
        this.start2DHistogram(minimumA, maximumA, minimumB, maximumB, binsA, binsB);
        IJ.showStatus((String)"Binning image values...");
        IJ.showProgress((double)0.0);
        float valueA = -1.0f;
        float valueB = -1.0f;
        for (int z = 0; z < this.depth; ++z) {
            if (this.bitDepthA == 8) {
                this.pixelsABytes = (byte[])stackA.getPixels(z + 1);
            } else if (this.bitDepthA == 16) {
                this.pixelsAShorts = (short[])stackA.getPixels(z + 1);
            } else if (this.bitDepthA == 32) {
                this.pixelsAFloats = (float[])stackA.getPixels(z + 1);
            }
            if (this.bitDepthB == 8) {
                this.pixelsBBytes = (byte[])stackB.getPixels(z + 1);
            } else if (this.bitDepthB == 16) {
                this.pixelsBShorts = (short[])stackB.getPixels(z + 1);
            } else if (this.bitDepthB == 32) {
                this.pixelsBFloats = (float[])stackB.getPixels(z + 1);
            }
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (this.bitDepthA == 8) {
                        valueA = this.pixelsABytes[y * this.width + x] & 0xFF;
                    } else if (this.bitDepthA == 16) {
                        valueA = this.pixelsAShorts[y * this.width + x];
                    } else if (this.bitDepthA == 32) {
                        valueA = this.pixelsAFloats[y * this.width + x];
                    }
                    if (this.bitDepthB == 8) {
                        valueB = this.pixelsBBytes[y * this.width + x] & 0xFF;
                    } else if (this.bitDepthB == 16) {
                        valueB = this.pixelsBShorts[y * this.width + x];
                    } else if (this.bitDepthB == 32) {
                        valueB = this.pixelsBFloats[y * this.width + x];
                    }
                    int i1 = (int)Math.floor(((double)valueA - this.minValueA) * (double)binsA / this.rangeWidthA);
                    int i2 = (int)Math.floor(((double)valueB - this.minValueB) * (double)binsB / this.rangeWidthB);
                    if (i1 >= binsA) {
                        i1 = binsA - 1;
                    }
                    if (i2 >= binsB) {
                        i2 = binsB - 1;
                    }
                    long[] lArray = this.counts[i1];
                    int n = i2;
                    lArray[n] = lArray[n] + 1L;
                    ++this.totalValues;
                }
            }
            IJ.showProgress((double)((double)z / (double)this.depth));
        }
        IJ.showProgress((double)1.0);
        for (int a = 0; a < binsA; ++a) {
            for (int b = 0; b < binsB; ++b) {
                if (this.counts[a][b] < this.countMin) {
                    this.countMin = this.counts[a][b];
                }
                if (this.counts[a][b] <= this.countMax) continue;
                this.countMax = this.counts[a][b];
            }
        }
        return true;
    }

    public ImagePlus[] getHistogramImages() {
        System.out.println("totalValues is: " + this.totalValues);
        double[][] p = new double[this.binsA][this.binsB];
        double[][] selfInformation = new double[this.binsA][this.binsB];
        for (int avalue = 0; avalue < this.binsA; ++avalue) {
            for (int bvalue = 0; bvalue < this.binsB; ++bvalue) {
                p[avalue][bvalue] = (double)this.counts[avalue][bvalue] / (double)this.totalValues;
                selfInformation[avalue][bvalue] = -Math.log(p[avalue][bvalue]) / Math.log(2.0);
            }
        }
        float[] floatValues = new float[this.binsA * this.binsB];
        for (int avalue = 0; avalue < this.binsA; ++avalue) {
            for (int bvalue = 0; bvalue < this.binsB; ++bvalue) {
                floatValues[(this.binsB - 1 - bvalue) * this.binsA + avalue] = (float)p[avalue][bvalue];
            }
        }
        FloatProcessor fp = new FloatProcessor(this.binsA, this.binsB);
        fp.setPixels((Object)floatValues);
        ImageStack newStack = new ImageStack(this.binsA, this.binsB);
        newStack.addSlice("", (ImageProcessor)fp);
        ImagePlus probImagePlus = new ImagePlus("2D Histogram Log Probabilities", newStack);
        float[] floatValues2 = new float[this.binsA * this.binsB];
        for (int avalue = 0; avalue < this.binsA; ++avalue) {
            for (int bvalue = 0; bvalue < this.binsB; ++bvalue) {
                floatValues2[(this.binsB - 1 - bvalue) * this.binsA + avalue] = (float)Math.log(p[avalue][bvalue]);
            }
        }
        FloatProcessor fp2 = new FloatProcessor(this.binsA, this.binsB);
        fp2.setPixels((Object)floatValues2);
        ImageStack newStack2 = new ImageStack(this.binsA, this.binsB);
        newStack2.addSlice("", (ImageProcessor)fp2);
        ImagePlus logProbImagePlus = new ImagePlus("2D Histogram Probabilities", newStack2);
        float[] selfValues = new float[this.binsA * this.binsB];
        for (int avalue = 0; avalue < this.binsA; ++avalue) {
            for (int bvalue = 0; bvalue < this.binsB; ++bvalue) {
                selfValues[(this.binsB - 1 - bvalue) * this.binsA + avalue] = (float)selfInformation[avalue][bvalue];
            }
        }
        FloatProcessor selfFP = new FloatProcessor(this.binsA, this.binsB);
        selfFP.setPixels((Object)selfValues);
        ImageStack selfNewStack = new ImageStack(this.binsA, this.binsB);
        selfNewStack.addSlice("", (ImageProcessor)selfFP);
        ImagePlus selfNewImagePlus = new ImagePlus("2D Histogram Self Information", selfNewStack);
        ImagePlus[] result = new ImagePlus[]{probImagePlus, logProbImagePlus, selfNewImagePlus};
        IJ.showStatus((String)"Setting limits for each histogram");
        for (ImagePlus i : result) {
            float[] valueRange = Limits.getStackLimits((ImagePlus)i, (boolean)true);
            System.out.println("Got valueRange: " + valueRange[0] + " -> " + valueRange[1]);
            i.getProcessor().setMinAndMax((double)valueRange[0], (double)valueRange[1]);
        }
        return result;
    }

    public ImagePlus frame2DHistogram(String title, ImagePlus histogram, String xLabel, double xmin, double xmax, String yLabel, double ymin, double ymax, int method, Statistics statistics) {
        int tickSize = 5;
        int tickMargin = 10;
        boolean serifFont = false;
        int fontSize = 10;
        int titleSize = 12;
        int leftBorder = 100;
        int rightBorder = 180;
        int topBorder = 60;
        int bottomBorder = 100;
        if (histogram.getType() != 2) {
            IJ.error((String)"frame2DHistogram only works on GRAY32 (Float) 2D histogram images");
            return null;
        }
        if (histogram.getStackSize() != 1) {
            IJ.error((String)"The histogram must not be a stack.");
            return null;
        }
        ColorModel colorModel = histogram.getProcessor().getColorModel();
        int oldWidth = histogram.getWidth();
        int oldHeight = histogram.getHeight();
        FloatProcessor oldFP = (FloatProcessor)histogram.getProcessor();
        float oldMin = (float)oldFP.getMin();
        float oldMax = (float)oldFP.getMax();
        float[] oldFloats = (float[])oldFP.getPixels();
        int newWidth = oldWidth + leftBorder + rightBorder;
        int newHeight = oldHeight + topBorder + bottomBorder;
        float[] newFloats = new float[newWidth * newHeight];
        for (int i = 0; i < newFloats.length; ++i) {
            newFloats[i] = oldMax;
        }
        for (int y = 0; y < oldHeight; ++y) {
            for (int x = 0; x < oldWidth; ++x) {
                newFloats[(y + topBorder) * newWidth + (x + leftBorder)] = oldFloats[y * oldWidth + x];
            }
        }
        FloatProcessor newFP = new FloatProcessor(newWidth, newHeight);
        newFP.setPixels((Object)newFloats);
        newFP.setMinAndMax((double)oldMin, (double)oldMax);
        newFP.setValue((double)oldMin);
        newFP.drawLine(leftBorder, topBorder + oldHeight, leftBorder, topBorder + oldHeight + tickSize);
        newFP.drawLine(leftBorder + oldWidth - 1, topBorder + oldHeight, leftBorder + oldWidth - 1, topBorder + oldHeight + tickSize);
        newFP.drawLine(leftBorder - 1, topBorder, leftBorder - 1 - tickSize, topBorder);
        newFP.drawLine(leftBorder - 1, topBorder + oldHeight - 1, leftBorder - 1 - tickSize, topBorder + oldHeight - 1);
        ImagePlus newImagePlus = new ImagePlus("Framed Histogram", (ImageProcessor)newFP);
        if (colorModel != null) {
            newImagePlus.getProcessor().setColorModel(colorModel);
        }
        String fontName = serifFont ? "Serif" : "SanSerif";
        int fontType = 0;
        Font font = new Font(fontName, fontType, fontSize);
        newImagePlus.show();
        ImageCanvas ic = newImagePlus.getCanvas();
        FontMetrics fm = ic.getFontMetrics(font);
        newFP.setFont(font);
        newFP.setAntialiasedText(true);
        String sXmin = "" + xmin;
        String sXmax = "" + xmax;
        String sYmin = "" + ymin;
        String sYmax = "" + ymax;
        newFP.drawString(sXmin, leftBorder - fm.stringWidth(sXmin) / 2, topBorder + oldHeight + tickMargin + fm.getHeight());
        newFP.drawString(sXmax, leftBorder + oldWidth - fm.stringWidth(sXmax) / 2, topBorder + oldHeight + tickSize + tickMargin + fm.getHeight());
        newFP.drawString(sYmin, leftBorder - tickMargin - fm.stringWidth(sYmin) - tickSize, topBorder + oldHeight + fm.getHeight() / 2);
        newFP.drawString(sYmax, leftBorder - tickMargin - fm.stringWidth(sYmax) - tickSize, topBorder + fm.getHeight() / 2);
        newFP.drawString(xLabel, leftBorder + oldWidth / 2 - fm.stringWidth(xLabel) / 2, topBorder + oldHeight + tickSize + 2 * tickMargin + 2 * fm.getHeight());
        int labelWidth = fm.stringWidth(yLabel);
        int labelHeight = fm.getHeight();
        FloatProcessor fpToRotate = new FloatProcessor(labelWidth, labelHeight);
        float[] labelFloats = new float[labelWidth * labelHeight];
        for (int i = 0; i < labelFloats.length; ++i) {
            labelFloats[i] = oldMax;
        }
        fpToRotate.setFont(font);
        fpToRotate.setPixels((Object)labelFloats);
        fpToRotate.setValue((double)oldMin);
        fpToRotate.setMinAndMax((double)oldMin, (double)oldMax);
        fpToRotate.drawString(yLabel, 0, labelHeight);
        int yLabelTopLeftX = leftBorder - tickSize - tickMargin - labelHeight * 2;
        int yLabelTopLeftY = topBorder + oldHeight / 2 - labelWidth / 2;
        for (int y = 0; y < labelHeight; ++y) {
            for (int x = 0; x < labelWidth; ++x) {
                int newX = yLabelTopLeftX + y;
                int newY = yLabelTopLeftY + labelWidth - x;
                newFloats[newY * newWidth + newX] = labelFloats[y * labelWidth + x];
            }
        }
        int barWidth = 30;
        int barHeight = oldHeight * 2 / 3;
        int barTopLeftX = leftBorder + oldWidth + 40;
        int barTopLeftY = topBorder + (oldHeight - barHeight) / 2;
        newFP.drawRect(barTopLeftX, barTopLeftY, barWidth + 2, barHeight + 2);
        for (int barOffset = 0; barOffset < barHeight; ++barOffset) {
            int barLineX1 = barTopLeftX + 1;
            int barLineX2 = barTopLeftX + barWidth;
            int barLineY = barTopLeftY + 1 + (barHeight - (barOffset + 1));
            float value = (float)barOffset * (oldMax - oldMin) / (float)(barHeight - 1) + oldMin;
            newFP.setValue((double)value);
            newFP.drawLine(barLineX1, barLineY, barLineX2, barLineY);
        }
        newFP.setValue((double)oldMin);
        newFP.drawLine(barTopLeftX + barWidth + 2, barTopLeftY, barTopLeftX + barWidth + 2 + tickSize, barTopLeftY);
        newFP.drawString("" + oldMax, barTopLeftX + barWidth + 2 + tickSize + tickMargin, barTopLeftY + fm.getHeight() / 2);
        newFP.drawLine(barTopLeftX + barWidth + 2, barTopLeftY + barHeight + 1, barTopLeftX + barWidth + 2 + tickSize, barTopLeftY + barHeight + 1);
        newFP.drawString("" + oldMin, barTopLeftX + barWidth + 2 + tickSize + tickMargin, barTopLeftY + barHeight + fm.getHeight() / 2);
        fontType = 1;
        Font titleFont = new Font(fontName, fontType, titleSize);
        FontMetrics titleFM = ic.getFontMetrics(font);
        newFP.setFont(titleFont);
        newFP.drawString(title, newWidth / 2 - titleFM.stringWidth(title) / 2, topBorder / 2 + titleFM.getHeight() / 2);
        if (statistics != null) {
            newFP.drawPixel(10, 10);
            double fittedGradient = statistics.getFittedGradient();
            double fittedYIntercept = statistics.getFittedYIntercept();
            if (fittedGradient <= 1.0) {
                for (int xBin = 0; xBin < this.binsA; ++xBin) {
                    double realX = this.minValueA + (double)(((float)xBin + 0.5f) / (float)this.binsA) * this.rangeWidthA;
                    System.out.println("xBin " + xBin + " mapped to " + realX);
                    double realY = fittedGradient * realX + fittedYIntercept;
                    int yBin = (int)Math.floor((realY - this.minValueB) * (double)this.binsB / this.rangeWidthB);
                    System.out.println("bin: (" + xBin + "," + yBin + ")");
                    if (yBin < 0 || yBin >= this.binsB) continue;
                    newFP.setValue(xBin % 2 == 0 ? (double)oldMin : (double)oldMax);
                    newFP.drawPixel(leftBorder + xBin, topBorder + oldHeight - yBin);
                }
            } else {
                for (int yBin = 0; yBin < this.binsB; ++yBin) {
                    double realY = this.minValueB + (double)(((float)yBin + 0.5f) / (float)this.binsB) * this.rangeWidthB;
                    System.out.println("yBin " + yBin + " mapped to " + realY);
                    double realX = (float)((realY - fittedYIntercept) / fittedGradient);
                    int xBin = (int)Math.floor((realX - this.minValueA) * (double)this.binsA / this.rangeWidthA);
                    System.out.println("bin: (" + xBin + "," + yBin + ")");
                    if (xBin < 0 || xBin >= this.binsB) continue;
                    newFP.setValue(yBin % 2 == 0 ? (double)oldMin : (double)oldMax);
                    newFP.drawPixel(leftBorder + xBin, topBorder + oldHeight - yBin);
                }
            }
        }
        newImagePlus.updateAndRepaintWindow();
        return newImagePlus;
    }

    public void run(String ignored) {
        String titleSubstring = "";
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.error((String)"No images are open.");
            return;
        }
        String[] matchingTitles = new String[wList.length];
        ImagePlus[] matchingImagePlus = new ImagePlus[wList.length];
        ImagePlus[] allImages = new ImagePlus[wList.length];
        int totalMatchingTitles = 0;
        for (int i = 0; i < wList.length; ++i) {
            String title;
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            String string = title = imp == null ? "" : imp.getTitle();
            if (title.indexOf(titleSubstring) >= 0) {
                matchingTitles[totalMatchingTitles] = title;
                matchingImagePlus[totalMatchingTitles] = imp;
                ++totalMatchingTitles;
            }
            allImages[i] = imp;
        }
        if (totalMatchingTitles < 2) {
            IJ.error((String)("There are only " + totalMatchingTitles + " matching images; need at least 2."));
            return;
        }
        String[] onlyMatchingTitles = new String[totalMatchingTitles];
        System.arraycopy(matchingTitles, 0, onlyMatchingTitles, 0, totalMatchingTitles);
        ImagePlus[] onlyMatchingImagePlus = new ImagePlus[totalMatchingTitles];
        System.arraycopy(matchingImagePlus, 0, onlyMatchingImagePlus, 0, totalMatchingTitles);
        String[] methods = new String[]{"p (Probability)", "ln(p) (Log Probabilities)", "-log\u2082(p) (Self-information)"};
        GenericDialog gd = new GenericDialog("2D Histogram");
        gd.addChoice("A:", onlyMatchingTitles, onlyMatchingTitles[0]);
        gd.addChoice("B:", onlyMatchingTitles, onlyMatchingTitles[1]);
        gd.addChoice("Values to plot: ", methods, methods[1]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int[] index = new int[]{gd.getNextChoiceIndex(), gd.getNextChoiceIndex()};
        int method = gd.getNextChoiceIndex();
        ImagePlus imageA = onlyMatchingImagePlus[index[0]];
        ImagePlus imageB = onlyMatchingImagePlus[index[1]];
        float[] valueRangeA = Limits.getStackLimits((ImagePlus)imageA, (boolean)true);
        float[] valueRangeB = Limits.getStackLimits((ImagePlus)imageB, (boolean)true);
        double minimumA = valueRangeA[0];
        double maximumA = valueRangeA[1];
        double minimumB = valueRangeB[0];
        double maximumB = valueRangeB[1];
        GenericDialog limitsDialog = new GenericDialog("2D Histogram Limits");
        limitsDialog.addMessage("(If in doubt, leave these at the default values.)");
        limitsDialog.addNumericField("Minimum in " + imageA.getTitle(), minimumA, 10, 15, "");
        limitsDialog.addNumericField("Maximum in " + imageA.getTitle(), maximumA, 10, 15, "");
        limitsDialog.addNumericField("Minimum in " + imageB.getTitle(), minimumB, 10, 15, "");
        limitsDialog.addNumericField("Maximum in " + imageB.getTitle(), maximumB, 10, 15, "");
        limitsDialog.addMessage("");
        int binsA = 256;
        int binsB = 256;
        limitsDialog.addNumericField("Bins for " + imageA.getTitle(), (double)binsA, 0, 4, "");
        limitsDialog.addNumericField("Bins for " + imageB.getTitle(), (double)binsB, 0, 4, "");
        limitsDialog.showDialog();
        if (limitsDialog.wasCanceled()) {
            return;
        }
        if (!(minimumA < maximumA) || !(minimumB < maximumB)) {
            IJ.error((String)"The minimum must be less than the maximum for each image.");
            return;
        }
        minimumA = limitsDialog.getNextNumber();
        maximumA = limitsDialog.getNextNumber();
        minimumB = limitsDialog.getNextNumber();
        maximumB = limitsDialog.getNextNumber();
        binsA = (int)limitsDialog.getNextNumber();
        binsB = (int)limitsDialog.getNextNumber();
        if (binsA <= 0 || binsB <= 0) {
            IJ.error((String)"The number of bins for each image must be non-negative");
        }
        this.addImagePlusPair(imageA, imageB, minimumA, maximumA, minimumB, maximumB, binsA, binsB);
        double binWidthA = this.rangeWidthA / (double)binsA;
        double binWidthB = this.rangeWidthB / (double)binsB;
        Statistics allValues = this.getStatistics(minimumA + binWidthA, maximumA - binWidthA, minimumB + binWidthB, maximumB - binWidthB);
        System.out.println("--------------------------------------------");
        allValues.print();
        System.out.println("fitted gradient is: " + allValues.getFittedGradient());
        System.out.println("fitted Y intercept is: " + allValues.getFittedYIntercept());
        ImagePlus[] results = this.getHistogramImages();
        double[] correlationThresholds = this.getMinimumThresholdsForCorrelation(allValues);
        IJ.runPlugIn((ImagePlus)results[method], (String)"ij.plugin.LutLoader", (String)"fire");
        this.frame2DHistogram(methods[method] + " for Corresponding Values", results[method], imageA.getTitle(), minimumA, maximumA, imageB.getTitle(), minimumB, maximumB, method, allValues);
    }

    public class HistogramOptionsDialog
    extends Dialog {
        HistogramOptionsDialog() {
            super((Frame)IJ.getInstance());
        }
    }

    public class Statistics {
        public double sumX;
        public double sumY;
        public double sumXY;
        public double sumXX;
        public double sumYY;
        public long n;
        public double minimumXThreshold = 1.4E-45f;
        public double minimumYThreshold = 1.4E-45f;
        public double maximumXThreshold = 3.4028234663852886E38;
        public double maximumYThreshold = 3.4028234663852886E38;
        public double meanX;
        public double meanY;
        public double sdX;
        public double sdY;
        public double varX;
        public double varY;
        public double numeratorSum;
        public double denominatorSum;
        public double covariance;
        public double correlation;

        public void print() {
            System.out.println("== meanX: " + this.meanX);
            System.out.println("== meanY: " + this.meanY);
            System.out.println("== covariance: " + this.covariance);
            System.out.println("== correlation: " + this.correlation);
            System.out.println("== fitted gradient: " + this.getFittedGradient());
            System.out.println("== fitted Y intercept: " + this.getFittedYIntercept());
            System.out.println("== n: " + this.n);
            System.out.println("== sumX: " + this.sumX);
            System.out.println("== sumY: " + this.sumY);
            System.out.println("== sumXX: " + this.sumXX);
            System.out.println("== sumXY: " + this.sumXY);
            System.out.println("== sumYY: " + this.sumYY);
        }

        public double getFittedGradient() {
            return this.numeratorSum / this.denominatorSum;
        }

        public double getFittedYIntercept() {
            return this.meanY - this.getFittedGradient() * this.meanX;
        }
    }
}

