/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.behaviors.interpolators.KBCubicSplineCurve;
import org.jogamp.java3d.utils.behaviors.interpolators.KBCubicSplineSegment;
import org.jogamp.java3d.utils.behaviors.interpolators.KBKeyFrame;
import org.jogamp.java3d.utils.behaviors.interpolators.KBSplinePathInterpolator;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

public class KBRotPosScaleSplinePathInterpolator
extends KBSplinePathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Matrix4d pitchMat = new Matrix4d();
    private Matrix4d bankMat = new Matrix4d();
    private Matrix4d tMat = new Matrix4d();
    private Matrix4d sMat = new Matrix4d();
    private Vector3f iPos = new Vector3f();
    private Point3f iScale = new Point3f();
    float iHeading;
    float iPitch;
    float iBank;
    KBCubicSplineCurve cubicSplineCurve = new KBCubicSplineCurve();
    KBCubicSplineSegment[] cubicSplineSegments;
    int numSegments;
    int currentSegmentIndex;
    KBCubicSplineSegment currentSegment;

    KBRotPosScaleSplinePathInterpolator() {
    }

    public KBRotPosScaleSplinePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, KBKeyFrame[] keys) {
        super(alpha, target, axisOfTransform, keys);
        this.cubicSplineCurve = new KBCubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public void setAxisOfRotPosScale(Transform3D axisOfRotPosScale) {
        this.setTransformAxis(axisOfRotPosScale);
    }

    public Transform3D getAxisOfRotPosScale() {
        return this.getTransformAxis();
    }

    @Override
    public void setKeyFrame(int index, KBKeyFrame keyFrame) {
        super.setKeyFrame(index, keyFrame);
        this.cubicSplineCurve = new KBCubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    @Override
    public void setKeyFrames(KBKeyFrame[] keyFrame) {
        super.setKeyFrames(keyFrame);
        this.cubicSplineCurve = new KBCubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        this.computePathInterpolation(alphaValue);
        this.currentSegmentIndex = this.lowerKnot - 1;
        if (this.currentSegmentIndex == 0 && this.currentU == 0.0f) {
            this.iHeading = this.keyFrames[1].heading;
            this.iPitch = this.keyFrames[1].pitch;
            this.iBank = this.keyFrames[1].bank;
            this.iPos.set((Tuple3f)this.keyFrames[1].position);
            this.iScale.set((Tuple3f)this.keyFrames[1].scale);
        } else if (this.currentSegmentIndex == this.numSegments - 1 && (double)this.currentU == 1.0) {
            this.iHeading = this.keyFrames[this.upperKnot].heading;
            this.iPitch = this.keyFrames[this.upperKnot].pitch;
            this.iBank = this.keyFrames[this.upperKnot].bank;
            this.iPos.set((Tuple3f)this.keyFrames[this.upperKnot].position);
            this.iScale.set((Tuple3f)this.keyFrames[this.upperKnot].scale);
        } else {
            this.currentSegment = this.cubicSplineCurve.getSegment(this.currentSegmentIndex);
            this.iHeading = this.currentSegment.getInterpolatedHeading(this.currentU);
            this.iPitch = this.currentSegment.getInterpolatedPitch(this.currentU);
            this.iBank = this.currentSegment.getInterpolatedBank(this.currentU);
            this.currentSegment.getInterpolatedPositionVector(this.currentU, this.iPos);
            this.currentSegment.getInterpolatedScale(this.currentU, this.iScale);
        }
        this.pitchMat.setIdentity();
        this.pitchMat.rotX((double)(-this.iPitch));
        this.bankMat.setIdentity();
        this.bankMat.rotZ((double)this.iBank);
        this.tMat.setIdentity();
        this.tMat.rotY((double)(-this.iHeading));
        this.tMat.mul(this.pitchMat);
        this.tMat.mul(this.bankMat);
        this.sMat.set((double)this.iScale.x);
        this.tMat.mul(this.sMat);
        this.tMat.m03 = this.iPos.x;
        this.tMat.m13 = this.iPos.y;
        this.tMat.m23 = this.iPos.z;
        this.rotation.set(this.tMat);
        transform.mul(this.axis, this.rotation);
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        KBRotPosScaleSplinePathInterpolator spline = new KBRotPosScaleSplinePathInterpolator();
        spline.duplicateNode(this, forceDuplicate);
        return spline;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
        KBRotPosScaleSplinePathInterpolator interpolator = (KBRotPosScaleSplinePathInterpolator)originalNode;
        this.setAxisOfRotPosScale(interpolator.axis);
        this.target = interpolator.target;
        this.cubicSplineCurve = new KBCubicSplineCurve(interpolator.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }
}

