/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.pickfast.behaviors;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.behaviors.mouse.MouseBehaviorCallback;
import org.jogamp.java3d.utils.behaviors.mouse.MouseRotate;
import org.jogamp.java3d.utils.pickfast.behaviors.PickMouseBehavior;
import org.jogamp.java3d.utils.pickfast.behaviors.PickingCallback;

public class PickRotateBehavior
extends PickMouseBehavior
implements MouseBehaviorCallback {
    MouseRotate rotate = new MouseRotate(1);
    private PickingCallback callback = null;
    private TransformGroup currentTG;

    public PickRotateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.rotate.setTransformGroup(this.currGrp);
        this.currGrp.addChild(this.rotate);
        this.rotate.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public PickRotateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.rotate.setTransformGroup(this.currGrp);
        this.currGrp.addChild(this.rotate);
        this.rotate.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.setMode(pickMode);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        TransformGroup tg = null;
        if (!this.mevent.isMetaDown() && !this.mevent.isAltDown()) {
            this.pickCanvas.setFlags(3);
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickInfo pickInfo = this.pickCanvas.pickClosest();
            if (pickInfo != null) {
                tg = (TransformGroup)this.pickCanvas.getNode(pickInfo, 32);
                if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
                    this.rotate.setTransformGroup(tg);
                    this.rotate.wakeup();
                    this.currentTG = tg;
                }
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(0, this.currentTG);
    }

    public void setupCallback(PickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.rotate.setupCallback(null);
        } else {
            this.rotate.setupCallback(this);
        }
    }
}

