/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.batch;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.scijava.ItemVisibility;
import org.scijava.batch.ModuleBatchProcessor;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.command.DynamicCommand;
import org.scijava.convert.ConvertService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.script.ScriptService;

@Plugin(type=Command.class, label="Process Folder", menuPath="Process>Batch>Run Script from File")
public class FileScriptBatchProcessor
extends DynamicCommand {
    private final String WILDCARD = "Wildcard";
    private final String REGEX = "Regex";
    @Parameter
    private ScriptService scripts;
    @Parameter
    private CommandService commands;
    @Parameter
    private ConvertService convert;
    @Parameter(label="Script file to run", callback="scriptFileCallback")
    private File scriptFile;
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String scriptMessage = "";
    @Parameter(style="directory", callback="directoryCallback")
    private File inputFolder;
    @Parameter(label="Recursive (with subfolders)", callback="directoryCallback")
    private boolean recursive;
    @Parameter(label="File selection method", choices={"Wildcard", "Regex"}, style="radioButtonHorizontal", callback="directoryCallback")
    private String filterChoice = "Wildcard";
    @Parameter(label="File name pattern", callback="directoryCallback")
    private String pattern = "*.tif";
    @Parameter(visibility=ItemVisibility.MESSAGE, persist=false)
    private String message = " ";
    private List<File> fileList;
    private ModuleInfo moduleInfo;

    public void run() {
        if (this.fileList == null) {
            this.directoryCallback();
        }
        if (this.moduleInfo == null) {
            this.scriptFileCallback();
        }
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("moduleInfo", this.moduleInfo);
        File[] fileArray = this.fileList.toArray(new File[this.fileList.size()]);
        inputMap.put("inputFileList", fileArray);
        this.commands.run(ModuleBatchProcessor.class, true, inputMap);
    }

    private List<File> populateFileList(File folder, FilenameFilter filter, boolean rec) {
        ArrayList<File> list = new ArrayList<File>();
        if (rec) {
            for (File file : folder.listFiles((FilenameFilter)DirectoryFileFilter.DIRECTORY)) {
                list.addAll(this.populateFileList(file, filter, rec));
            }
        }
        for (File file : folder.listFiles(filter)) {
            list.add(file);
        }
        return list;
    }

    protected void directoryCallback() {
        if (this.inputFolder == null || !this.inputFolder.exists()) {
            return;
        }
        try {
            WildcardFileFilter inputFilter;
            switch (this.filterChoice) {
                case "Wildcard": {
                    inputFilter = new WildcardFileFilter(this.pattern);
                    break;
                }
                default: {
                    inputFilter = new RegexFileFilter(this.pattern);
                }
            }
            this.fileList = this.populateFileList(this.inputFolder, (FilenameFilter)inputFilter, this.recursive);
        }
        catch (PatternSyntaxException e) {
            this.fileList = null;
            this.message = "Syntax error in regex.";
        }
        if (this.fileList != null) {
            this.message = "Found " + this.fileList.size() + " files.";
        }
    }

    protected void scriptFileCallback() {
        if (this.scriptFile != null) {
            this.moduleInfo = this.scripts.getScript(this.scriptFile);
            int nCompatibleInputs = 0;
            for (ModuleItem input : this.moduleInfo.inputs()) {
                if (!this.convert.supports((Object)new File(""), input.getType())) continue;
                ++nCompatibleInputs;
            }
            this.scriptMessage = "This script contains " + nCompatibleInputs + " compatible inputs.";
        }
    }
}

