/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractHasFormat;
import io.scif.Checker;
import io.scif.config.SCIFIOConfig;
import io.scif.util.FormatTools;
import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;

public abstract class AbstractChecker
extends AbstractHasFormat
implements Checker {
    @Parameter
    private DataHandleService handles;

    @Override
    public boolean suffixNecessary() {
        return true;
    }

    @Override
    public boolean suffixSufficient() {
        return true;
    }

    @Override
    public boolean isFormat(Location loc) {
        return this.isFormat(loc, new SCIFIOConfig(this.getContext()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFormat(Location loc, SCIFIOConfig config) {
        boolean open = config.checkerIsOpen();
        if (!this.suffixSufficient() && !open) {
            return false;
        }
        if (this.suffixNecessary() || this.suffixSufficient()) {
            boolean suffixMatch = FormatTools.checkSuffix(loc.getName(), this.getFormat().getSuffixes());
            if (this.suffixNecessary() && !suffixMatch) {
                return false;
            }
            if (suffixMatch && this.suffixSufficient()) {
                return true;
            }
        }
        if (!open) {
            return false;
        }
        try (DataHandle handle = this.handles.readBuffer(loc);){
            if (handle == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = this.isFormat((DataHandle<Location>)handle);
            return bl;
        }
        catch (IOException exc) {
            this.log().debug((Object)"", (Throwable)exc);
            return false;
        }
    }

    @Override
    public boolean isFormat(DataHandle<Location> stream) throws IOException {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkHeader(byte[] block) {
        BytesLocation loc = new BytesLocation(block);
        try (DataHandle handle = (DataHandle)this.handles.create((Object)loc);){
            boolean bl = this.isFormat((DataHandle<Location>)handle);
            return bl;
        }
        catch (IOException e) {
            this.log().debug((Object)"", (Throwable)e);
            return false;
        }
    }
}

