/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.BufferedImagePlane;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.config.SCIFIOConfig;
import io.scif.gui.AWTImageTools;
import io.scif.gui.BufferedImageReader;
import io.scif.util.FormatTools;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import net.imagej.axis.Axes;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Multiple Network Graphics")
public class MNGFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"mng"};
    }

    private static BufferedImage readImage(Metadata meta, long end) throws IOException {
        int headerSize = meta.isJNG() ? 0 : 8;
        byte[] b = new byte[(int)(end - meta.getSource().offset() + (long)headerSize)];
        meta.getSource().read(b, headerSize, b.length - headerSize);
        if (!meta.isJNG()) {
            b[0] = -119;
            b[1] = 80;
            b[2] = 78;
            b[3] = 71;
            b[4] = 13;
            b[5] = 10;
            b[6] = 26;
            b[7] = 10;
        }
        return ImageIO.read(new ByteArrayInputStream(b));
    }

    private static class MNGImageInfo {
        public Vector<Long> offsets = new Vector();
        public Vector<Long> lengths = new Vector();

        private MNGImageInfo() {
        }
    }

    private static class MNGDatasetInfo {
        public Vector<MNGImageInfo> imageInfo = new Vector();
        public String[] keys;

        private MNGDatasetInfo() {
        }
    }

    public static class Reader
    extends BufferedImageReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public BufferedImagePlane openPlane(int imageIndex, long planeIndex, BufferedImagePlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            MNGImageInfo info = ((Metadata)this.getMetadata()).getDatasetInfo().imageInfo.get(imageIndex);
            long offset = info.offsets.get((int)planeIndex);
            this.getHandle().seek(offset);
            long end = info.lengths.get((int)planeIndex);
            BufferedImage img = MNGFormat.readImage((Metadata)this.getMetadata(), end);
            img = AWTImageTools.getSubimage(img, ((Metadata)this.getMetadata()).get(imageIndex).isLittleEndian(), bounds);
            plane.setData(img);
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.getSource().setOrder(DataHandle.ByteOrder.BIG_ENDIAN);
            this.log().info((Object)"Verifying MNG format");
            MNGDatasetInfo datasetInfo = new MNGDatasetInfo();
            datasetInfo.imageInfo.add(new MNGImageInfo());
            this.getSource().skipBytes(12);
            if (!"MHDR".equals(this.getSource().readString(4))) {
                throw new FormatException("Invalid MNG file.");
            }
            this.log().info((Object)"Reading dimensions");
            this.getSource().skipBytes(32);
            Vector<Long> stack = new Vector<Long>();
            int maxIterations = 0;
            int currentIteration = 0;
            this.log().info((Object)"Finding image offsets");
            while (this.getSource().offset() < this.getSource().length()) {
                int len = this.getSource().readInt();
                String code = this.getSource().readString(4);
                long fp = this.getSource().offset();
                if (code.equals("IHDR")) {
                    datasetInfo.imageInfo.get((int)0).offsets.add(fp - 8L);
                } else if (code.equals("JDAT")) {
                    meta.setJNG(true);
                    datasetInfo.imageInfo.get((int)0).offsets.add(fp);
                } else if (code.equals("IEND")) {
                    datasetInfo.imageInfo.get((int)0).lengths.add(fp + (long)len + 4L);
                } else if (code.equals("LOOP")) {
                    stack.add(fp + (long)len + 4L);
                    this.getSource().skipBytes(1);
                    maxIterations = this.getSource().readInt();
                } else if (code.equals("ENDL")) {
                    long seek = (Long)stack.get(stack.size() - 1);
                    if (currentIteration < maxIterations) {
                        this.getSource().seek(seek);
                        ++currentIteration;
                    } else {
                        stack.remove(stack.size() - 1);
                        maxIterations = 0;
                        currentIteration = 0;
                    }
                }
                this.getSource().seek(fp + (long)len + 4L);
            }
            this.log().info((Object)"Populating metadata");
            Hashtable<String, Vector> imageOffsets = new Hashtable<String, Vector>();
            Hashtable<String, Vector> imageLengths = new Hashtable<String, Vector>();
            MNGImageInfo info = datasetInfo.imageInfo.get(0);
            meta.getTable().put("Number of frames", info.offsets.size());
            for (int i = 0; i < info.offsets.size(); ++i) {
                long offset = info.offsets.get(i);
                this.getSource().seek(offset);
                long end = info.lengths.get(i);
                if (end < offset) continue;
                BufferedImage img = MNGFormat.readImage(meta, end);
                String data = img.getWidth() + "-" + img.getHeight() + "-" + img.getRaster().getNumBands() + "-" + AWTImageTools.getPixelType(img);
                Vector v = new Vector();
                if (imageOffsets.containsKey(data)) {
                    v = (Vector)imageOffsets.get(data);
                }
                v.add(new Long(offset));
                imageOffsets.put(data, v);
                v = new Vector();
                if (imageLengths.containsKey(data)) {
                    v = (Vector)imageLengths.get(data);
                }
                v.add(new Long(end));
                imageLengths.put(data, v);
            }
            String[] keys = imageOffsets.keySet().toArray(new String[0]);
            if (keys.length == 0) {
                throw new FormatException("Pixel data not found.");
            }
            datasetInfo.imageInfo.clear();
            int imageCount = keys.length;
            for (String key : keys) {
                MNGImageInfo inf = new MNGImageInfo();
                inf.offsets = (Vector)imageOffsets.get(key);
                inf.lengths = (Vector)imageLengths.get(key);
                datasetInfo.imageInfo.add(inf);
            }
            datasetInfo.keys = keys;
            meta.setDatasetInfo(datasetInfo);
        }
    }

    public static class Checker
    extends AbstractChecker {
        public static final long MNG_MAGIC_BYTES = -8481036456200365558L;

        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            int blockLen = 8;
            if (!FormatTools.validStream(stream, 8, false)) {
                return false;
            }
            return stream.readLong() == -8481036456200365558L;
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private MNGDatasetInfo datasetInfo;
        private boolean isJNG = false;

        public MNGDatasetInfo getDatasetInfo() {
            return this.datasetInfo;
        }

        public void setDatasetInfo(MNGDatasetInfo datasetInfo) {
            this.datasetInfo = datasetInfo;
        }

        public boolean isJNG() {
            return this.isJNG;
        }

        public void setJNG(boolean isJNG) {
            this.isJNG = isJNG;
        }

        @Override
        public void populateImageMetadata() {
            String[] keys = this.getDatasetInfo().keys;
            int imageCount = keys.length;
            this.createImageMetadata(imageCount);
            for (int i = 0; i < this.getImageCount(); ++i) {
                String[] tokens = keys[i].split("-");
                this.get(i).setAxisLength(Axes.X, (long)Integer.parseInt(tokens[0]));
                this.get(i).setAxisLength(Axes.Y, (long)Integer.parseInt(tokens[1]));
                this.get(i).setAxisLength(Axes.CHANNEL, (long)Integer.parseInt(tokens[2]));
                this.get(i).setPlanarAxisCount(this.get(i).getAxisLength(Axes.CHANNEL) > 1L ? 3 : 2);
                this.get(i).setPixelType(Integer.parseInt(tokens[3]));
                this.get(i).setMetadataComplete(true);
                this.get(i).setIndexed(false);
                this.get(i).setLittleEndian(false);
                this.get(i).setFalseColor(false);
                this.get(i).setAxisLength(Axes.TIME, (long)this.getDatasetInfo().imageInfo.get((int)i).offsets.size());
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.datasetInfo = null;
                this.isJNG = false;
            }
        }
    }
}

