/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Stratec pQCT")
public class StratecPQCTFormat
extends AbstractFormat {
    public static final int HEADER_SIZE = 1609;
    public static final int DEVICE_NAME_INDEX = 1050;

    private static String readShortString(DataHandle<Location> stream) throws IOException {
        byte length = stream.readByte();
        if (length == 0) {
            return "";
        }
        return stream.readString((int)length);
    }

    public static String[] generateSuffixes() {
        String[] suffixes = new String[256];
        int count = 0;
        for (int i = 0; i < 16; ++i) {
            String hexTens = Integer.toHexString(i);
            for (int j = 0; j < 16; ++j) {
                String suffix;
                String hexOnes = Integer.toHexString(j);
                suffixes[count] = suffix = "m" + hexTens + hexOnes;
                ++count;
            }
        }
        return suffixes;
    }

    @Override
    protected String[] makeSuffixArray() {
        return StratecPQCTFormat.generateSuffixes();
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Medical Imaging"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            DataHandle<Location> stream = this.getHandle();
            stream.seek(1609L);
            return this.readPlane(stream, imageIndex, bounds, plane);
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        public void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            config.imgOpenerSetComputeMinMax(true);
            stream.setLittleEndian(true);
            stream.seek(12L);
            meta.setResolution(stream.readDouble());
            stream.seek(30L);
            meta.setSlices(stream.readShort());
            meta.setSliceStart(stream.readDouble());
            meta.setSliceDistance(stream.readDouble());
            stream.seek(318L);
            meta.setObjectSize(stream.readDouble());
            meta.setMeasurementInfo(stream);
            stream.seek(986L);
            meta.setMeasurementDate(stream.readInt());
            stream.seek(1050L);
            meta.setDeviceName(StratecPQCTFormat.readShortString((DataHandle<Location>)stream));
            stream.seek(1085L);
            meta.setPatientMeasurementNumber(stream.readShort());
            meta.setPatientNumber(stream.readInt());
            meta.setPatientBirthDate(stream.readInt());
            meta.setPatientAge(stream.readInt());
            meta.setPatientName(StratecPQCTFormat.readShortString((DataHandle<Location>)stream));
            stream.seek(1282L);
            meta.setPatientId(StratecPQCTFormat.readShortString((DataHandle<Location>)stream));
            stream.seek(1525L);
            meta.setLeftEdge(stream.readShort());
            meta.setTopEdge(stream.readShort());
            meta.setWidth(stream.readShort());
            meta.setHeight(stream.readShort());
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        public static final int[] INFO_INDICES = new int[]{662, 743, 824, 905};
        private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
        public static final Date DEFAULT_DATE = new Date(0L);
        public static final String UNIT = "mm";
        private short height;
        private short width;
        private short slices;
        private double sliceStart;
        private double sliceDistance;
        private String patientName;
        private int patientNumber;
        private int patientAge;
        private short patientMeasurementNumber;
        private Date patientBirthDate;
        private String patientId;
        private Date measurementDate;
        private String measurementInfo;
        private double resolution;
        private short topEdge;
        private short leftEdge;
        private String deviceName;
        private double objectSize;

        public String getPatientName() {
            return this.patientName;
        }

        public void setPatientName(String patientName) {
            this.patientName = patientName;
        }

        public long getPatientNumber() {
            return this.patientNumber;
        }

        public void setPatientNumber(int patientNumber) {
            this.patientNumber = patientNumber;
        }

        public int getPatientMeasurementNumber() {
            return this.patientMeasurementNumber;
        }

        public void setPatientMeasurementNumber(short patientMeasurementNumber) {
            this.patientMeasurementNumber = patientMeasurementNumber;
        }

        public Date getPatientBirthDate() {
            return this.patientBirthDate;
        }

        public void setPatientBirthDate(int patientBirthDate) {
            this.patientBirthDate = this.parseDate(patientBirthDate);
        }

        public Date getMeasurementDate() {
            return this.measurementDate;
        }

        public void setMeasurementDate(int measurementDate) {
            this.measurementDate = this.parseDate(measurementDate);
        }

        private Date parseDate(int measurementDate) {
            try {
                return DATE_FORMAT.parse(String.valueOf(measurementDate));
            }
            catch (ParseException e) {
                return DEFAULT_DATE;
            }
        }

        public double getResolution() {
            return this.resolution;
        }

        public void setResolution(double resolution) {
            this.resolution = resolution;
        }

        public int getLeftEdge() {
            return this.leftEdge;
        }

        public void setLeftEdge(short leftEdge) {
            this.leftEdge = leftEdge;
        }

        public int getTopEdge() {
            return this.topEdge;
        }

        public void setTopEdge(short topEdge) {
            this.topEdge = topEdge;
        }

        public String getMeasurementInfo() {
            return this.measurementInfo;
        }

        public void setMeasurementInfo(DataHandle<Location> stream) {
            StringBuffer info = new StringBuffer(320);
            try {
                for (int i = 0; i < 4; ++i) {
                    stream.seek((long)INFO_INDICES[i]);
                    String infoBit = StratecPQCTFormat.readShortString((DataHandle<Location>)stream);
                    if (infoBit.isEmpty()) continue;
                    info.append(infoBit).append("\n");
                }
                this.measurementInfo = info.toString();
            }
            catch (IOException e) {
                this.measurementInfo = "";
            }
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getPatientId() {
            return this.patientId;
        }

        public void setPatientId(String patientId) {
            this.patientId = patientId;
        }

        public double getObjectSize() {
            return this.objectSize;
        }

        public void setObjectSize(double objectSize) {
            this.objectSize = objectSize;
        }

        public void setHeight(short height) {
            this.height = height;
        }

        public void setWidth(short width) {
            this.width = width;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata metadata = this.get(0);
            metadata.setLittleEndian(true);
            metadata.setBitsPerPixel(16);
            metadata.setPixelType(2);
            metadata.setOrderCertain(true);
            metadata.setPlanarAxisCount(2);
            metadata.setAxes(new CalibratedAxis[]{new DefaultLinearAxis(Axes.X, UNIT, this.resolution), new DefaultLinearAxis(Axes.Y, UNIT, this.resolution)});
            metadata.setAxisLengths(new long[]{this.width, this.height});
        }

        public short getWidth() {
            return this.width;
        }

        public short getHeight() {
            return this.height;
        }

        public int getPatientAge() {
            return this.patientAge;
        }

        public void setPatientAge(int patientAge) {
            this.patientAge = patientAge;
        }

        public void setSlices(short slices) {
            this.slices = (short)Math.max(1, slices);
        }

        public short getSlices() {
            return this.slices;
        }

        public void setSliceStart(double sliceStart) {
            this.sliceStart = sliceStart;
        }

        public void setSliceDistance(double sliceDistance) {
            this.sliceDistance = sliceDistance;
        }

        public double getSliceStart() {
            return this.sliceStart;
        }

        public double getSliceDistance() {
            return this.sliceDistance;
        }
    }

    public static class Checker
    extends AbstractChecker {
        public static final String NAME_FORMAT = "^[iI]\\d{7}";

        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            String fileName = ((Location)stream.get()).getName();
            if (fileName.length() < 9) {
                return false;
            }
            String mainPart = fileName.substring(0, 8);
            if (!mainPart.matches(NAME_FORMAT) || stream.length() < 1609L) {
                return false;
            }
            stream.seek(1050L);
            String deviceName = StratecPQCTFormat.readShortString((DataHandle<Location>)stream);
            return this.isDeviceNameValid(deviceName);
        }

        private boolean isDeviceNameValid(String deviceName) {
            String lowerCase = deviceName.toLowerCase();
            return lowerCase.length() > 4 && lowerCase.indexOf(".typ", deviceName.length() - 4) >= 0;
        }
    }
}

