/*
 * Decompiled with CFR 0.152.
 */
package io.scif.xml;

import io.scif.xml.BaseHandler;
import java.util.StringTokenizer;
import org.scijava.log.LogService;
import org.xml.sax.Attributes;

public class ValidationSAXHandler
extends BaseHandler {
    private String schemaPath;
    private boolean first;

    public ValidationSAXHandler(LogService log) {
        super(log);
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    @Override
    public void startDocument() {
        this.schemaPath = null;
        this.first = true;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!this.first) {
            return;
        }
        this.first = false;
        int len = attributes.getLength();
        String xmlns = null;
        String xsiSchemaLocation = null;
        for (int i = 0; i < len; ++i) {
            String name = attributes.getQName(i);
            if (name.equals("xmlns")) {
                xmlns = attributes.getValue(i);
                continue;
            }
            if (!name.equals("schemaLocation") && !name.endsWith(":schemaLocation")) continue;
            xsiSchemaLocation = attributes.getValue(i);
        }
        if (xmlns == null || xsiSchemaLocation == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(xsiSchemaLocation);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!xmlns.equals(token)) continue;
            if (!st.hasMoreTokens()) break;
            this.schemaPath = st.nextToken();
            break;
        }
    }
}

