/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.TransitionDefinition;
import com.sun.javafx.css.TransitionMediator;
import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableProperty;
import javafx.scene.Node;

public abstract class StyleableIntegerProperty
extends IntegerPropertyBase
implements StyleableProperty<Number> {
    private StyleOrigin origin = null;
    private TransitionMediatorImpl mediator = null;

    public StyleableIntegerProperty() {
    }

    public StyleableIntegerProperty(int n) {
        super(n);
    }

    @Override
    public void applyStyle(StyleOrigin styleOrigin, Number number) {
        int n;
        TransitionDefinition transitionDefinition;
        Object object;
        if (this.origin != null && (object = this.getBean()) instanceof Node) {
            Node node = (Node)object;
            transitionDefinition = NodeHelper.findTransitionDefinition(node, this.getCssMetaData());
        } else {
            transitionDefinition = null;
        }
        TransitionDefinition transitionDefinition2 = transitionDefinition;
        int n2 = n = number != null ? number.intValue() : 0;
        if (transitionDefinition2 == null) {
            this.set(n);
        } else if (this.mediator == null || this.mediator.newValue != n) {
            this.mediator = new TransitionMediatorImpl(this.get(), n);
            this.mediator.run(transitionDefinition2);
        }
        this.origin = styleOrigin;
    }

    public void bind(ObservableValue<? extends Number> observableValue) {
        super.bind(observableValue);
        this.origin = StyleOrigin.USER;
        if (this.mediator != null) {
            this.mediator.cancel(true);
        }
    }

    public void set(int n) {
        super.set(n);
        if (this.mediator == null || this.mediator.cancel(false)) {
            this.origin = StyleOrigin.USER;
        }
    }

    @Override
    public StyleOrigin getStyleOrigin() {
        return this.origin;
    }

    private final class TransitionMediatorImpl
    extends TransitionMediator {
        private final int oldValue;
        private final int newValue;

        public TransitionMediatorImpl(int n, int n2) {
            this.oldValue = n;
            this.newValue = n2;
        }

        @Override
        public void onUpdate(double d) {
            StyleableIntegerProperty.this.set(d < 1.0 ? this.oldValue + (int)((double)(this.newValue - this.oldValue) * d) : this.newValue);
        }

        @Override
        public void onStop() {
            if (StyleableIntegerProperty.this.mediator == this) {
                StyleableIntegerProperty.this.mediator = null;
            }
        }

        @Override
        public StyleableProperty<?> getStyleableProperty() {
            return StyleableIntegerProperty.this;
        }
    }
}

