/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.InputTrigger;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.AbstractNamedBehaviour;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class Behaviours {
    private final InputTriggerMap inputTriggerMap;
    private final BehaviourMap behaviourMap;
    private final String[] keyConfigContexts;
    protected InputTriggerAdder.Factory keyConfig;
    protected InputTriggerAdder inputTriggerAdder;

    public Behaviours(InputTriggerAdder.Factory keyConfig, String ... keyConfigContexts) {
        this(new InputTriggerMap(), new BehaviourMap(), keyConfig, keyConfigContexts);
    }

    public Behaviours(InputTriggerMap inputTriggerMap, BehaviourMap behaviourMap, InputTriggerAdder.Factory keyConfig, String ... keyConfigContexts) {
        this.inputTriggerMap = inputTriggerMap;
        this.behaviourMap = behaviourMap;
        this.keyConfig = keyConfig != null ? keyConfig : new InputTriggerConfig();
        this.keyConfigContexts = keyConfigContexts;
        this.inputTriggerAdder = this.keyConfig.inputTriggerAdder(inputTriggerMap, keyConfigContexts);
    }

    public InputTriggerMap getInputTriggerMap() {
        return this.inputTriggerMap;
    }

    public BehaviourMap getBehaviourMap() {
        return this.behaviourMap;
    }

    public void install(TriggerBehaviourBindings triggerBehaviourBindings, String name) {
        triggerBehaviourBindings.addInputTriggerMap(name, this.inputTriggerMap, new String[0]);
        triggerBehaviourBindings.addBehaviourMap(name, this.behaviourMap);
    }

    public void behaviour(Behaviour behaviour, String name, String ... defaultTriggers) {
        this.inputTriggerAdder.put(name, defaultTriggers);
        this.behaviourMap.put(name, behaviour);
    }

    public void namedBehaviour(AbstractNamedBehaviour behaviour, String ... defaultTriggers) {
        this.inputTriggerAdder.put(behaviour.name(), defaultTriggers);
        behaviour.put(this.behaviourMap);
    }

    public void updateKeyConfig(InputTriggerConfig keyConfig) {
        this.updateKeyConfig(keyConfig, true);
    }

    public void updateKeyConfig(InputTriggerConfig keyConfig, boolean clearAll) {
        this.keyConfig = keyConfig;
        HashMap<String, List> unassigned = new HashMap<String, List>();
        if (!clearAll) {
            Map<InputTrigger, Set<String>> bindings = this.inputTriggerMap.getBindings();
            HashSet<String> contexts = new HashSet<String>(Arrays.asList(this.keyConfigContexts));
            for (Map.Entry<InputTrigger, Set<String>> entry : bindings.entrySet()) {
                InputTrigger trigger = entry.getKey();
                for (String behaviourKey2 : entry.getValue()) {
                    if (!keyConfig.getInputs(behaviourKey2, contexts).isEmpty()) continue;
                    unassigned.computeIfAbsent(behaviourKey2, k -> new ArrayList()).add(trigger);
                }
            }
        }
        this.inputTriggerAdder = keyConfig.inputTriggerAdder(this.inputTriggerMap, this.keyConfigContexts);
        this.inputTriggerMap.clear();
        for (String behaviourName : this.behaviourMap.keys()) {
            this.inputTriggerAdder.put(behaviourName);
        }
        unassigned.forEach((behaviourKey, triggers) -> triggers.forEach(trigger -> this.inputTriggerMap.put((InputTrigger)trigger, (String)behaviourKey)));
    }
}

