/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Mode;
import ini.trakem2.display.Paintable;
import ini.trakem2.display.Patch;
import ini.trakem2.display.graphics.GraphicsSource;
import ini.trakem2.utils.IJError;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public abstract class GroupingMode
implements Mode {
    protected final Display display;
    protected final Layer layer;
    protected final Updater updater;
    protected final Painter painter;
    protected Rectangle srcRect;
    protected double magnification;
    protected final GroupedGraphicsSource gs;
    protected final List<Patch> originalPatches;
    protected final List<PatchRange> ranges;
    protected HashMap<Paintable, ScreenPatchRange<?>> screenPatchRanges;

    public GroupingMode(Display display, List<Displayable> selected) {
        this.display = display;
        this.layer = display.getLayer();
        this.srcRect = (Rectangle)display.getCanvas().getSrcRect().clone();
        this.magnification = display.getCanvas().getMagnification();
        this.originalPatches = new ArrayList<Patch>();
        this.ranges = new ArrayList<PatchRange>();
        TreeMap<Integer, Patch> m = new TreeMap<Integer, Patch>();
        for (Displayable d : selected) {
            if (d.getClass() != Patch.class) continue;
            m.put(this.layer.indexOf(d), (Patch)d);
        }
        this.originalPatches.addAll(m.values());
        this.screenPatchRanges = new HashMap(this.originalPatches.size());
        this.gs = this.createGroupedGraphicSource();
        this.updater = new Updater();
        this.painter = new Painter();
    }

    protected final void initThreads() {
        this.updater.start();
        this.painter.start();
        this.updater.update();
    }

    protected final void quitThreads() {
        this.painter.quit();
        this.updater.quit();
    }

    protected abstract GroupedGraphicsSource createGroupedGraphicSource();

    protected abstract ScreenPatchRange<?> createScreenPathRange(PatchRange var1, Rectangle var2, double var3);

    protected abstract void doPainterUpdate(Rectangle var1, double var2);

    @Override
    public boolean canChangeLayer() {
        return false;
    }

    @Override
    public boolean canZoom() {
        return true;
    }

    @Override
    public boolean canPan() {
        return true;
    }

    private void updated(Rectangle srcRect, double magnification) {
        if (this.srcRect.x == srcRect.x && this.srcRect.y == srcRect.y && this.srcRect.width == srcRect.width && this.srcRect.height == srcRect.height && this.magnification == magnification) {
            return;
        }
        this.srcRect = (Rectangle)srcRect.clone();
        this.magnification = magnification;
        this.updater.update();
    }

    @Override
    public void srcRectUpdated(Rectangle srcRect, double magnification) {
        this.updated(srcRect, magnification);
    }

    @Override
    public void magnificationUpdated(Rectangle srcRect, double magnification) {
        this.updated(srcRect, magnification);
    }

    @Override
    public void redoOneStep() {
    }

    @Override
    public void undoOneStep() {
    }

    @Override
    public boolean cancel() {
        this.painter.quit();
        this.updater.quit();
        return true;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return (Rectangle)this.srcRect.clone();
    }

    @Override
    public GraphicsSource getGraphicsSource() {
        return this.gs;
    }

    protected abstract class SimpleThread
    extends Thread {
        private volatile boolean updateAgain = false;

        SimpleThread() {
            this.setPriority(5);
            try {
                this.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                double m;
                Rectangle r;
                boolean b;
                SimpleThread simpleThread = this;
                synchronized (simpleThread) {
                    b = this.updateAgain;
                    this.updateAgain = false;
                    r = (Rectangle)GroupingMode.this.srcRect.clone();
                    m = GroupingMode.this.magnification;
                }
                if (b) {
                    this.doit(r, m);
                }
                simpleThread = this;
                synchronized (simpleThread) {
                    try {
                        if (!this.updateAgain) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        abstract void doit(Rectangle var1, double var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update() {
            SimpleThread simpleThread = this;
            synchronized (simpleThread) {
                this.updateAgain = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this.interrupt();
            SimpleThread simpleThread = this;
            synchronized (simpleThread) {
                this.updateAgain = false;
                this.notify();
            }
        }
    }

    protected class Painter
    extends SimpleThread {
        protected Painter() {
        }

        @Override
        void doit(Rectangle r, double m) {
            try {
                GroupingMode.this.doPainterUpdate(r, m);
            }
            catch (Throwable e) {
                IJError.print(e);
            }
            GroupingMode.this.display.getCanvas().repaint(true);
        }
    }

    private class Updater
    extends SimpleThread {
        private Updater() {
        }

        @Override
        void doit(Rectangle r, double m) {
            ArrayList<Displayable> to_paint = new ArrayList<Displayable>(GroupingMode.this.layer.find(GroupingMode.this.srcRect, true));
            PatchRange current_range = new PatchRange();
            GroupingMode.this.ranges.clear();
            GroupingMode.this.ranges.add(current_range);
            int last_i = -2147483647;
            byte last_b = 0;
            for (Patch p : GroupingMode.this.originalPatches) {
                int i = to_paint.indexOf(p);
                byte b = p.getCompositeMode();
                if (0 == i) {
                    current_range.setAsBottom();
                    current_range.addConsecutive(p);
                } else if (1 == i - last_i && b == 0 && last_b == 0) {
                    current_range.addConsecutive(p);
                } else {
                    current_range = new PatchRange();
                    GroupingMode.this.ranges.add(current_range);
                    current_range.addConsecutive(p);
                }
                last_i = i;
                last_b = b;
            }
            HashMap screenPatchRanges = new HashMap(GroupingMode.this.originalPatches.size());
            for (PatchRange range : GroupingMode.this.ranges) {
                if (0 == range.list.size()) continue;
                ScreenPatchRange<?> spr = GroupingMode.this.createScreenPathRange(range, r, m);
                for (Patch p : range.list) {
                    screenPatchRanges.put(p, spr);
                }
            }
            GroupingMode.this.screenPatchRanges = screenPatchRanges;
            GroupingMode.this.painter.update();
        }
    }

    protected static abstract class ScreenPatchRange<T>
    implements Paintable {
        final ImageProcessor ip;
        final ImageProcessor ipTransformed;
        final FloatProcessor mask;
        final FloatProcessor maskTransformed;
        BufferedImage transformedImage;
        static final int pad = 100;
        final byte compositeMode;

        ScreenPatchRange(PatchRange range, Rectangle srcRect, double magnification) {
            this.compositeMode = range.list.get(0).getCompositeMode();
            BufferedImage image = new BufferedImage((int)((double)srcRect.width * magnification + 0.5) + 200, (int)((double)srcRect.height * magnification + 0.5) + 200, range.starts_at_bottom ? (range.is_gray ? 10 : 1) : 2);
            Graphics2D g = image.createGraphics();
            AffineTransform atc = new AffineTransform();
            atc.translate(100.0, 100.0);
            atc.scale(magnification, magnification);
            atc.translate(-srcRect.x, -srcRect.y);
            g.setTransform(atc);
            for (Patch patch : range.list) {
                patch.paint(g, srcRect, magnification, false, -1, patch.getLayer(), null);
            }
            this.ip = new ImagePlus("", (Image)image).getProcessor();
            this.ipTransformed = this.ip.createProcessor(this.ip.getWidth(), this.ip.getHeight());
            this.ipTransformed.snapshot();
            if (!range.starts_at_bottom) {
                float[] pixels = new float[this.ip.getWidth() * this.ip.getHeight()];
                this.mask = new FloatProcessor(this.ip.getWidth(), this.ip.getHeight(), image.getAlphaRaster().getPixels(0, 0, this.ip.getWidth(), this.ip.getHeight(), pixels), null);
                this.maskTransformed = new FloatProcessor(this.ip.getWidth(), this.ip.getHeight());
                this.maskTransformed.snapshot();
            } else {
                this.mask = null;
                this.maskTransformed = null;
            }
            image.flush();
            this.transformedImage = this.makeImage(this.ip, this.mask);
        }

        public abstract void update(T var1);

        protected BufferedImage makeImage(ImageProcessor ip, FloatProcessor mask) {
            BufferedImage transformedImage = new BufferedImage(ip.getWidth(), ip.getHeight(), null == mask ? 1 : 2);
            Image img = ip.createImage();
            transformedImage.createGraphics().drawImage(img, 0, 0, null);
            img.flush();
            if (null != mask) {
                transformedImage.getAlphaRaster().setPixels(0, 0, ip.getWidth(), ip.getHeight(), (float[])mask.getPixels());
            }
            return transformedImage;
        }

        public void flush() {
            if (null != this.transformedImage) {
                this.transformedImage.flush();
            }
        }

        @Override
        public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
            AffineTransform at = g.getTransform();
            AffineTransform atp = new AffineTransform();
            atp.translate(-100.0, -100.0);
            g.setTransform(atp);
            Composite original_composite = null;
            if (0 != this.compositeMode) {
                original_composite = g.getComposite();
                g.setComposite(Displayable.getComposite(this.compositeMode, 1.0f));
            }
            g.drawImage((Image)this.transformedImage, 0, 0, null);
            if (null != original_composite) {
                g.setComposite(original_composite);
            }
            g.setTransform(at);
        }

        @Override
        public void prePaint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
            this.paint(g, srcRect, magnification, active, channels, active_layer, layers);
        }
    }

    protected static class PatchRange {
        final ArrayList<Patch> list = new ArrayList();
        boolean starts_at_bottom = false;
        boolean is_gray = true;

        protected PatchRange() {
        }

        void addConsecutive(Patch p) {
            this.list.add(p);
            if (this.is_gray) {
                switch (p.getType()) {
                    case 3: 
                    case 4: {
                        this.is_gray = false;
                    }
                }
            }
        }

        void setAsBottom() {
            this.starts_at_bottom = true;
        }
    }

    protected abstract class GroupedGraphicsSource
    implements GraphicsSource {
        protected GroupedGraphicsSource() {
        }

        @Override
        public List<? extends Paintable> asPaintable(List<? extends Paintable> ds) {
            ArrayList<Paintable> newList = new ArrayList<Paintable>();
            HashSet used = new HashSet();
            HashMap<Paintable, ScreenPatchRange<?>> screenPatchRanges = GroupingMode.this.screenPatchRanges;
            for (Paintable paintable : ds) {
                ScreenPatchRange<?> spr = screenPatchRanges.get(paintable);
                if (spr == null) {
                    newList.add(paintable);
                    continue;
                }
                if (used.contains(spr)) continue;
                used.add(spr);
                newList.add(spr);
            }
            return newList;
        }
    }
}

