/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij3d.Utils;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.DisplayCanvas;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Node;
import ini.trakem2.display.Tree;
import ini.trakem2.display.VectorDataTransform;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.ProjectToolbar;
import java.awt.AlphaComposite;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mpicbg.models.CoordinateTransform;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.AxisAngle4f;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class Treeline
extends Tree<Float> {
    protected static float last_radius = -1.0f;

    public Treeline(Project project, String title) {
        super(project, title);
        this.addToDatabase();
    }

    public Treeline(Project project, long id, HashMap<String, String> ht_attr, HashMap<Displayable, String> ht_links) {
        super(project, id, ht_attr, ht_links);
    }

    public Treeline(Project project, long id, String title, float width, float height, float alpha, boolean visible, Color color, boolean locked, AffineTransform at) {
        super(project, id, title, width, height, alpha, visible, color, locked, at);
    }

    @Override
    public Tree<Float> newInstance() {
        return new Treeline(this.project, this.project.getLoader().getNextId(), this.title, this.width, this.height, this.alpha, this.visible, this.color, this.locked, this.at);
    }

    @Override
    public Node<Float> newNode(float lx, float ly, Layer la, Node<?> modelNode) {
        return new RadiusNode(lx, ly, la, null == modelNode ? 0.0f : ((RadiusNode)modelNode).r);
    }

    @Override
    public Node<Float> newNode(HashMap<String, String> ht_attr) {
        return new RadiusNode(ht_attr);
    }

    @Override
    public Treeline clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Treeline tline = new Treeline(pr, nid, this.title, this.width, this.height, this.alpha, this.visible, this.color, this.locked, this.at);
        tline.root = null == this.root ? null : this.root.clone(pr);
        tline.addToDatabase();
        if (null != tline.root) {
            tline.cacheSubtree(tline.root.getSubtreeNodes());
        }
        return tline;
    }

    @Override
    public void mousePressed(MouseEvent me, Layer la, int x_p, int y_p, double mag) {
        if (-1.0f == last_radius) {
            last_radius = 10.0f / (float)mag;
        }
        if (me.isShiftDown() && me.isAltDown() && !ini.trakem2.utils.Utils.isControlDown(me)) {
            Display front = Display.getFront(this.project);
            Layer layer = front.getLayer();
            Node<Float> nd = this.findNodeNear(x_p, y_p, layer, front.getCanvas());
            if (null == nd) {
                ini.trakem2.utils.Utils.log("Can't adjust radius: found more than 1 node within visible area!");
                return;
            }
            float xp = x_p;
            float yp = y_p;
            if (!this.at.isIdentity()) {
                Point2D.Double po = this.inverseTransformPoint(x_p, y_p);
                xp = (int)po.x;
                yp = (int)po.y;
            }
            this.setActive(nd);
            nd.setData(Float.valueOf((float)Math.sqrt(Math.pow(xp - nd.x, 2.0) + Math.pow(yp - nd.y, 2.0))));
            this.repaint(true, la);
            this.setLastEdited(nd);
            return;
        }
        super.mousePressed(me, la, x_p, y_p, mag);
    }

    protected boolean requireAltDownToEditRadius() {
        return true;
    }

    @Override
    public void mouseDragged(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        if (null == this.getActive()) {
            return;
        }
        if (this.requireAltDownToEditRadius() && !me.isAltDown()) {
            super.mouseDragged(me, la, x_p, y_p, x_d, y_d, x_d_old, y_d_old);
            return;
        }
        if (me.isShiftDown() && !ini.trakem2.utils.Utils.isControlDown(me)) {
            float xd = x_d;
            float yd = y_d;
            if (!this.at.isIdentity()) {
                Point2D.Double po = this.inverseTransformPoint(x_d, y_d);
                xd = (float)po.x;
                yd = (float)po.y;
            }
            Node<Float> nd = this.getActive();
            float r = (float)Math.sqrt(Math.pow(xd - nd.x, 2.0) + Math.pow(yd - nd.y, 2.0));
            nd.setData(Float.valueOf(r));
            last_radius = r;
            this.repaint(true, la);
            return;
        }
        super.mouseDragged(me, la, x_p, y_p, x_d, y_d, x_d_old, y_d_old);
    }

    @Override
    public void mouseReleased(MouseEvent me, Layer la, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        if (null == this.getActive()) {
            return;
        }
        if (me.isShiftDown() && me.isAltDown() && !ini.trakem2.utils.Utils.isControlDown(me)) {
            this.updateViewData(this.getActive());
            return;
        }
        super.mouseReleased(me, la, x_p, y_p, x_d, y_d, x_r, y_r);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mwe) {
        int modifiers = mwe.getModifiers();
        if (0 == (9 ^ modifiers)) {
            float y;
            float x;
            Object source = mwe.getSource();
            if (!(source instanceof DisplayCanvas)) {
                return;
            }
            DisplayCanvas dc = (DisplayCanvas)source;
            Layer la = dc.getDisplay().getLayer();
            int rotation = mwe.getWheelRotation();
            float magnification = (float)dc.getMagnification();
            Rectangle srcRect = dc.getSrcRect();
            float inc = (float)(rotation > 0 ? 1 : -1) * (1.0f / magnification);
            if (null != this.adjustNodeRadius(inc, x = (float)mwe.getX() / magnification + (float)srcRect.x, y = (float)mwe.getY() / magnification + (float)srcRect.y, la, dc)) {
                Display.repaint(this);
                mwe.consume();
                return;
            }
        }
        super.mouseWheelMoved(mwe);
    }

    protected Node<Float> adjustNodeRadius(float inc, float x, float y, Layer layer, DisplayCanvas dc) {
        Node<Float> nearest = this.findNodeNear(x, y, layer, dc);
        if (null == nearest) {
            ini.trakem2.utils.Utils.log("Can't adjust radius: found more than 1 node within visible area!");
            return null;
        }
        nearest.setData(Float.valueOf(((Float)nearest.getData()).floatValue() + inc));
        return nearest;
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        Tree.exportDTD(sb_header, hs, indent);
        String type = "t2_treeline";
        if (hs.contains("t2_treeline")) {
            return;
        }
        hs.add("t2_treeline");
        sb_header.append(indent).append("<!ELEMENT t2_treeline (t2_node*,").append(Displayable.commonDTDChildren()).append(")>\n");
        Displayable.exportDTD("t2_treeline", sb_header, hs, indent);
    }

    @Override
    protected boolean exportXMLNodeAttributes(StringBuilder indent, StringBuilder sb, Node<Float> node) {
        if (node.getData().floatValue() > 0.0f) {
            sb.append(" r=\"").append(node.getData()).append('\"');
        }
        return true;
    }

    @Override
    protected boolean exportXMLNodeData(StringBuilder indent, StringBuilder sb, Node<Float> node) {
        return false;
    }

    public Tree.MeshData generateMesh(double scale_, int parallels) {
        float scale = (float)scale_;
        if (parallels < 3) {
            parallels = 3;
        }
        Calibration cal = this.layer_set.getCalibration();
        float pixelWidthScaled = (float)cal.pixelWidth * scale;
        float pixelHeightScaled = (float)cal.pixelHeight * scale;
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        List<Point3f> ico = M.createIcosahedron(1, 1.0f);
        ArrayList<Point3f> ps = new ArrayList<Point3f>();
        ArrayList<Point3f> plane = new ArrayList<Point3f>();
        double inc_rads = Math.PI * 2 / (double)parallels;
        double angle = 0.0;
        for (int i = 0; i < parallels; ++i) {
            plane.add(new Point3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f));
            angle += inc_rads;
        }
        Vector3f vplane = new Vector3f(0.0f, 0.0f, 1.0f);
        Transform3D t = new Transform3D();
        AxisAngle4f aa = new AxisAngle4f();
        ArrayList<Color3f> colors = new ArrayList<Color3f>();
        Color3f cf = Utils.toColor3f((Color)this.color);
        HashMap<Color, Color3f> cached_colors = new HashMap<Color, Color3f>();
        cached_colors.put(this.color, cf);
        for (Set nodes : this.node_layer_map.values()) {
            for (Node nd : nodes) {
                Color3f c;
                Point2D.Double po = this.transformPoint(nd.x, nd.y);
                float x = (float)po.x * pixelWidthScaled;
                float y = (float)po.y * pixelHeightScaled;
                float z = (float)nd.la.getZ() * pixelWidthScaled * (float)sign;
                float r = ((RadiusNode)nd).r * pixelWidthScaled;
                for (Point3f vert : ico) {
                    Point3f v = new Point3f(vert);
                    v.x = v.x * r + x;
                    v.y = v.y * r + y;
                    v.z = v.z * r + z;
                    ps.add(v);
                }
                int n_verts = ico.size();
                if (null != nd.parent && (0.0f != ((Float)nd.parent.getData()).floatValue() || 0.0f != ((Float)nd.getData()).floatValue())) {
                    po = null;
                    Point2D.Double pp = this.transformPoint(nd.parent.x, nd.parent.y);
                    float parx = (float)pp.x * pixelWidthScaled;
                    float pary = (float)pp.y * pixelWidthScaled;
                    float parz = (float)nd.parent.la.getZ() * pixelWidthScaled * (float)sign;
                    float parr = ((RadiusNode)nd.parent).r * pixelWidthScaled;
                    Vector3f vpc = new Vector3f(x - parx, y - pary, z - parz);
                    if (x == parx && y == pary) {
                        aa.set(0.0f, 0.0f, 1.0f, 0.0f);
                    } else {
                        Vector3f cross = new Vector3f();
                        cross.cross(vpc, vplane);
                        cross.normalize();
                        aa.set(cross.x, cross.y, cross.z, -vplane.angle(vpc));
                    }
                    t.set(aa);
                    List<Point3f> parent_verts = Treeline.transform(t, plane, parx, pary, parz, parr);
                    List<Point3f> child_verts = Treeline.transform(t, plane, x, y, z, r);
                    for (int i = 1; i < parallels; ++i) {
                        Treeline.addTriangles(ps, parent_verts, child_verts, i - 1, i);
                        n_verts += 6;
                    }
                    Treeline.addTriangles(ps, parent_verts, child_verts, parallels - 1, 0);
                    n_verts += 6;
                }
                if (null == nd.color) {
                    c = cf;
                } else {
                    c = (Color3f)cached_colors.get(nd.color);
                    if (null == c) {
                        c = Utils.toColor3f((Color)nd.color);
                        cached_colors.put(nd.color, c);
                    }
                }
                while (n_verts > 0) {
                    --n_verts;
                    colors.add(c);
                }
            }
        }
        return new Tree.MeshData(ps, colors);
    }

    private static final void addTriangles(List<Point3f> ps, List<Point3f> parent_verts, List<Point3f> child_verts, int i0, int i1) {
        ps.add(new Point3f(parent_verts.get(i0)));
        ps.add(new Point3f(parent_verts.get(i1)));
        ps.add(new Point3f(child_verts.get(i0)));
        ps.add(new Point3f(parent_verts.get(i1)));
        ps.add(new Point3f(child_verts.get(i1)));
        ps.add(new Point3f(child_verts.get(i0)));
    }

    private static final List<Point3f> transform(Transform3D t, List<Point3f> plane, float x, float y, float z, float radius) {
        ArrayList<Point3f> ps = new ArrayList<Point3f>(plane.size());
        for (Point3f p2 : plane) {
            Point3f p = new Point3f(p2);
            p.scale(radius);
            t.transform(p);
            p.x += x;
            p.y += y;
            p.z += z;
            ps.add(p);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void keyPressed(KeyEvent ke) {
        if (this.isTagging()) {
            super.keyPressed(ke);
            return;
        }
        int tool = ProjectToolbar.getToolId();
        try {
            if (16 != tool) return;
            Object origin = ke.getSource();
            if (!(origin instanceof DisplayCanvas)) {
                ke.consume();
                return;
            }
            DisplayCanvas dc = (DisplayCanvas)origin;
            Layer layer = dc.getDisplay().getLayer();
            Point p = dc.getCursorLoc();
            switch (ke.getKeyCode()) {
                case 79: {
                    if (!this.askAdjustRadius(p.x, p.y, layer, dc.getMagnification())) return;
                    ke.consume();
                    return;
                }
            }
            return;
        }
        finally {
            if (!ke.isConsumed()) {
                super.keyPressed(ke);
            }
        }
    }

    private boolean askAdjustRadius(float x, float y, Layer layer, double magnification) {
        Node last;
        Collection nodes = (Collection)this.node_layer_map.get(layer);
        if (null == nodes) {
            return false;
        }
        RadiusNode nd = (RadiusNode)this.findClosestNodeW(nodes, x, y, magnification);
        if (null == nd && (last = this.getLastVisited()).getLayer() == layer) {
            nd = (RadiusNode)last;
        }
        if (null == nd) {
            return false;
        }
        return this.askAdjustRadius(nd);
    }

    protected boolean askAdjustRadius(Node<Float> nd) {
        GenericDialog gd = new GenericDialog("Adjust radius");
        final Calibration cal = this.layer_set.getCalibration();
        String unit = cal.getUnit();
        if (!unit.toLowerCase().startsWith("pixel")) {
            final String[] units = new String[]{"pixels", unit};
            gd.addChoice("Units:", units, units[1]);
            gd.addNumericField("Radius:", (double)nd.getData().floatValue() * cal.pixelWidth, 2);
            final TextField tfr = (TextField)gd.getNumericFields().get(0);
            ((Choice)gd.getChoices().get(0)).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    double val = Double.parseDouble(tfr.getText());
                    if (Double.isNaN(val)) {
                        return;
                    }
                    tfr.setText(Double.toString(units[0] == ie.getItem() ? val / cal.pixelWidth : val * cal.pixelWidth));
                }
            });
        } else {
            unit = null;
            gd.addNumericField("Radius:", (double)nd.getData().floatValue(), 2, 10, "pixels");
        }
        String[] choices = new String[]{"this node only", "nodes until next branch or end node", "entire subtree"};
        gd.addChoice("Apply to:", choices, choices[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        double radius = gd.getNextNumber();
        if (Double.isNaN(radius) || radius < 0.0) {
            ini.trakem2.utils.Utils.log("Invalid radius: " + radius);
            return false;
        }
        if (null != unit && 1 == gd.getNextChoiceIndex() && 0.0 != radius) {
            radius /= cal.pixelWidth;
        }
        final float r = (float)radius;
        Node.Operation<Float> op = new Node.Operation<Float>(){

            @Override
            public void apply(Node<Float> node) throws Exception {
                node.setData(Float.valueOf(r));
            }
        };
        try {
            this.layer_set.addDataEditStep(this);
            switch (gd.getNextChoiceIndex()) {
                case 0: {
                    nd.setData(Float.valueOf(r));
                    break;
                }
                case 1: {
                    nd.applyToSlab(op);
                    break;
                }
                case 2: {
                    nd.applyToSubtree(op);
                    break;
                }
                default: {
                    return false;
                }
            }
            this.layer_set.addDataEditStep(this);
        }
        catch (Exception e) {
            IJError.print(e);
            this.layer_set.undoOneStep();
        }
        this.calculateBoundingBox(this.layer);
        Display.repaint(this.layer_set);
        return true;
    }

    @Override
    protected Rectangle getBounds(Collection<? extends Node<Float>> nodes) {
        Rectangle box = null;
        for (RadiusNode radiusNode : nodes) {
            if (null == radiusNode.parent) {
                if (null == box) {
                    box = new Rectangle((int)radiusNode.x, (int)radiusNode.y, 1, 1);
                    continue;
                }
                box.add((int)radiusNode.x, (int)radiusNode.y);
                continue;
            }
            if (null == box) {
                box = radiusNode.getSegment().getBounds();
                continue;
            }
            box.add(radiusNode.getSegment().getBounds());
        }
        return box;
    }

    @Override
    protected Tree.MeasurementPair createMeasurementPair(Tree.NodePath np) {
        return new RadiusMeasurementPair(np);
    }

    private class RadiusMeasurementPair
    extends Tree.MeasurementPair {
        public RadiusMeasurementPair(Tree.NodePath np) {
            super(Treeline.this, np);
        }

        protected List<Float> calibratedData() {
            ArrayList<Float> data = new ArrayList<Float>();
            AffineTransform aff = new AffineTransform(Treeline.this.at);
            Calibration cal = Treeline.this.layer_set.getCalibration();
            aff.preConcatenate(new AffineTransform(cal.pixelWidth, 0.0, 0.0, cal.pixelHeight, 0.0, 0.0));
            float[] fp = new float[4];
            for (Node nd : this.path) {
                Float r = (Float)nd.getData();
                if (null == r) {
                    data.add(null);
                }
                fp[0] = nd.x;
                fp[1] = nd.y;
                fp[2] = nd.x + r.floatValue();
                fp[3] = nd.y;
                aff.transform(fp, 0, fp, 0, 2);
                data.add(Float.valueOf((float)Math.sqrt(Math.pow(fp[2] - fp[0], 2.0) + Math.pow(fp[3] - fp[1], 2.0))));
            }
            return data;
        }

        @Override
        public String getResultsTableTitle() {
            return "Treeline tagged pairs";
        }

        @Override
        public ResultsTable toResultsTable(ResultsTable rt, int index, double scale, int resample) {
            if (null == rt) {
                String unit = Treeline.this.layer_set.getCalibration().getUnit();
                rt = ini.trakem2.utils.Utils.createResultsTable(this.getResultsTableTitle(), new String[]{"id", "index", "length " + unit, "volume " + unit + "^3", "shortest diameter " + unit, "longest diameter " + unit, "average diameter " + unit, "stdDev diameter"});
            }
            rt.incrementCounter();
            rt.addValue(0, (double)Treeline.this.id);
            rt.addValue(1, (double)index);
            rt.addValue(2, this.distance);
            double minRadius = Double.MAX_VALUE;
            double maxRadius = 0.0;
            double sumRadii = 0.0;
            double volume = 0.0;
            int i = 0;
            double last_r = 0.0;
            Point3f last_p = null;
            Iterator itp = this.coords.iterator();
            Iterator itr = this.data.iterator();
            while (itp.hasNext()) {
                double r = ((Float)itr.next()).floatValue();
                Point3f p = (Point3f)itp.next();
                minRadius = Math.min(minRadius, r);
                maxRadius = Math.max(maxRadius, r);
                sumRadii += r;
                if (i > 0) {
                    volume += M.volumeOfTruncatedCone(r, last_r, p.distance(last_p));
                }
                ++i;
                last_r = r;
                last_p = p;
            }
            int count = this.path.size();
            double avgRadius = sumRadii / (double)count;
            double s = 0.0;
            for (Float r : this.data) {
                s += Math.pow(2.0 * ((double)r.floatValue() - avgRadius), 2.0);
            }
            double stdDev = Math.sqrt(s / (double)count);
            rt.addValue(3, volume);
            rt.addValue(4, minRadius * 2.0);
            rt.addValue(5, maxRadius * 2.0);
            rt.addValue(6, avgRadius * 2.0);
            rt.addValue(7, stdDev);
            return rt;
        }

        @Override
        public Tree.MeshData createMesh(double scale, int parallels) {
            Treeline sub = new Treeline(Treeline.this.project, -1L, Treeline.this.title, Treeline.this.width, Treeline.this.height, Treeline.this.alpha, Treeline.this.visible, Treeline.this.color, Treeline.this.locked, new AffineTransform(Treeline.this.at));
            sub.layer_set = Treeline.this.layer_set;
            sub.root = (Node)this.path.get(0);
            sub.cacheSubtree(this.path);
            return sub.generateMesh(scale, parallels);
        }
    }

    public static class RadiusNode
    extends Node<Float> {
        protected float r;

        public RadiusNode(float lx, float ly, Layer la) {
            this(lx, ly, la, 0.0f);
        }

        public RadiusNode(float lx, float ly, Layer la, float radius) {
            super(lx, ly, la);
            this.r = radius;
        }

        public RadiusNode(HashMap<String, String> attr) {
            super(attr);
            String sr = attr.get("r");
            this.r = null == sr ? 0.0f : Float.parseFloat(sr);
        }

        @Override
        public Node<Float> newInstance(float lx, float ly, Layer layer) {
            return new RadiusNode(lx, ly, layer, 0.0f);
        }

        @Override
        public final boolean setData(Float radius) {
            this.r = radius.floatValue() > 0.0f ? radius.floatValue() : 0.0f;
            return true;
        }

        @Override
        public final Float getData() {
            return Float.valueOf(this.r);
        }

        @Override
        public final Float getDataCopy() {
            return Float.valueOf(this.r);
        }

        @Override
        public boolean isRoughlyInside(Rectangle localbox) {
            if (0.0f == this.r) {
                if (null == this.parent) {
                    return localbox.contains((int)this.x, (int)this.y);
                }
                if (0.0f == ((Float)this.parent.getData()).floatValue()) {
                    return localbox.intersectsLine(this.parent.x, this.parent.y, this.x, this.y);
                }
                return this.segmentIntersects(localbox);
            }
            if (null == this.parent) {
                return localbox.contains((int)this.x, (int)this.y);
            }
            return this.segmentIntersects(localbox);
        }

        private final Polygon getSegment() {
            RadiusNode parent = (RadiusNode)this.parent;
            float vx = parent.x - this.x;
            float vy = parent.y - this.y;
            float len = (float)Math.sqrt(vx * vx + vy * vy);
            if (0.0f == len) {
                return new Polygon(new int[]{(int)this.x, (int)Math.ceil(parent.x)}, new int[]{(int)this.y, (int)Math.ceil(parent.y)}, 2);
            }
            float vx90 = -(vy /= len);
            float vy90 = vx /= len;
            float vx270 = vy;
            float vy270 = -vx;
            return new Polygon(new int[]{(int)(parent.x + vx90 * parent.r), (int)(parent.x + vx270 * parent.r), (int)(this.x + vx270 * this.r), (int)(this.x + vx90 * this.r)}, new int[]{(int)(parent.y + vy90 * parent.r), (int)(parent.y + vy270 * parent.r), (int)(this.y + vy270 * this.r), (int)(this.y + vy90 * this.r)}, 4);
        }

        private final boolean segmentIntersects(Rectangle localRect) {
            RadiusNode parent = (RadiusNode)this.parent;
            float vx = parent.x - this.x;
            float vy = parent.y - this.y;
            float len = (float)Math.sqrt(vx * vx + vy * vy);
            if (0.0f == len) {
                return localRect.contains(this.x, this.y);
            }
            float x1 = parent.x + -(vy /= len) * parent.r;
            float y1 = parent.y + (vx /= len) * parent.r;
            float x2 = parent.x + vy * parent.r;
            float y2 = parent.y + -vx * parent.r;
            float x3 = this.x + vy * this.r;
            float y3 = this.y + -vx * this.r;
            float x4 = this.x + -vy * this.r;
            float y4 = this.y + vx * this.r;
            float min_x = Math.min(Math.min(x1, x2), Math.min(x3, x4));
            float min_y = Math.min(Math.min(y1, y2), Math.min(y3, y4));
            float max_x = Math.max(Math.max(x1, x2), Math.max(x3, x4));
            float max_y = Math.max(Math.max(y1, y2), Math.max(y3, y4));
            return min_x + max_x - min_x > (float)localRect.x && min_y + max_y - min_y > (float)localRect.y && min_x < (float)(localRect.x + localRect.width) && min_y < (float)(localRect.y + localRect.height);
        }

        @Override
        public void paintData(Graphics2D g, Rectangle srcRect, Tree<Float> tree, AffineTransform to_screen, Color cc, Layer active_layer) {
            if (null == this.parent) {
                return;
            }
            if (0.0f == this.r && 0.0f == ((Float)this.parent.getData()).floatValue()) {
                return;
            }
            Shape shape = to_screen.createTransformedShape(this.getSegment());
            Composite c = g.getComposite();
            float alpha = tree.getAlpha();
            g.setComposite(AlphaComposite.getInstance(3, alpha > 0.4f ? 0.4f : alpha));
            g.setColor(cc);
            g.fill(shape);
            g.setComposite(c);
            g.draw(shape);
        }

        @Override
        public boolean intersects(Area a) {
            if (0.0f == this.r) {
                return a.contains(this.x, this.y);
            }
            return M.intersects(a, new Area(new Ellipse2D.Float(this.x - this.r, this.y - this.r, this.r + this.r, this.r + this.r)));
        }

        @Override
        public void apply(CoordinateTransform ct, Area roi) {
            double ox = this.x;
            double oy = this.y;
            super.apply(ct, roi);
            if (0.0f != this.r) {
                double[] fp = new double[]{ox + (double)this.r, oy};
                ct.applyInPlace(fp);
                this.r = (float)Math.abs(fp[0] - (double)this.x);
            }
        }

        @Override
        public void apply(VectorDataTransform vdt) {
            for (VectorDataTransform.ROITransform rt : vdt.transforms) {
                if (!rt.roi.contains(this.x, this.y)) continue;
                double ox = this.x;
                double oy = this.y;
                double[] fp = new double[]{this.x, this.y};
                rt.ct.applyInPlace(fp);
                this.x = (float)fp[0];
                this.y = (float)fp[1];
                if (0.0f == this.r) break;
                fp[0] = ox + (double)this.r;
                fp[1] = oy;
                rt.ct.applyInPlace(fp);
                this.r = (float)Math.abs(fp[0] - (double)this.x);
                break;
            }
        }

        @Override
        protected void transformData(AffineTransform aff) {
            switch (aff.getType()) {
                case 0: 
                case 1: {
                    return;
                }
            }
            double[] fp = new double[]{this.x, this.y, this.x + this.r, this.y};
            aff.transform(fp, 0, fp, 0, 2);
            this.r = (float)Math.sqrt(Math.pow(fp[2] - fp[0], 2.0) + Math.pow(fp[3] - fp[1], 2.0));
        }
    }
}

