/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.utils.M;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;
import mpicbg.models.CoordinateTransform;

public final class VectorDataTransform {
    public final Layer layer;
    public final List<ROITransform> transforms = new ArrayList<ROITransform>();

    public VectorDataTransform(Layer layer) {
        this.layer = layer;
    }

    public void add(Area roi, CoordinateTransform ct) {
        this.transforms.add(new ROITransform(roi, ct));
    }

    public VectorDataTransform makeLocalTo(Displayable d) throws Exception {
        VectorDataTransform local = new VectorDataTransform(this.layer);
        AffineTransform inverse = d.at.createInverse();
        for (ROITransform rt : this.transforms) {
            local.add(rt.roi.createTransformedArea(inverse), M.wrap(d.at, rt.ct, inverse));
        }
        return local;
    }

    public class ROITransform {
        public CoordinateTransform ct;
        public Area roi;

        public ROITransform(Area roi, CoordinateTransform ct) {
            this.roi = roi;
            this.ct = ct;
        }
    }
}

