/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import mpicbg.util.Matrix3x3;
import mpicbg.util.Util;

public class ColorYCbCrComposite
implements Composite {
    static final float[] rgb2ycbcr = new float[]{0.299f, 0.587f, 0.114f, -0.168736f, -0.331264f, 0.5f, 0.5f, -0.418688f, -0.081312f};
    static final float[] ycbcr2rgb = (float[])rgb2ycbcr.clone();
    private static ColorYCbCrComposite instance;
    private final float alpha;

    public static ColorYCbCrComposite getInstance(float alpha) {
        if (alpha == 1.0f) {
            return instance;
        }
        return new ColorYCbCrComposite(alpha);
    }

    private ColorYCbCrComposite() {
        this.alpha = 1.0f;
    }

    private static final void rgb2ycbcr(int[] rgb, float[] ycbcr) {
        float r = (float)rgb[0] / 255.0f;
        float g = (float)rgb[1] / 255.0f;
        float b = (float)rgb[2] / 255.0f;
        ycbcr[0] = rgb2ycbcr[0] * r + rgb2ycbcr[1] * g + rgb2ycbcr[2] * b;
        ycbcr[1] = rgb2ycbcr[3] * r + rgb2ycbcr[4] * g + rgb2ycbcr[5] * b;
        ycbcr[2] = rgb2ycbcr[6] * r + rgb2ycbcr[7] * g + rgb2ycbcr[8] * b;
    }

    private static final void ycbcr2rgb(float[] ycbcr, int[] rgb) {
        float r = ycbcr2rgb[0] * ycbcr[0] + ycbcr2rgb[1] * ycbcr[1] + ycbcr2rgb[2] * ycbcr[2];
        float g = ycbcr2rgb[3] * ycbcr[0] + ycbcr2rgb[4] * ycbcr[1] + ycbcr2rgb[5] * ycbcr[2];
        float b = ycbcr2rgb[6] * ycbcr[0] + ycbcr2rgb[7] * ycbcr[1] + ycbcr2rgb[8] * ycbcr[2];
        rgb[0] = Math.max(0, Math.min(255, Math.round(r * 255.0f)));
        rgb[1] = Math.max(0, Math.min(255, Math.round(g * 255.0f)));
        rgb[2] = Math.max(0, Math.min(255, Math.round(b * 255.0f)));
    }

    private ColorYCbCrComposite(float alpha) {
        this.alpha = alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        final Composer c = srcColorModel.getNumColorComponents() > 1 ? (srcColorModel.hasAlpha() ? new ARGB2ARGB() : new RGB2ARGB()) : new Gray2ARGB();
        return new CompositeContext(){
            private Composer composer;
            {
                this.composer = c;
            }

            @Override
            public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                int[] srcPixel = new int[4];
                int[] dstInPixel = new int[4];
                for (int x = 0; x < dstOut.getWidth(); ++x) {
                    for (int y = 0; y < dstOut.getHeight(); ++y) {
                        src.getPixel(x, y, srcPixel);
                        dstIn.getPixel(x, y, dstInPixel);
                        this.composer.compose(srcPixel, dstInPixel, ColorYCbCrComposite.this.alpha);
                        dstOut.setPixel(x, y, dstInPixel);
                    }
                }
            }

            @Override
            public void dispose() {
            }
        };
    }

    static {
        try {
            Matrix3x3.invert((float[])ycbcr2rgb);
        }
        catch (Exception exception) {
            // empty catch block
        }
        instance = new ColorYCbCrComposite();
    }

    private static final class Gray2ARGB
    implements Composer {
        private Gray2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            float dstAlpha = 1.0f - alpha;
            float l = 0.299f * (float)dst[0] + 0.587f * (float)dst[1] + 0.114f * (float)dst[2];
            dst[0] = Math.max(0, Math.min(255, Util.round((float)(l * alpha + (float)dst[0] * dstAlpha))));
            dst[1] = Math.max(0, Math.min(255, Util.round((float)(l * alpha + (float)dst[1] * dstAlpha))));
            dst[2] = Math.max(0, Math.min(255, Util.round((float)(l * alpha + (float)dst[2] * dstAlpha))));
            dst[3] = 255;
        }
    }

    private static final class RGB2ARGB
    implements Composer {
        final float[] srcYCbCr = new float[3];
        final float[] dstYCbCr = new float[3];

        private RGB2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            ColorYCbCrComposite.rgb2ycbcr(src, this.srcYCbCr);
            ColorYCbCrComposite.rgb2ycbcr(dst, this.dstYCbCr);
            float dstAlpha = 1.0f - alpha;
            this.dstYCbCr[1] = this.srcYCbCr[1] * alpha + this.dstYCbCr[1] * dstAlpha;
            this.dstYCbCr[2] = this.srcYCbCr[2] * alpha + this.dstYCbCr[2] * dstAlpha;
            ColorYCbCrComposite.ycbcr2rgb(this.dstYCbCr, dst);
            dst[3] = 255;
        }
    }

    private static final class ARGB2ARGB
    implements Composer {
        final float[] srcYCbCr = new float[3];
        final float[] dstYCbCr = new float[3];

        private ARGB2ARGB() {
        }

        @Override
        public final void compose(int[] src, int[] dst, float alpha) {
            ColorYCbCrComposite.rgb2ycbcr(src, this.srcYCbCr);
            ColorYCbCrComposite.rgb2ycbcr(dst, this.dstYCbCr);
            float srcAlpha = (float)src[3] / 255.0f * alpha;
            float dstAlpha = 1.0f - srcAlpha;
            this.dstYCbCr[1] = this.srcYCbCr[1] * srcAlpha + this.dstYCbCr[1] * dstAlpha;
            this.dstYCbCr[2] = this.srcYCbCr[2] * srcAlpha + this.dstYCbCr[2] * dstAlpha;
            ColorYCbCrComposite.ycbcr2rgb(this.dstYCbCr, dst);
            dst[3] = 255;
        }
    }

    private static interface Composer {
        public void compose(int[] var1, int[] var2, float var3);
    }
}

