/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class PolynomialTransform2D
implements RealTransform {
    protected int order = 0;
    protected double[] a = new double[2];
    protected double[] polTerms = new double[0];

    public static final int orderOf(int numPolTerms) {
        return (int)Math.nextUp(Math.sqrt((double)(2 * numPolTerms) + 0.25) - 1.5);
    }

    public static final int numPolTerms(int order) {
        return (int)Math.round((double)((order + 2) * (order + 1)) * 0.5);
    }

    public void set(double ... a) {
        this.order = PolynomialTransform2D.orderOf(a.length / 2);
        int numPolTerms = PolynomialTransform2D.numPolTerms(this.order);
        this.a = a;
        this.polTerms = new double[numPolTerms - 1];
    }

    protected void populateTerms(double x, double y) {
        if (this.order == 0) {
            return;
        }
        this.polTerms[0] = x;
        this.polTerms[1] = y;
        int o = 2;
        int i = 2;
        while (o <= this.order) {
            for (int p = 0; p < o; ++p) {
                this.polTerms[i + p] = this.polTerms[i + p - o] * x;
            }
            this.polTerms[i + o] = this.polTerms[i - 1] * y;
            i += ++o;
        }
    }

    protected void printTerms() {
        Object[] polTermString = new String[this.polTerms.length];
        if (this.order == 0) {
            System.out.println("No polynomial terms.");
        }
        polTermString[0] = "x";
        polTermString[1] = "y";
        int o = 2;
        int i = 2;
        while (o <= this.order) {
            for (int p = 0; p < o; ++p) {
                polTermString[i + p] = (String)polTermString[i + p - o] + "x";
            }
            polTermString[i + o] = (String)polTermString[i - 1] + "y";
            i += ++o;
        }
        System.out.println(Arrays.toString(polTermString));
    }

    @Override
    public int numSourceDimensions() {
        return 2;
    }

    @Override
    public int numTargetDimensions() {
        return 2;
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.populateTerms(source[0], source[1]);
        target[0] = this.a[0];
        int i = 0;
        while (i < this.polTerms.length) {
            target[0] = target[0] + this.polTerms[i] * this.a[++i];
        }
        int numPolTerms = this.polTerms.length + 1;
        target[1] = this.a[numPolTerms];
        int i2 = 0;
        while (i2 < this.polTerms.length) {
            target[1] = target[1] + this.polTerms[i2] * this.a[++i2 + numPolTerms];
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        this.populateTerms(source[0], source[1]);
        double x = this.a[0];
        int i = 0;
        while (i < this.polTerms.length) {
            x += this.polTerms[i] * this.a[++i];
        }
        int numPolTerms = this.polTerms.length + 1;
        double y = this.a[numPolTerms];
        int i2 = 0;
        while (i2 < this.polTerms.length) {
            y += this.polTerms[i2] * this.a[++i2 + numPolTerms];
        }
        target[0] = (float)x;
        target[1] = (float)y;
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.populateTerms(source.getDoublePosition(0), source.getDoublePosition(1));
        double x = this.a[0];
        int i = 0;
        while (i < this.polTerms.length) {
            x += this.polTerms[i] * this.a[++i];
        }
        int numPolTerms = this.polTerms.length + 1;
        double y = this.a[numPolTerms];
        int i2 = 0;
        while (i2 < this.polTerms.length) {
            y += this.polTerms[i2] * this.a[++i2 + numPolTerms];
        }
        target.setPosition(x, 0);
        target.setPosition(y, 1);
    }

    @Override
    public RealTransform copy() {
        PolynomialTransform2D copy = new PolynomialTransform2D();
        copy.set((double[])this.a.clone());
        return copy;
    }
}

