/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.scijava.Context;
import org.scijava.ui.UIService;
import sc.fiji.labkit.ui.LabkitFrame;
import sc.fiji.labkit.ui.actions.AbstractFileIoAction;

public class Main {
    public static void main(String ... args) {
        String filename = Main.readCommandline(args);
        if (filename == null) {
            filename = Main.showOpenDialog();
        }
        if (filename != null) {
            Main.start(filename);
        }
    }

    private static String readCommandline(String[] args) {
        switch (args.length) {
            case 1: {
                return args[0];
            }
            case 0: {
                return null;
            }
        }
        System.err.println("USAGE:    ./start.sh {optional/path/to/image.tif}");
        System.exit(2);
        throw new AssertionError();
    }

    private static String showOpenDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        FileFilter fileFilter = AbstractFileIoAction.TIFF_FILTER;
        fileChooser.setFileFilter(fileFilter);
        fileChooser.addChoosableFileFilter(fileFilter);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return null;
        }
        return fileChooser.getSelectedFile().getAbsolutePath();
    }

    public static void start(String filename) {
        Context context = new Context();
        ((UIService)context.service(UIService.class)).showUI();
        LabkitFrame.showForFile(context, filename);
    }
}

