/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.imglib2.Dimensions;
import net.imglib2.util.Intervals;
import net.miginfocom.swing.MigLayout;
import sc.fiji.labkit.ui.BasicLabelingComponent;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.panel.GuiUtils;

public class ImageInfoPanel {
    private ImageInfoPanel() {
    }

    public static JPanel newFramedImageInfoPanel(ImageLabelingModel imageLabelingModel, BasicLabelingComponent labelingComponent) {
        return GuiUtils.createCheckboxGroupedPanel(imageLabelingModel.imageVisibility(), "Image", ImageInfoPanel.createDimensionsInfo((Dimensions)imageLabelingModel.labeling().get(), labelingComponent));
    }

    private static JComponent createDimensionsInfo(Dimensions interval, BasicLabelingComponent labelingComponent) {
        Color background = UIManager.getColor("List.background");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 8, gap 8", "10[grow][grow]", ""));
        panel.setBackground(background);
        JLabel label = new JLabel("Dimensions: " + Arrays.toString(Intervals.dimensionsAsLongArray((Dimensions)interval)));
        panel.add((Component)label, "grow, span, wrap");
        if (labelingComponent != null) {
            JButton button = new JButton("auto contrast");
            button.setFocusable(false);
            button.addActionListener(ignore -> labelingComponent.autoContrast());
            panel.add((Component)button, "grow");
            JButton settingsButton = new JButton("settings");
            settingsButton.setFocusable(false);
            settingsButton.addActionListener(ignore -> labelingComponent.toggleContrastSettings());
            panel.add((Component)settingsButton, "grow, wrap");
        }
        return panel;
    }
}

