/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.plugin;

import ij.ImagePlus;
import java.io.File;
import net.imglib2.img.VirtualStackAdapter;
import net.imglib2.img.display.imagej.ImageJFunctions;
import org.scijava.Cancelable;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.ui.segmentation.SegmentationTool;
import sc.fiji.labkit.ui.utils.progress.StatusServiceProgressWriter;

@Plugin(type=Command.class, menuPath="Plugins > Labkit > Macro Recordable > Segment Image With Labkit (IJ1)")
public class SegmentImageWithLabkitIJ1Plugin
implements Command,
Cancelable {
    @Parameter
    private Context context;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ImagePlus input;
    @Parameter
    private File segmenter_file;
    @Parameter(type=ItemIO.OUTPUT)
    private ImagePlus output;
    @Parameter(required=false)
    private Boolean use_gpu = false;

    public void run() {
        SegmentationTool segmenter = new SegmentationTool();
        segmenter.setContext(this.context);
        segmenter.setUseGpu(this.use_gpu);
        segmenter.setProgressWriter(new StatusServiceProgressWriter(this.statusService));
        segmenter.openModel(this.segmenter_file.getAbsolutePath());
        this.output = ImageJFunctions.wrap(segmenter.segment(VirtualStackAdapter.wrap((ImagePlus)this.input)), (String)"");
        this.output.show();
    }

    public boolean isCanceled() {
        return false;
    }

    public void cancel(String reason) {
    }

    public String getCancelReason() {
        return null;
    }
}

