/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.queue;

import java.util.ArrayDeque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingFetchQueues<E> {
    private final ArrayDeque<E>[] queues;
    private final int maxPriority;
    private final int prefetchCapacity;
    private final ArrayDeque<E> prefetch;
    private int count;
    private boolean paused;
    private final int numConsumers;
    private int waitCount;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition isPaused;
    private volatile long currentFrame = 0L;

    public BlockingFetchQueues(int numPriorities, int numConsumers) {
        this(numPriorities, numConsumers, 16384);
    }

    public BlockingFetchQueues(int numPriorities, int numConsumers, int prefetchCapacity) {
        if (numPriorities < 1) {
            throw new IllegalArgumentException("expected numPriorities >= 1");
        }
        this.queues = new ArrayDeque[numPriorities];
        this.maxPriority = numPriorities - 1;
        for (int i = 0; i < numPriorities; ++i) {
            this.queues[i] = new ArrayDeque();
        }
        this.numConsumers = numConsumers;
        this.prefetchCapacity = prefetchCapacity;
        this.prefetch = new ArrayDeque(prefetchCapacity);
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.isPaused = this.lock.newCondition();
    }

    public void put(E element, int priority, boolean enqueuToFront) {
        this.put_unsafe(element, Math.max(Math.min(priority, this.maxPriority), 0), enqueuToFront);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put_unsafe(E element, int priority, boolean enqueuToFront) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (enqueuToFront) {
                this.queues[priority].addFirst(element);
            } else {
                this.queues[priority].add(element);
            }
            ++this.count;
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (++this.waitCount == this.numConsumers) {
                this.isPaused.signal();
            }
            while (this.count == 0 || this.paused) {
                this.notEmpty.await();
            }
            --this.waitCount;
            --this.count;
            for (ArrayDeque<E> q : this.queues) {
                if (q.isEmpty()) continue;
                E e = q.remove();
                return e;
            }
            E e = this.prefetch.poll();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    public void pause() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (!this.paused) {
                this.paused = true;
                while (this.waitCount != this.numConsumers) {
                    this.isPaused.await();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void resume() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            if (this.paused) {
                this.paused = false;
                this.notEmpty.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearToPrefetch() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ++this.currentFrame;
            int toRemoveFromPrefetch = Math.max(0, Math.min(this.prefetch.size(), this.count - this.prefetchCapacity));
            if (toRemoveFromPrefetch == this.prefetch.size()) {
                this.prefetch.clear();
            } else {
                for (int i = 0; i < toRemoveFromPrefetch; ++i) {
                    this.prefetch.remove();
                }
            }
            int c = this.prefetchCapacity;
            ArrayDeque<E> q0 = this.queues[0];
            int q0n = Math.min(q0.size(), c);
            for (int i = 0; i < q0n; ++i) {
                this.prefetch.addFirst(q0.removeLast());
            }
            q0.clear();
            c -= q0n;
            for (int j = 1; j < this.queues.length; ++j) {
                ArrayDeque<E> q = this.queues[j];
                int qn = Math.min(q.size(), c);
                for (int i = 0; i < qn; ++i) {
                    this.prefetch.addLast(q.removeFirst());
                }
                q.clear();
                c -= qn;
            }
            this.count = this.prefetch.size();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (ArrayDeque<E> queue : this.queues) {
                queue.clear();
            }
            this.prefetch.clear();
            this.count = 0;
        }
        finally {
            lock.unlock();
        }
    }

    public int getNumPriorities() {
        return this.maxPriority + 1;
    }

    public long getCurrentFrame() {
        return this.currentFrame;
    }
}

