/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.vector;

import ij.gui.PolygonRoi;
import ij.io.RoiDecoder;
import ij.measure.Calibration;
import ini.trakem2.vector.Util;
import ini.trakem2.vector.VectorString;
import java.awt.Polygon;

public class VectorString2D
implements VectorString {
    private double[] x;
    private double[] y;
    private double[] v_x = null;
    private double[] v_y = null;
    private int length;
    private double delta = 0.0;
    private double z;
    private boolean closed;
    private Calibration cal = null;

    public VectorString2D(double[] x, double[] y, double z, boolean closed) throws Exception {
        if (x.length != y.length) {
            throw new Exception("x and y must be of the same length.");
        }
        this.length = x.length;
        this.x = x;
        this.y = y;
        this.z = z;
        this.closed = closed;
    }

    public Object clone() {
        double[] x2 = new double[this.length];
        double[] y2 = new double[this.length];
        System.arraycopy(this.x, 0, x2, 0, this.length);
        System.arraycopy(this.y, 0, y2, 0, this.length);
        try {
            return new VectorString2D(x2, y2, this.z, this.closed);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double getDelta() {
        return this.delta;
    }

    @Override
    public double[] getPoints(int dim) {
        switch (dim) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        return null;
    }

    @Override
    public double[] getVectors(int dim) {
        switch (dim) {
            case 0: {
                return this.v_x;
            }
            case 1: {
                return this.v_y;
            }
        }
        return null;
    }

    @Override
    public double getPoint(int dim, int i) {
        switch (dim) {
            case 0: {
                return this.x[i];
            }
            case 1: {
                return this.y[i];
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0;
    }

    @Override
    public double getVector(int dim, int i) {
        switch (dim) {
            case 0: {
                return this.v_x[i];
            }
            case 1: {
                return this.v_y[i];
            }
        }
        return 0.0;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public double getAverageDelta() {
        double d = 0.0;
        for (int i = this.x.length - 1; i > 0; --i) {
            d += Math.sqrt((this.x[i] - this.x[i - 1]) * (this.x[i] - this.x[i - 1]) + (this.y[i] - this.y[i - 1]) * (this.y[i] - this.y[i - 1]));
        }
        return d / (double)this.x.length;
    }

    @Override
    public void resample(double delta, boolean with_source) {
        this.resample(delta);
    }

    @Override
    public void resample(double delta) {
        if (Math.abs(delta - this.delta) < 1.0E-7) {
            return;
        }
        this.delta = delta;
        this.resample();
    }

    private final void reorderToCCW() {
        double x_max = 0.0;
        int x_max_i = 0;
        double y_max = 0.0;
        int y_max_i = 0;
        double x_min = Double.MAX_VALUE;
        int x_min_i = 0;
        double y_min = Double.MAX_VALUE;
        int y_min_i = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.x[i] > x_max) {
                x_max = this.x[i];
                x_max_i = i;
            }
            if (this.y[i] > y_max) {
                y_max = this.y[i];
                y_max_i = i;
            }
            if (this.x[i] < x_min) {
                x_min = this.x[i];
                x_min_i = i;
            }
            if (!(this.y[i] < y_min)) continue;
            y_min = this.y[i];
            y_min_i = i;
        }
        int collect = 0;
        if (y_min_i - x_max_i >= 0) {
            ++collect;
        }
        if (x_min_i - y_min_i >= 0) {
            ++collect;
        }
        if (y_max_i - x_min_i >= 0) {
            ++collect;
        }
        if (x_max_i - y_max_i >= 0) {
            ++collect;
        }
        if (3 != collect) {
            int n = this.length;
            for (int i = 0; i < this.length / 2; ++i) {
                double tmp = this.x[i];
                this.x[i] = this.x[n - i - 1];
                this.x[n - i - 1] = tmp;
                tmp = this.y[i];
                this.y[i] = this.y[n - i - 1];
                this.y[n - i - 1] = tmp;
            }
        }
    }

    private void resample() {
        this.reorderToCCW();
        Util.DoublePolygon dpol = Util.createInterpolatedPolygon(new Util.DoublePolygon(this.x, this.y, this.length), 1.0, !this.closed);
        Util.CircularSequence seq = new Util.CircularSequence(dpol.npoints);
        double[] xpoints = new double[dpol.npoints];
        double[] ypoints = new double[dpol.npoints];
        Util.convolveGaussianSigma1(dpol.xpoints, xpoints, seq);
        Util.convolveGaussianSigma1(dpol.ypoints, ypoints, seq);
        if ((double)dpol.npoints > this.delta) {
            dpol = Util.createInterpolatedPolygon(new Util.DoublePolygon(xpoints, ypoints, dpol.npoints), this.delta, !this.closed);
        }
        this.length = dpol.npoints;
        this.x = dpol.xpoints;
        this.y = dpol.ypoints;
        this.v_x = new double[this.length];
        this.v_y = new double[this.length];
        for (int k = 1; k < this.length; ++k) {
            this.v_x[k] = this.x[k] - this.x[k - 1];
            this.v_y[k] = this.y[k] - this.y[k - 1];
        }
        this.v_x[0] = this.x[0] - this.x[this.length - 1];
        this.v_y[0] = this.y[0] - this.y[this.length - 1];
    }

    @Override
    public void reorder(int new_zero) {
        int j;
        double[] tmp = new double[this.length];
        double[] src = this.x;
        int i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.x = tmp;
        tmp = src;
        src = this.y;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.y = tmp;
        tmp = src;
        src = this.v_x;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.v_x = tmp;
        tmp = src;
        src = this.v_y;
        i = 0;
        for (j = new_zero; j < this.length; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        for (j = 0; j < new_zero; ++j) {
            tmp[i] = src[j];
            ++i;
        }
        this.v_y = tmp;
        tmp = src;
        tmp = null;
    }

    @Override
    public double getDiffVectorLength(int i, int j, VectorString vs2) {
        VectorString2D vs = (VectorString2D)vs2;
        double dx = this.v_x[i] - vs.v_x[j];
        double dy = this.v_y[i] - vs.v_y[j];
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public double distance(int i, VectorString vs, int j) {
        VectorString2D vs2 = (VectorString2D)vs;
        return VectorString2D.distance(this.x[i], this.y[i], vs2.x[i], vs2.y[i]);
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
    }

    @Override
    public VectorString subVectorString(int first, int last) throws Exception {
        boolean reverse = false;
        if (last < first) {
            int tmp = first;
            first = last;
            last = tmp;
            reverse = true;
        }
        int len = last - first + 1;
        double[] x = new double[len];
        double[] y = new double[len];
        System.arraycopy(this.x, first, x, 0, len);
        System.arraycopy(this.y, first, y, 0, len);
        VectorString2D vs = new VectorString2D(x, y, this.z, this.closed);
        if (reverse) {
            vs.reverse();
        }
        if (null != this.v_x) {
            vs.delta = this.delta;
            vs.v_x = new double[len];
            vs.v_y = new double[len];
            for (int i = 1; i < len; ++i) {
                vs.v_x[i] = vs.x[i] - vs.x[i - 1];
                vs.v_y[i] = vs.y[i] - vs.y[i - 1];
            }
        }
        return vs;
    }

    @Override
    public void reverse() {
        Util.reverse(this.x);
        Util.reverse(this.y);
        this.delta = 0.0;
        if (null != this.v_x) {
            this.v_y = null;
            this.v_x = null;
        }
    }

    @Override
    public int getDimensions() {
        return 2;
    }

    public void calibrate(Calibration cal) {
        if (null == cal) {
            return;
        }
        this.cal = cal;
        int sign = cal.pixelDepth < 0.0 ? -1 : 1;
        int i = 0;
        while (i < this.x.length) {
            int n = i;
            this.x[n] = this.x[n] * cal.pixelWidth;
            int n2 = i++;
            this.y[n2] = this.y[n2] * cal.pixelHeight;
        }
        this.z *= cal.pixelWidth * (double)sign;
        if (null != this.v_x) {
            this.v_y = null;
            this.v_x = null;
        }
        this.delta = 0.0;
    }

    public boolean isCalibrated() {
        return null != this.cal;
    }

    public Calibration getCalibrationCopy() {
        return null == this.cal ? null : this.cal.copy();
    }

    public static final void main(String[] args) {
        try {
            int i;
            RoiDecoder rd = new RoiDecoder("/home/albert/Desktop/t2/test-spline/1152-polygon.roi");
            PolygonRoi sroi = (PolygonRoi)rd.getRoi();
            Polygon pol = sroi.getPolygon();
            double[] x = new double[pol.npoints];
            double[] y = new double[pol.npoints];
            for (int i2 = 0; i2 < pol.npoints; ++i2) {
                x[i2] = pol.xpoints[i2];
                y[i2] = pol.ypoints[i2];
            }
            VectorString2D v = new VectorString2D(x, y, 0.0, true);
            v.resample(1.0);
            StringBuffer sb = new StringBuffer();
            sb.append("x = [");
            for (i = 0; i < v.length; ++i) {
                sb.append(v.x[i] + ",\n");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
            sb.append("\ny = [");
            for (i = 0; i < v.length; ++i) {
                sb.append(v.y[i] + ",\n");
            }
            sb.setLength(sb.length() - 2);
            sb.append("]\n");
            System.out.println(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

