/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import org.jhotdraw.util.Images;
import org.jhotdraw.util.ResourceBundleUtil;

public class ColorIcon
implements Icon {
    @Nullable
    private Color fillColor;
    private static BufferedImage noColorImage;
    private int width;
    private int height;
    private String name;

    public ColorIcon(int rgb) {
        this(new Color(rgb));
    }

    public ColorIcon(@Nullable Color color) {
        this(color, color == null ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getToolTipTextProperty("attribute.color.noColor") : color.getRed() + "," + color.getGreen() + "," + color.getBlue(), 14, 14);
    }

    public ColorIcon(int rgb, String name) {
        this(new Color(rgb), name, 14, 14);
    }

    public ColorIcon(@Nullable Color color, String name) {
        this(color, name, 14, 14);
    }

    public ColorIcon(@Nullable Color color, String name, int width, int height) {
        this.fillColor = color;
        this.name = name;
        this.width = width;
        this.height = height;
        if (noColorImage == null) {
            noColorImage = Images.toBufferedImage(Images.createImage(ColorIcon.class, "/org/jhotdraw/draw/action/images/attribute.color.noColor.png"));
        }
    }

    public Color getColor() {
        return this.fillColor;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.fillColor == null || this.fillColor.getAlpha() == 0) {
            if (this.width == noColorImage.getWidth() && this.height == noColorImage.getHeight()) {
                g.drawImage(noColorImage, x, y, c);
            } else {
                g.setColor(Color.WHITE);
                g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
                g.setColor(Color.red);
                int[] xpoints = new int[]{x + 2, x + this.width - 5, x + this.width - 3, x + this.width - 3, x + 4, x + 2};
                int[] ypoints = new int[]{y + this.height - 5, y + 2, y + 2, y + 4, y + this.height - 3, y + this.height - 3};
                g.fillPolygon(xpoints, ypoints, xpoints.length);
            }
        } else {
            g.setColor(this.fillColor);
            g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
        }
        g.setColor(new Color(0x666666));
        g.drawLine(x, y, x + this.width - 1, y);
        g.drawLine(x + this.width - 1, y, x + this.width - 1, y + this.width - 1);
        g.drawLine(x + this.width - 1, y + this.height - 1, x, y + this.height - 1);
        g.drawLine(x, y + this.height - 1, x, y);
    }
}

