/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.handle.BoundsOutlineHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.ResizeHandleKit;
import org.jhotdraw.draw.handle.TransformHandleKit;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

public class SVGEllipseFigure
extends SVGAttributedFigure
implements SVGFigure {
    private Ellipse2D.Double ellipse;
    @Nullable
    private transient Shape cachedTransformedShape;
    @Nullable
    private transient Shape cachedHitShape;

    public SVGEllipseFigure() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public SVGEllipseFigure(double x, double y, double width, double height) {
        this.ellipse = new Ellipse2D.Double(x, y, width, height);
        SVGAttributeKeys.setDefaults(this);
        this.setConnectable(false);
    }

    @Override
    protected void drawFill(Graphics2D g) {
        if (this.ellipse.width > 0.0 && this.ellipse.height > 0.0) {
            g.fill(this.ellipse);
        }
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        if (this.ellipse.width > 0.0 && this.ellipse.height > 0.0) {
            g.draw(this.ellipse);
        }
    }

    public double getX() {
        return this.ellipse.x;
    }

    public double getY() {
        return this.ellipse.y;
    }

    public double getWidth() {
        return this.ellipse.getWidth();
    }

    public double getHeight() {
        return this.ellipse.getHeight();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.ellipse.getBounds2D();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r;
        Rectangle2D rx = this.getTransformedShape().getBounds2D();
        Rectangle2D.Double double_ = r = rx instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
        if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
            double g = SVGAttributeKeys.getPerpendicularHitGrowth(this) * 2.0 + 1.0;
            Geom.grow(r, g, g);
        } else {
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            Geom.grow(r, width *= Math.max(((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).getScaleX(), ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).getScaleY()) + 1.0, width);
        }
        return r;
    }

    @Override
    public boolean contains(Point2D.Double p) {
        return this.getHitShape().contains(p);
    }

    private Shape getTransformedShape() {
        if (this.cachedTransformedShape == null) {
            this.cachedTransformedShape = this.get(SVGAttributeKeys.TRANSFORM) == null ? this.ellipse : ((AffineTransform)this.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(this.ellipse);
        }
        return this.cachedTransformedShape;
    }

    private Shape getHitShape() {
        if (this.cachedHitShape == null) {
            this.cachedHitShape = this.get(SVGAttributeKeys.FILL_COLOR) != null || this.get(SVGAttributeKeys.FILL_GRADIENT) != null ? new GrowStroke((float)SVGAttributeKeys.getStrokeTotalWidth(this) / 2.0f, (float)SVGAttributeKeys.getStrokeTotalMiterLimit(this)).createStrokedShape(this.getTransformedShape()) : SVGAttributeKeys.getHitStroke(this).createStrokedShape(this.getTransformedShape());
        }
        return this.cachedHitShape;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.ellipse.x = Math.min(anchor.x, lead.x);
        this.ellipse.y = Math.min(anchor.y, lead.y);
        this.ellipse.width = Math.max(0.1, Math.abs(lead.x - anchor.x));
        this.ellipse.height = Math.max(0.1, Math.abs(lead.y - anchor.y));
        this.invalidate();
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.get(SVGAttributeKeys.TRANSFORM) != null || (tx.getType() & 1) != tx.getType()) {
            if (this.get(SVGAttributeKeys.TRANSFORM) == null) {
                SVGAttributeKeys.TRANSFORM.setClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)SVGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                this.set(SVGAttributeKeys.TRANSFORM, t);
            }
        } else {
            Gradient g;
            Point2D.Double anchor = this.getStartPoint();
            Point2D.Double lead = this.getEndPoint();
            this.setBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
            if (this.get(SVGAttributeKeys.FILL_GRADIENT) != null && !this.get(SVGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(SVGAttributeKeys.FILL_GRADIENT, g);
            }
            if (this.get(SVGAttributeKeys.STROKE_GRADIENT) != null && !this.get(SVGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(SVGAttributeKeys.STROKE_GRADIENT, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Object[] restoreData = (Object[])geometry;
        this.ellipse = (Ellipse2D.Double)((Ellipse2D.Double)restoreData[0]).clone();
        SVGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)restoreData[1]);
        SVGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)restoreData[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        return new Object[]{this.ellipse.clone(), SVGAttributeKeys.TRANSFORM.getClone(this), SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                ResizeHandleKit.addResizeHandles(this, handles);
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public SVGEllipseFigure clone() {
        SVGEllipseFigure that = (SVGEllipseFigure)super.clone();
        that.ellipse = (Ellipse2D.Double)this.ellipse.clone();
        that.cachedTransformedShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        Rectangle2D.Double b = this.getBounds();
        return b.width <= 0.0 || b.height <= 0.0;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTransformedShape = null;
        this.cachedHitShape = null;
    }
}

