/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.scijava.util.ConversionUtils;
import org.scijava.util.MiscUtils;
import org.scijava.util.Query;
import org.scijava.util.Types;

public final class ClassUtils {
    private static final FieldCache fieldCache = new FieldCache();
    private static final MethodCache methodCache = new MethodCache();

    private ClassUtils() {
    }

    public static <A extends Annotation> List<Method> getAnnotatedMethods(Class<?> c, Class<A> annotationClass) {
        List<Method> methods = methodCache.getList(c, annotationClass);
        if (methods == null) {
            methods = new ArrayList<Method>();
            ClassUtils.getAnnotatedMethods(c, annotationClass, methods);
        }
        return methods;
    }

    public static <A extends Annotation> void getAnnotatedMethods(Class<?> c, Class<A> annotationClass, List<Method> methods) {
        List cachedMethods = methodCache.getList(c, annotationClass);
        if (cachedMethods == null) {
            Query query = new Query();
            query.put(annotationClass, Method.class);
            ClassUtils.cacheAnnotatedObjects(c, query);
            cachedMethods = methodCache.getList(c, annotationClass);
        }
        if (cachedMethods != null) {
            methods.addAll(cachedMethods);
        }
    }

    public static <A extends Annotation> List<Field> getAnnotatedFields(Class<?> c, Class<A> annotationClass) {
        List<Field> fields = fieldCache.getList(c, annotationClass);
        if (fields == null) {
            fields = new ArrayList<Field>();
            ClassUtils.getAnnotatedFields(c, annotationClass, fields);
        }
        return fields;
    }

    public static <A extends Annotation> void getAnnotatedFields(Class<?> c, Class<A> annotationClass, List<Field> fields) {
        List cachedFields = fieldCache.getList(c, annotationClass);
        if (cachedFields == null) {
            Query query = new Query();
            query.put(annotationClass, Field.class);
            ClassUtils.cacheAnnotatedObjects(c, query);
            cachedFields = fieldCache.getList(c, annotationClass);
        }
        if (cachedFields != null) {
            fields.addAll(cachedFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheAnnotatedObjects(Class<?> scannedClass, Query query) {
        Class<?> clazz = scannedClass;
        synchronized (clazz) {
            if (scannedClass == null || scannedClass == Object.class) {
                return;
            }
            HashSet<Class> keysToDrop = new HashSet<Class>();
            for (Class annotationClass : query.keySet()) {
                if (fieldCache.getList(scannedClass, annotationClass) != null) {
                    keysToDrop.add(annotationClass);
                    continue;
                }
                if (methodCache.getList(scannedClass, annotationClass) == null) continue;
                keysToDrop.add(annotationClass);
            }
            for (Class key : keysToDrop) {
                query.remove(key);
            }
            if (query.isEmpty()) {
                return;
            }
            ArrayList inherited = new ArrayList();
            Class<?> superClass = scannedClass.getSuperclass();
            if (superClass != null) {
                ClassUtils.cacheAnnotatedObjects(superClass, new Query(query));
                inherited.add(superClass);
            }
            for (Class<?> ifaceClass : scannedClass.getInterfaces()) {
                ClassUtils.cacheAnnotatedObjects(ifaceClass, new Query(query));
                inherited.add(ifaceClass);
            }
            for (Class annotationClass : query.keySet()) {
                Class objectClass = (Class)query.get(annotationClass);
                try {
                    if (Method.class.isAssignableFrom(objectClass)) {
                        ClassUtils.populateCache(scannedClass, inherited, (Class)annotationClass, (CacheMap)methodCache, (AnnotatedElement[])scannedClass.getDeclaredMethods());
                        continue;
                    }
                    if (!Field.class.isAssignableFrom(objectClass)) continue;
                    ClassUtils.populateCache(scannedClass, inherited, (Class)annotationClass, (CacheMap)fieldCache, (AnnotatedElement[])scannedClass.getDeclaredFields());
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static Object getValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static void setValue(Field field, Object instance, Object value) {
        try {
            Object compatibleValue;
            field.setAccessible(true);
            if (value == null || field.getType().isInstance(value)) {
                compatibleValue = value;
            } else {
                Object convertedValue;
                Type fieldType = Types.fieldType(field, instance.getClass());
                compatibleValue = convertedValue = ConversionUtils.convert(value, fieldType);
            }
            field.set(instance, compatibleValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("No access to field: " + field.getName(), e);
        }
    }

    public static int compare(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return 0;
        }
        String name1 = c1 == null ? null : c1.getName();
        String name2 = c2 == null ? null : c2.getName();
        return MiscUtils.compare(name1, name2);
    }

    private static Class<?> arrayOrNull(Class<?> componentType) {
        try {
            return Types.array(componentType);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    private static <T extends AnnotatedElement> void populateCache(Class<?> scannedClass, List<Class<?>> inherited, Class<? extends Annotation> annotationClass, CacheMap<T> cacheMap, T[] declaredElements) {
        for (Class<?> inheritedClass : inherited) {
            List<T> annotatedElements = cacheMap.getList(inheritedClass, annotationClass);
            if (annotatedElements == null || annotatedElements.isEmpty()) continue;
            List<T> scannedElements = cacheMap.makeList(scannedClass, annotationClass);
            scannedElements.addAll(annotatedElements);
        }
        if (declaredElements != null && declaredElements.length > 0) {
            List<T> scannedElements = null;
            for (? extends Annotation t : declaredElements) {
                if (t.getAnnotation(annotationClass) == null) continue;
                if (scannedElements == null) {
                    scannedElements = cacheMap.makeList(scannedClass, annotationClass);
                }
                scannedElements.add(t);
            }
        }
        if (cacheMap.getList(scannedClass, annotationClass) == null) {
            cacheMap.putList(scannedClass, annotationClass, Collections.emptyList());
        }
    }

    @Deprecated
    public static Class<?> loadClass(String name) {
        return Types.load(name);
    }

    @Deprecated
    public static Class<?> loadClass(String name, ClassLoader classLoader) {
        return Types.load(name, classLoader);
    }

    @Deprecated
    public static Class<?> loadClass(String className, boolean quietly) {
        return Types.load(className, quietly);
    }

    @Deprecated
    public static Class<?> loadClass(String name, ClassLoader classLoader, boolean quietly) {
        return Types.load(name, classLoader, quietly);
    }

    @Deprecated
    public static boolean hasClass(String className) {
        return Types.load(className) != null;
    }

    @Deprecated
    public static boolean hasClass(String className, ClassLoader classLoader) {
        return Types.load(className, classLoader) != null;
    }

    @Deprecated
    public static URL getLocation(String className) {
        return Types.location(Types.load(className));
    }

    @Deprecated
    public static URL getLocation(String className, ClassLoader classLoader) {
        return Types.location(Types.load(className, classLoader));
    }

    @Deprecated
    public static URL getLocation(Class<?> c) {
        return Types.location(c);
    }

    @Deprecated
    public static boolean isBoolean(Class<?> type) {
        return Types.isBoolean(type);
    }

    @Deprecated
    public static boolean isByte(Class<?> type) {
        return Types.isByte(type);
    }

    @Deprecated
    public static boolean isCharacter(Class<?> type) {
        return Types.isCharacter(type);
    }

    @Deprecated
    public static boolean isDouble(Class<?> type) {
        return Types.isDouble(type);
    }

    @Deprecated
    public static boolean isFloat(Class<?> type) {
        return Types.isFloat(type);
    }

    @Deprecated
    public static boolean isInteger(Class<?> type) {
        return Types.isInteger(type);
    }

    @Deprecated
    public static boolean isLong(Class<?> type) {
        return Types.isLong(type);
    }

    @Deprecated
    public static boolean isShort(Class<?> type) {
        return Types.isShort(type);
    }

    @Deprecated
    public static boolean isNumber(Class<?> type) {
        return Types.isNumber(type);
    }

    @Deprecated
    public static boolean isText(Class<?> type) {
        return Types.isText(type);
    }

    @Deprecated
    public static <T> T convert(Object value, Class<T> type) {
        return ConversionUtils.convert(value, type);
    }

    @Deprecated
    public static boolean canConvert(Class<?> c, Class<?> type) {
        return ConversionUtils.canConvert(c, type);
    }

    @Deprecated
    public static boolean canConvert(Object value, Class<?> type) {
        return ConversionUtils.canConvert(value, type);
    }

    @Deprecated
    public static <T> T cast(Object obj, Class<T> type) {
        return Types.cast(obj, type);
    }

    @Deprecated
    public static boolean canCast(Class<?> c, Class<?> type) {
        return Types.isAssignable(c, type);
    }

    @Deprecated
    public static boolean canCast(Object obj, Class<?> type) {
        return Types.isInstance(obj, type);
    }

    @Deprecated
    public static <T> Class<T> getNonprimitiveType(Class<T> type) {
        return Types.box(type);
    }

    @Deprecated
    public static <T> T getNullValue(Class<T> type) {
        return Types.nullValue(type);
    }

    @Deprecated
    public static List<Class<?>> getTypes(Field field, Class<?> type) {
        return Types.raws(Types.fieldType(field, type));
    }

    @Deprecated
    public static Type getGenericType(Field field, Class<?> type) {
        return Types.fieldType(field, type);
    }

    @Deprecated
    public static Field getField(String className, String fieldName) {
        try {
            return Types.field(Types.load(className), fieldName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Deprecated
    public static Field getField(Class<?> c, String fieldName) {
        try {
            return Types.field(c, fieldName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Deprecated
    public static Class<?> getArrayClass(Class<?> elementClass) {
        return Types.raw(ClassUtils.arrayOrNull(elementClass));
    }

    private static class CacheMap<T extends AnnotatedElement>
    extends HashMap<Class<?>, Map<Class<? extends Annotation>, List<T>>> {
        private CacheMap() {
        }

        public List<T> getList(Class<?> c, Class<? extends Annotation> annotationClass) {
            Map annotationTypes = (Map)this.get(c);
            return annotationTypes == null ? null : (List)annotationTypes.get(annotationClass);
        }

        public void putList(Class<?> c, Class<? extends Annotation> annotationClass, List<T> annotatedElements) {
            HashMap<Class<? extends Annotation>, List<T>> map = (HashMap<Class<? extends Annotation>, List<T>>)this.get(c);
            if (map == null) {
                map = new HashMap<Class<? extends Annotation>, List<T>>();
                this.put(c, map);
            }
            map.put(annotationClass, annotatedElements);
        }

        public List<T> makeList(Class<?> c, Class<? extends Annotation> annotationClass) {
            List<T> elements = this.getList(c, annotationClass);
            if (elements == null) {
                elements = new ArrayList<T>();
                this.putList(c, annotationClass, elements);
            }
            return elements;
        }
    }

    private static class MethodCache
    extends CacheMap<Method> {
        private MethodCache() {
        }
    }

    private static class FieldCache
    extends CacheMap<Field> {
        private FieldCache() {
        }
    }
}

