/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.widget;

import org.scijava.module.Module;
import org.scijava.module.ModuleCanceledException;
import org.scijava.module.ModuleException;
import org.scijava.module.ModuleItem;
import org.scijava.widget.InputPanel;

public interface InputHarvester<P, W> {
    public static final double PRIORITY = -10000.0;

    default public void harvest(Module module) throws ModuleException {
        InputPanel<P, W> inputPanel = this.createInputPanel();
        this.buildPanel(inputPanel, module);
        if (!inputPanel.hasWidgets()) {
            return;
        }
        boolean ok = this.harvestInputs(inputPanel, module);
        if (!ok) {
            throw new ModuleCanceledException();
        }
        this.processResults(inputPanel, module);
    }

    public InputPanel<P, W> createInputPanel();

    public void buildPanel(InputPanel<P, W> var1, Module var2) throws ModuleException;

    public boolean harvestInputs(InputPanel<P, W> var1, Module var2);

    default public void processResults(InputPanel<P, W> inputPanel, Module module) throws ModuleException {
        Iterable<ModuleItem<?>> inputs = module.getInfo().inputs();
        for (ModuleItem<?> item : inputs) {
            String name = item.getName();
            module.resolveInput(name);
        }
    }
}

