/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.transform;

import java.util.function.Function;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.ClampType;
import net.imglib2.algorithm.blocks.ComputationType;
import net.imglib2.algorithm.blocks.DefaultUnaryBlockOperator;
import net.imglib2.algorithm.blocks.UnaryBlockOperator;
import net.imglib2.algorithm.blocks.transform.Affine2DProcessor;
import net.imglib2.algorithm.blocks.transform.Affine3DProcessor;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class Transform {
    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> affine(AffineGet transformFromSource, Interpolation interpolation) {
        return Transform.affine(transformFromSource, interpolation, ComputationType.AUTO);
    }

    public static <T extends NativeType<T>> Function<BlockSupplier<T>, UnaryBlockOperator<T, T>> affine(AffineGet transformFromSource, Interpolation interpolation, ComputationType computationType) {
        return s -> Transform.createAffineOperator((NativeType)s.getType(), transformFromSource, interpolation, computationType, ClampType.CLAMP);
    }

    public static <T extends NativeType<T>> UnaryBlockOperator<T, T> createAffineOperator(T type, AffineGet transformFromSource, Interpolation interpolation, ComputationType computationType, ClampType clampType) {
        int n = transformFromSource.numDimensions();
        if (n < 2 || n > 3) {
            throw new IllegalArgumentException("Only 2D and 3D affine transforms are supported currently");
        }
        AffineGet transformToSource = Transform.invert(transformFromSource);
        if (interpolation == Interpolation.NLINEAR) {
            boolean processAsFloat;
            switch (computationType) {
                case FLOAT: {
                    processAsFloat = true;
                    break;
                }
                case DOUBLE: {
                    processAsFloat = false;
                    break;
                }
                default: {
                    PrimitiveType pt = type.getNativeTypeFactory().getPrimitiveType();
                    processAsFloat = pt.equals((Object)PrimitiveType.FLOAT) || pt.getByteCount() < PrimitiveType.FLOAT.getByteCount();
                }
            }
            UnaryBlockOperator<AbstractRealType, AbstractRealType> op = processAsFloat ? Transform._affine(transformToSource, interpolation, new FloatType()) : Transform._affine(transformToSource, interpolation, new DoubleType());
            return op.adaptSourceType(type, ClampType.NONE).adaptTargetType(type, clampType);
        }
        return Transform._affine(transformToSource, interpolation, type);
    }

    private static <T extends NativeType<T>> UnaryBlockOperator<T, T> _affine(AffineGet transform, Interpolation interpolation, T type) {
        int n;
        return new DefaultUnaryBlockOperator<T, T>(type, type, n, n, (n = transform.numDimensions()) == 2 ? new Affine2DProcessor((AffineTransform2D)transform, interpolation, type.getNativeTypeFactory().getPrimitiveType()) : new Affine3DProcessor((AffineTransform3D)transform, interpolation, type.getNativeTypeFactory().getPrimitiveType()));
    }

    private static AffineGet invert(AffineGet transformFromSource) {
        switch (transformFromSource.numDimensions()) {
            case 2: {
                AffineTransform2D transform = new AffineTransform2D();
                transform.set(transformFromSource.inverse().getRowPackedCopy());
                return transform;
            }
            case 3: {
                AffineTransform3D transform = new AffineTransform3D();
                transform.set(transformFromSource.inverse().getRowPackedCopy());
                return transform;
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum Interpolation {
        NEARESTNEIGHBOR,
        NLINEAR;

    }
}

