/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.util.Intervals;

public class DiamondTipsNeighborhood<T>
extends AbstractLocalizable
implements Neighborhood<T> {
    private final long radius;
    private final RandomAccess<T> sourceRandomAccess;
    private final Interval structuringElementBoundingBox;

    public static <T> DiamondTipsNeighborhoodFactory<T> factory() {
        return new DiamondTipsNeighborhoodFactory<T>(){

            @Override
            public DiamondTipsNeighborhood<T> create(long[] position, long radius, RandomAccess<T> sourceRandomAccess) {
                return new DiamondTipsNeighborhood(position, radius, sourceRandomAccess);
            }
        };
    }

    public DiamondTipsNeighborhood(long[] position, long radius, RandomAccess<T> sourceRandomAccess) {
        super(position);
        this.radius = radius;
        this.sourceRandomAccess = sourceRandomAccess;
        this.structuringElementBoundingBox = this.createInterval();
    }

    @Override
    public LocalCursor cursor() {
        return new LocalCursor(this.sourceRandomAccess.copy());
    }

    @Override
    public LocalCursor localizingCursor() {
        return this.cursor();
    }

    @Override
    public long size() {
        return this.sourceRandomAccess.numDimensions() * 2;
    }

    @Override
    public T firstElement() {
        return this.cursor().next();
    }

    @Override
    public T getType() {
        return this.sourceRandomAccess.getType();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public double realMin(int d) {
        return this.position[d] - this.radius;
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.position[d] - this.radius;
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.position.length; ++d) {
            min.setPosition(this.position[d] - this.radius, d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.position[d] + this.radius;
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.position[d] + this.radius;
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.position.length; ++d) {
            max.setPosition(this.position[d] + this.radius, d);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public long min(int d) {
        return this.position[d] - this.radius;
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < min.length; ++d) {
            min[d] = this.position[d] - this.radius;
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.position.length; ++d) {
            min.setPosition(this.position[d] - this.radius, d);
        }
    }

    @Override
    public long max(int d) {
        return this.position[d] + this.radius;
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < max.length; ++d) {
            max[d] = this.position[d] + this.radius;
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.position.length; ++d) {
            max.setPosition(this.position[d] + this.radius, d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < dimensions.length; ++d) {
            dimensions[d] = 2L * this.radius + 1L;
        }
    }

    @Override
    public long dimension(int d) {
        return 2L * this.radius + 1L;
    }

    @Override
    public Interval getStructuringElementBoundingBox() {
        return this.structuringElementBoundingBox;
    }

    private Interval createInterval() {
        int i;
        long[] minmax = new long[2 * this.position.length];
        for (i = 0; i < this.position.length; ++i) {
            minmax[i] = this.position[i] - this.radius;
        }
        for (i = this.position.length; i < minmax.length; ++i) {
            minmax[i] = this.position[i - this.position.length] + this.radius;
        }
        return Intervals.createMinMax(minmax);
    }

    public final class LocalCursor
    extends AbstractEuclideanSpace
    implements Cursor<T> {
        private final RandomAccess<T> source;
        private int currentDim;
        private boolean parity;

        public LocalCursor(RandomAccess<T> source) {
            super(source.numDimensions());
            this.source = source;
            this.reset();
        }

        protected LocalCursor(LocalCursor c) {
            super(c.numDimensions());
            this.source = c.source.copy();
            this.currentDim = c.currentDim;
            this.parity = c.parity;
        }

        @Override
        public T get() {
            return this.source.get();
        }

        @Override
        public T getType() {
            return this.source.getType();
        }

        @Override
        public void fwd() {
            if (!this.parity) {
                if (this.currentDim >= 0) {
                    this.source.setPosition(DiamondTipsNeighborhood.this.position[this.currentDim], this.currentDim);
                }
                ++this.currentDim;
                this.source.move(-DiamondTipsNeighborhood.this.radius, this.currentDim);
                this.parity = true;
            } else {
                this.source.move(2L * DiamondTipsNeighborhood.this.radius, this.currentDim);
                this.parity = false;
            }
        }

        @Override
        public void jumpFwd(long steps) {
            int i = 0;
            while ((long)i < steps) {
                this.fwd();
                ++i;
            }
        }

        @Override
        public T next() {
            this.fwd();
            return this.get();
        }

        @Override
        public void remove() {
        }

        @Override
        public void reset() {
            this.source.setPosition(DiamondTipsNeighborhood.this.position);
            this.currentDim = -1;
            this.parity = false;
        }

        @Override
        public boolean hasNext() {
            return this.currentDim < this.source.numDimensions() - 1 || this.parity;
        }

        @Override
        public float getFloatPosition(int d) {
            return this.source.getFloatPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.source.getDoublePosition(d);
        }

        @Override
        public int getIntPosition(int d) {
            return this.source.getIntPosition(d);
        }

        @Override
        public long getLongPosition(int d) {
            return this.source.getLongPosition(d);
        }

        @Override
        public void localize(long[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(float[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(double[] position) {
            this.source.localize(position);
        }

        @Override
        public void localize(int[] position) {
            this.source.localize(position);
        }

        @Override
        public LocalCursor copy() {
            return new LocalCursor(this);
        }
    }
}

