/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.neighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.HypersphereNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;

public class HyperSphereNeighborhoodRandomAccess<T>
extends HypersphereNeighborhoodLocalizableSampler<T>
implements RandomAccess<Neighborhood<T>> {
    public HyperSphereNeighborhoodRandomAccess(RandomAccessible<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
        super(source, radius, factory, null);
    }

    public HyperSphereNeighborhoodRandomAccess(RandomAccessible<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory, Interval interval) {
        super(source, radius, factory, interval);
    }

    protected HyperSphereNeighborhoodRandomAccess(HyperSphereNeighborhoodRandomAccess<T> c) {
        super(c);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + localizable.getLongPosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public HyperSphereNeighborhoodRandomAccess<T> copy() {
        return new HyperSphereNeighborhoodRandomAccess<T>(this);
    }
}

