/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.DMatrixQrd;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Stopwatch;

public class QrdBench {
    public static void main(String[] args) {
        double maxtime = 5.0;
        int m = 100;
        int n = 5;
        int nrhs = 5;
        edu.mines.jtk.la.DMatrix aj = edu.mines.jtk.la.DMatrix.random(m, n);
        edu.mines.jtk.la.DMatrix bj = edu.mines.jtk.la.DMatrix.random(m, nrhs);
        DMatrix al = new DMatrix(aj.get());
        DMatrix bl = new DMatrix(bj.get());
        Stopwatch sw = new Stopwatch();
        for (int niter = 0; niter < 5; ++niter) {
            edu.mines.jtk.la.DMatrix x1 = new edu.mines.jtk.la.DMatrix(1, 1);
            sw.restart();
            int nqrd = 0;
            while (sw.time() < maxtime) {
                edu.mines.jtk.la.DMatrixQrd qrd1 = new edu.mines.jtk.la.DMatrixQrd(aj);
                x1 = qrd1.solve(bj);
                ++nqrd;
            }
            sw.stop();
            double sum = ArrayMath.sum(x1.getArray());
            double rate = (double)nqrd / sw.time();
            System.out.println("edu.mines.jtk.la:     rate=" + rate + " sum=" + sum);
            DMatrix x2 = new DMatrix(1, 1);
            sw.restart();
            nqrd = 0;
            while (sw.time() < maxtime) {
                DMatrixQrd qrd2 = new DMatrixQrd(al);
                x2 = qrd2.solve(bl);
                ++nqrd;
            }
            sw.stop();
            sum = ArrayMath.sum(x2.getArray());
            rate = (double)nqrd / sw.time();
            System.out.println("edu.mines.jtk.lapack: rate=" + rate + " sum=" + sum);
        }
    }
}

