/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.dsp.RecursiveRectangleFilter;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class LocalCorrelationFilter {
    private Window _window = Window.GAUSSIAN;
    private Type _type = Type.SYMMETRIC;
    private double _sigma1;
    private double _sigma2;
    private double _sigma3;
    private Filter _f1;
    private Filter _f2;
    private Filter _f3;
    private int _dimension;
    private int _n1;
    private int _n2;
    private int _n3;
    private float[][][] _f;
    private float[][][] _g;
    private float[][][][] _s;
    private static float S1 = 0.615728f;
    private static float S2 = -0.1558022f;
    private static float S3 = 0.0509014f;
    private static float S4 = -0.0115417f;
    private static float[] S = new float[]{S4, S3, S2, S1, S1, S2, S3, S4};

    public LocalCorrelationFilter(Type type, Window window, double sigma) {
        this(type, window, sigma, sigma, sigma);
    }

    public LocalCorrelationFilter(Type type, Window window, double sigma1, double sigma2) {
        this(type, window, sigma1, sigma2, sigma2);
    }

    public LocalCorrelationFilter(Type type, Window window, double sigma1, double sigma2, double sigma3) {
        Check.argument(sigma1 >= 1.0, "sigma1>=1.0");
        Check.argument(sigma2 >= 1.0, "sigma2>=1.0");
        Check.argument(sigma3 >= 1.0, "sigma3>=1.0");
        this._type = type;
        this._window = window;
        this._sigma1 = sigma1;
        this._sigma2 = sigma2;
        this._sigma3 = sigma3;
        if (window == Window.GAUSSIAN) {
            this._f1 = new GaussianFilter(sigma1);
            this._f2 = new GaussianFilter(sigma2);
            this._f3 = new GaussianFilter(sigma3);
        } else {
            this._f1 = new RectangleFilter(sigma1);
            this._f2 = new RectangleFilter(sigma2);
            this._f3 = new RectangleFilter(sigma3);
        }
    }

    public void setInputs(float[] f, float[] g) {
        if (f == null || g == null) {
            this._n3 = 0;
            this._n2 = 0;
            this._n1 = 0;
            this._dimension = 0;
            this._f = null;
            this._g = null;
        } else {
            Check.argument(f.length == g.length, "f.length==g.length");
            this._dimension = 1;
            this._n1 = f.length;
            this._n3 = 0;
            this._n2 = 0;
            this._f = new float[1][1][];
            this._g = new float[1][1][];
            this._f[0][0] = f;
            this._g[0][0] = g;
        }
        this._s = null;
    }

    public void setInputs(float[][] f, float[][] g) {
        if (f == null || g == null) {
            this._n3 = 0;
            this._n2 = 0;
            this._n1 = 0;
            this._dimension = 0;
            this._f = null;
            this._g = null;
        } else {
            Check.argument(f[0].length == g[0].length, "f[0].length==g[0].length");
            Check.argument(f.length == g.length, "f.length==g.length");
            Check.argument(ArrayMath.isRegular(f), "f is regular");
            Check.argument(ArrayMath.isRegular(g), "g is regular");
            this._dimension = 2;
            this._n1 = f[0].length;
            this._n2 = f.length;
            this._n3 = 0;
            this._f = new float[1][][];
            this._g = new float[1][][];
            this._f[0] = f;
            this._g[0] = g;
        }
        this._s = null;
    }

    public void setInputs(float[][][] f, float[][][] g) {
        if (f == null || g == null) {
            this._n3 = 0;
            this._n2 = 0;
            this._n1 = 0;
            this._dimension = 0;
            this._f = null;
            this._g = null;
        } else {
            Check.argument(f[0][0].length == g[0][0].length, "f[0][0].length==g[0][0].length");
            Check.argument(f[0].length == g[0].length, "f[0].length==g[0].length");
            Check.argument(f.length == g.length, "f.length==g.length");
            Check.argument(ArrayMath.isRegular(f), "f is regular");
            Check.argument(ArrayMath.isRegular(g), "g is regular");
            this._dimension = 3;
            this._n1 = f[0][0].length;
            this._n2 = f[0].length;
            this._n3 = f.length;
            this._f = f;
            this._g = g;
        }
        this._s = null;
    }

    public void correlate(int lag, float[] c) {
        this.checkDimensions(c);
        this.correlate(lag, this._f[0][0], this._g[0][0], c);
    }

    public void correlate(int lag1, int lag2, float[][] c) {
        this.checkDimensions(c);
        this.correlate(lag1, lag2, this._f[0], this._g[0], c);
    }

    public void correlate(int lag1, int lag2, int lag3, float[][][] c) {
        this.checkDimensions(c);
        this.correlate(lag1, lag2, lag3, this._f, this._g, c);
    }

    public void normalize(int lag, float[] c) {
        block6: {
            int n1;
            block5: {
                int i1;
                this.checkDimensions(c);
                if (this._s == null) {
                    this.updateNormalize();
                }
                n1 = this._n1;
                int l1 = lag;
                if (this._type != Type.SIMPLE) break block5;
                float[] sf = this._s[0][0][0];
                float[] sg = this._s[1][0][0];
                int i1min = ArrayMath.max(0, -l1);
                int i1max = ArrayMath.min(n1, n1 - l1);
                for (i1 = 0; i1 < i1min; ++i1) {
                    int n = i1;
                    c[n] = c[n] * (sf[i1] * sg[0]);
                }
                for (i1 = i1min; i1 < i1max; ++i1) {
                    int n = i1;
                    c[n] = c[n] * (sf[i1] * sg[i1 + l1]);
                }
                for (i1 = i1max; i1 < n1; ++i1) {
                    int n = i1;
                    c[n] = c[n] * (sf[i1] * sg[n1 - 1]);
                }
                break block6;
            }
            if (this._type != Type.SYMMETRIC) break block6;
            float[] s = this._s[0][0][0];
            for (int i1 = 0; i1 < n1; ++i1) {
                int n = i1;
                c[n] = c[n] * s[i1];
            }
        }
    }

    public void normalize(int lag1, int lag2, float[][] c) {
        block8: {
            int n2;
            int n1;
            block7: {
                this.checkDimensions(c);
                if (this._s == null) {
                    this.updateNormalize();
                }
                n1 = this._n1;
                n2 = this._n2;
                int l1 = lag1;
                int l2 = lag2;
                if (this._type != Type.SIMPLE) break block7;
                float[][] sf = this._s[0][0];
                float[][] sg = this._s[1][0];
                int i1min = ArrayMath.max(0, -l1);
                int i1max = ArrayMath.min(n1, n1 - l1);
                for (int i2 = 0; i2 < n2; ++i2) {
                    int i1;
                    float[] c2 = c[i2];
                    float[] sf2 = sf[i2];
                    float[] sg2 = sg[ArrayMath.max(0, ArrayMath.min(n2 - 1, i2 + l2))];
                    for (i1 = 0; i1 < i1min; ++i1) {
                        int n = i1;
                        c2[n] = c2[n] * (sf2[i1] * sg2[0]);
                    }
                    for (i1 = i1min; i1 < i1max; ++i1) {
                        int n = i1;
                        c2[n] = c2[n] * (sf2[i1] * sg2[i1 + l1]);
                    }
                    for (i1 = i1max; i1 < n1; ++i1) {
                        int n = i1;
                        c2[n] = c2[n] * (sf2[i1] * sg2[n1 - 1]);
                    }
                }
                break block8;
            }
            if (this._type != Type.SYMMETRIC) break block8;
            float[][] s = this._s[0][0];
            for (int i2 = 0; i2 < n2; ++i2) {
                float[] c2 = c[i2];
                float[] s2 = s[i2];
                for (int i1 = 0; i1 < n1; ++i1) {
                    int n = i1;
                    c2[n] = c2[n] * s2[i1];
                }
            }
        }
    }

    public void normalize(int lag1, int lag2, int lag3, float[][][] c) {
        block10: {
            int n3;
            int n2;
            int n1;
            block9: {
                this.checkDimensions(c);
                if (this._s == null) {
                    this.updateNormalize();
                }
                n1 = this._n1;
                n2 = this._n2;
                n3 = this._n3;
                int l1 = lag1;
                int l2 = lag2;
                int l3 = lag3;
                if (this._type != Type.SIMPLE) break block9;
                float[][][] sf = this._s[0];
                float[][][] sg = this._s[1];
                int i1min = ArrayMath.max(0, -l1);
                int i1max = ArrayMath.min(n1, n1 - l1);
                for (int i3 = 0; i3 < n3; ++i3) {
                    float[][] c3 = c[i3];
                    float[][] sf3 = sf[i3];
                    float[][] sg3 = sg[ArrayMath.max(0, ArrayMath.min(n3 - 1, i3 + l3))];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        int i1;
                        float[] c32 = c3[i2];
                        float[] sf32 = sf3[i2];
                        float[] sg32 = sg3[ArrayMath.max(0, ArrayMath.min(n2 - 1, i2 + l2))];
                        for (i1 = 0; i1 < i1min; ++i1) {
                            int n = i1;
                            c32[n] = c32[n] * (sf32[i1] * sg32[0]);
                        }
                        for (i1 = i1min; i1 < i1max; ++i1) {
                            int n = i1;
                            c32[n] = c32[n] * (sf32[i1] * sg32[i1 + l1]);
                        }
                        for (i1 = i1max; i1 < n1; ++i1) {
                            int n = i1;
                            c32[n] = c32[n] * (sf32[i1] * sg32[n1 - 1]);
                        }
                    }
                }
                break block10;
            }
            if (this._type != Type.SYMMETRIC) break block10;
            float[][][] s = this._s[0];
            for (int i3 = 0; i3 < n3; ++i3) {
                float[][] c3 = c[i3];
                float[][] s3 = s[i3];
                for (int i2 = 0; i2 < n2; ++i2) {
                    float[] c32 = c3[i2];
                    float[] s32 = s3[i2];
                    for (int i1 = 0; i1 < n1; ++i1) {
                        int n = i1;
                        c32[n] = c32[n] * s32[i1];
                    }
                }
            }
        }
    }

    public float[] unbias(float[] f) {
        int n1 = f.length;
        float[] t = new float[n1];
        this._f1.apply(f, t);
        ArrayMath.sub(f, t, t);
        return t;
    }

    public float[][] unbias(float[][] f) {
        int n1 = f[0].length;
        int n2 = f.length;
        float[][] t = new float[n2][n1];
        this._f1.apply1(f, t);
        this._f2.apply2(t, t);
        ArrayMath.sub(f, t, t);
        return t;
    }

    public float[][][] unbias(float[][][] f) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        float[][][] t = new float[n3][n2][n1];
        this._f1.apply1(f, t);
        this._f2.apply2(t, t);
        this._f3.apply3(t, t);
        ArrayMath.sub(f, t, t);
        return t;
    }

    private void correlate(int lag, float[] f, float[] g, float[] c) {
        Check.argument(f != c, "f!=c");
        Check.argument(g != c, "g!=c");
        int n1 = f.length;
        int l1 = lag;
        int l1f = 0;
        int l1g = l1;
        if (this._type == Type.SYMMETRIC) {
            l1f = l1 >= 0 ? l1 / 2 : (l1 - 1) / 2;
            l1g = l1 >= 0 ? (l1 + 1) / 2 : l1 / 2;
        }
        double scale1 = 1.0;
        scale1 = this._window == Window.GAUSSIAN ? (scale1 *= ArrayMath.sqrt(Math.PI * 2) * this._sigma1) : (scale1 *= 1.0 + 2.0 * this._sigma1);
        if (this._type == Type.SYMMETRIC) {
            scale1 = this._window == Window.GAUSSIAN ? (scale1 *= ArrayMath.exp(-0.125 * (double)l1 * (double)l1 / (this._sigma1 * this._sigma1))) : (scale1 *= ArrayMath.max(0.0, 1.0 + 2.0 * this._sigma1 - (double)ArrayMath.abs(l1)) / (1.0 + 2.0 * this._sigma1));
        }
        float scale = (float)scale1;
        float[] h = new float[n1];
        int i1min = ArrayMath.max(0, l1f, -l1g);
        int i1max = ArrayMath.min(n1, n1 + l1f, n1 - l1g);
        for (int i1 = i1min; i1 < i1max; ++i1) {
            h[i1] = scale * f[i1 - l1f] * g[i1 + l1g];
        }
        if (this._window == Window.GAUSSIAN && this._type == Type.SYMMETRIC && l1f != l1g) {
            LocalCorrelationFilter.shift(h, c);
            ArrayMath.copy(c, h);
        }
        Filter f1 = this._f1;
        if (this._window == Window.RECTANGLE && this._type == Type.SYMMETRIC) {
            f1 = new RectangleFilter(this._sigma1, l1);
        }
        f1.apply(h, c);
    }

    private void correlate(int lag1, int lag2, float[][] f, float[][] g, float[][] c) {
        Object f2;
        Check.argument(f != c, "f!=c");
        Check.argument(g != c, "g!=c");
        int n1 = f[0].length;
        int n2 = f.length;
        int l1 = lag1;
        int l2 = lag2;
        int l1f = 0;
        int l1g = l1;
        int l2f = 0;
        int l2g = l2;
        if (this._type == Type.SYMMETRIC) {
            l1f = l1 >= 0 ? l1 / 2 : (l1 - 1) / 2;
            l1g = l1 >= 0 ? (l1 + 1) / 2 : l1 / 2;
            l2f = l2 >= 0 ? l2 / 2 : (l2 - 1) / 2;
            l2g = l2 >= 0 ? (l2 + 1) / 2 : l2 / 2;
        }
        double scale1 = 1.0;
        double scale2 = 1.0;
        if (this._window == Window.GAUSSIAN) {
            scale1 *= ArrayMath.sqrt(Math.PI * 2) * this._sigma1;
            scale2 *= ArrayMath.sqrt(Math.PI * 2) * this._sigma2;
        } else {
            scale1 *= 1.0 + 2.0 * this._sigma1;
            scale2 *= 1.0 + 2.0 * this._sigma2;
        }
        if (this._type == Type.SYMMETRIC) {
            if (this._window == Window.GAUSSIAN) {
                scale1 *= ArrayMath.exp(-0.125 * (double)l1 * (double)l1 / (this._sigma1 * this._sigma1));
                scale2 *= ArrayMath.exp(-0.125 * (double)l2 * (double)l2 / (this._sigma2 * this._sigma2));
            } else {
                scale1 *= ArrayMath.max(0.0, 1.0 + 2.0 * this._sigma1 - (double)ArrayMath.abs(l1)) / (1.0 + 2.0 * this._sigma1);
                scale2 *= ArrayMath.max(0.0, 1.0 + 2.0 * this._sigma2 - (double)ArrayMath.abs(l2)) / (1.0 + 2.0 * this._sigma2);
            }
        }
        float scale = (float)(scale1 * scale2);
        float[][] h = new float[n2][n1];
        int i1min = ArrayMath.max(0, l1f, -l1g);
        int i1max = ArrayMath.min(n1, n1 + l1f, n1 - l1g);
        int i2min = ArrayMath.max(0, l2f, -l2g);
        int i2max = ArrayMath.min(n2, n2 + l2f, n2 - l2g);
        for (int i2 = i2min; i2 < i2max; ++i2) {
            f2 = f[i2 - l2f];
            float[] g2 = g[i2 + l2g];
            float[] h2 = h[i2];
            for (int i1 = i1min; i1 < i1max; ++i1) {
                h2[i1] = scale * f2[i1 - l1f] * g2[i1 + l1g];
            }
        }
        if (this._window == Window.GAUSSIAN && this._type == Type.SYMMETRIC) {
            if (l1f != l1g) {
                LocalCorrelationFilter.shift1(h, c);
                ArrayMath.copy(c, h);
            }
            if (l2f != l2g) {
                LocalCorrelationFilter.shift2(h, c);
                ArrayMath.copy(c, h);
            }
        }
        Filter f1 = this._f1;
        f2 = this._f2;
        if (this._window == Window.RECTANGLE && this._type == Type.SYMMETRIC) {
            f1 = new RectangleFilter(this._sigma1, l1);
            f2 = new RectangleFilter(this._sigma2, l2);
        }
        f1.apply1(h, c);
        ArrayMath.copy(c, h);
        f2.apply2(h, c);
    }

    private void correlate(int lag1, int lag2, int lag3, float[][][] f, float[][][] g, float[][][] c) {
        Check.argument(f != c, "f!=c");
        Check.argument(g != c, "g!=c");
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        int l1 = lag1;
        int l2 = lag2;
        int l3 = lag3;
        int l1f = 0;
        int l1g = l1;
        int l2f = 0;
        int l2g = l2;
        int l3f = 0;
        int l3g = l3;
        if (this._type == Type.SYMMETRIC) {
            l1f = l1 >= 0 ? l1 / 2 : (l1 - 1) / 2;
            l1g = l1 >= 0 ? (l1 + 1) / 2 : l1 / 2;
            l2f = l2 >= 0 ? l2 / 2 : (l2 - 1) / 2;
            l2g = l2 >= 0 ? (l2 + 1) / 2 : l2 / 2;
            l3f = l3 >= 0 ? l3 / 2 : (l3 - 1) / 2;
            l3g = l3 >= 0 ? (l3 + 1) / 2 : l3 / 2;
        }
        double scale1 = 1.0;
        double scale2 = 1.0;
        double scale3 = 1.0;
        if (this._window == Window.GAUSSIAN) {
            scale1 *= ArrayMath.sqrt(Math.PI * 2) * this._sigma1;
            scale2 *= ArrayMath.sqrt(Math.PI * 2) * this._sigma2;
            scale3 *= ArrayMath.sqrt(Math.PI * 2) * this._sigma3;
        } else {
            scale1 *= 1.0 + 2.0 * this._sigma1;
            scale2 *= 1.0 + 2.0 * this._sigma2;
            scale3 *= 1.0 + 2.0 * this._sigma3;
        }
        if (this._type == Type.SYMMETRIC) {
            if (this._window == Window.GAUSSIAN) {
                scale1 *= ArrayMath.exp(-0.125 * (double)l1 * (double)l1 / (this._sigma1 * this._sigma1));
                scale2 *= ArrayMath.exp(-0.125 * (double)l2 * (double)l2 / (this._sigma2 * this._sigma2));
                scale3 *= ArrayMath.exp(-0.125 * (double)l3 * (double)l3 / (this._sigma3 * this._sigma3));
            } else {
                scale1 *= ArrayMath.max(0.0, 1.0 + 2.0 * this._sigma1 - (double)ArrayMath.abs(l1)) / (1.0 + 2.0 * this._sigma1);
                scale2 *= ArrayMath.max(0.0, 1.0 + 2.0 * this._sigma2 - (double)ArrayMath.abs(l2)) / (1.0 + 2.0 * this._sigma2);
                scale3 *= ArrayMath.max(0.0, 1.0 + 2.0 * this._sigma3 - (double)ArrayMath.abs(l3)) / (1.0 + 2.0 * this._sigma3);
            }
        }
        float scale = (float)(scale1 * scale2 * scale3);
        float[][][] h = new float[n3][n2][n1];
        int i1min = ArrayMath.max(0, l1f, -l1g);
        int i1max = ArrayMath.min(n1, n1 + l1f, n1 - l1g);
        int i2min = ArrayMath.max(0, l2f, -l2g);
        int i2max = ArrayMath.min(n2, n2 + l2f, n2 - l2g);
        int i3min = ArrayMath.max(0, l3f, -l3g);
        int i3max = ArrayMath.min(n3, n3 + l3f, n3 - l3g);
        for (int i3 = i3min; i3 < i3max; ++i3) {
            float[][] f3 = f[i3 - l3f];
            float[][] g3 = g[i3 + l3g];
            float[][] h3 = h[i3];
            for (int i2 = i2min; i2 < i2max; ++i2) {
                float[] f32 = f3[i2 - l2f];
                float[] g32 = g3[i2 + l2g];
                float[] h32 = h3[i2];
                for (int i1 = i1min; i1 < i1max; ++i1) {
                    h32[i1] = scale * f32[i1 - l1f] * g32[i1 + l1g];
                }
            }
        }
        if (this._window == Window.GAUSSIAN && this._type == Type.SYMMETRIC) {
            if (l1f != l1g) {
                LocalCorrelationFilter.shift1(h, c);
                ArrayMath.copy(c, h);
            }
            if (l2f != l2g) {
                LocalCorrelationFilter.shift2(h, c);
                ArrayMath.copy(c, h);
            }
            if (l3f != l3g) {
                LocalCorrelationFilter.shift3(h, c);
                ArrayMath.copy(c, h);
            }
        }
        Filter f1 = this._f1;
        Filter f2 = this._f2;
        Filter f3 = this._f3;
        if (this._window == Window.RECTANGLE && this._type == Type.SYMMETRIC) {
            f1 = new RectangleFilter(this._sigma1, l1);
            f2 = new RectangleFilter(this._sigma2, l2);
            f3 = new RectangleFilter(this._sigma3, l3);
        }
        f1.apply1(h, c);
        ArrayMath.copy(c, h);
        f2.apply2(h, c);
        ArrayMath.copy(c, h);
        f3.apply3(h, c);
    }

    private void updateNormalize() {
        if (this._dimension == 0) {
            return;
        }
        int ns = this._type == Type.SIMPLE ? 2 : 1;
        int n1 = ArrayMath.max(1, this._n1);
        int n2 = ArrayMath.max(1, this._n2);
        int n3 = ArrayMath.max(1, this._n3);
        this._s = new float[ns][n3][n2][n1];
        if (this._type == Type.SIMPLE) {
            if (this._dimension == 1) {
                float[] f = this._f[0][0];
                float[] g = this._g[0][0];
                float[] sf = this._s[0][0][0];
                float[] sg = this._s[1][0][0];
                this.correlate(0, f, f, sf);
                this.correlate(0, g, g, sg);
                ArrayMath.sqrt(sf, sf);
                ArrayMath.sqrt(sg, sg);
                ArrayMath.div(1.0f, sf, sf);
                ArrayMath.div(1.0f, sg, sg);
            } else if (this._dimension == 2) {
                float[][] f = this._f[0];
                float[][] g = this._g[0];
                float[][] sf = this._s[0][0];
                float[][] sg = this._s[1][0];
                this.correlate(0, 0, f, f, sf);
                this.correlate(0, 0, g, g, sg);
                ArrayMath.sqrt(sf, sf);
                ArrayMath.sqrt(sg, sg);
                ArrayMath.div(1.0f, sf, sf);
                ArrayMath.div(1.0f, sg, sg);
            } else {
                float[][][] f = this._f;
                float[][][] g = this._g;
                float[][][] sf = this._s[0];
                float[][][] sg = this._s[1];
                this.correlate(0, 0, 0, f, f, sf);
                this.correlate(0, 0, 0, g, g, sg);
                ArrayMath.sqrt(sf, sf);
                ArrayMath.sqrt(sg, sg);
                ArrayMath.div(1.0f, sf, sf);
                ArrayMath.div(1.0f, sg, sg);
            }
        } else if (this._dimension == 1) {
            float[] s;
            float[] f = this._f[0][0];
            float[] g = this._g[0][0];
            float[] sf = s = this._s[0][0][0];
            float[] sg = new float[this._n1];
            this.correlate(0, f, f, sf);
            this.correlate(0, g, g, sg);
            ArrayMath.mul(sf, sg, s);
            ArrayMath.sqrt(s, s);
            ArrayMath.div(1.0f, s, s);
        } else if (this._dimension == 2) {
            float[][] s;
            float[][] f = this._f[0];
            float[][] g = this._g[0];
            float[][] sf = s = this._s[0][0];
            float[][] sg = new float[this._n2][this._n1];
            this.correlate(0, 0, f, f, sf);
            this.correlate(0, 0, g, g, sg);
            ArrayMath.mul(sf, sg, s);
            ArrayMath.sqrt(s, s);
            ArrayMath.div(1.0f, s, s);
        } else {
            float[][][] s;
            float[][][] f = this._f;
            float[][][] g = this._g;
            float[][][] sf = s = this._s[0];
            float[][][] sg = new float[this._n3][this._n2][this._n1];
            this.correlate(0, 0, 0, f, f, sf);
            this.correlate(0, 0, 0, g, g, sg);
            ArrayMath.mul(sf, sg, s);
            ArrayMath.sqrt(s, s);
            ArrayMath.div(1.0f, s, s);
        }
    }

    private static void shift(float[] f, float[] g) {
        int i;
        int ie;
        int ib;
        int i1;
        int n1 = f.length;
        int i1b = 0;
        int i1e = ArrayMath.min(4, n1);
        for (i1 = i1b; i1 < i1e; ++i1) {
            ib = ArrayMath.max(0, 4 - i1);
            ie = ArrayMath.min(8, 4 - i1 + n1);
            g[i1] = 0.0f;
            for (i = ib; i < ie; ++i) {
                int n = i1;
                g[n] = g[n] + S[i] * f[i1 + i - 4];
            }
        }
        i1b = 4;
        i1e = n1 - 3;
        for (i1 = i1b; i1 < i1e; ++i1) {
            g[i1] = S4 * (f[i1 - 4] + f[i1 + 3]) + S3 * (f[i1 - 3] + f[i1 + 2]) + S2 * (f[i1 - 2] + f[i1 + 1]) + S1 * (f[i1 - 1] + f[i1]);
        }
        i1b = ArrayMath.max(0, n1 - 3);
        i1e = n1;
        for (i1 = i1b; i1 < i1e; ++i1) {
            ib = ArrayMath.max(0, 4 - i1);
            ie = ArrayMath.min(8, 4 - i1 + n1);
            g[i1] = 0.0f;
            for (i = ib; i < ie; ++i) {
                int n = i1;
                g[n] = g[n] + S[i] * f[i1 + i - 4];
            }
        }
    }

    private static void shift1(float[][] f, float[][] g) {
        int n2 = f.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            LocalCorrelationFilter.shift(f[i2], g[i2]);
        }
    }

    private static void shift2(float[][] f, float[][] g) {
        int i2;
        int n2 = f.length;
        int n1 = f[0].length;
        int i2b = 0;
        int i2e = ArrayMath.min(4, n2);
        for (i2 = i2b; i2 < i2e; ++i2) {
            int ib = ArrayMath.max(0, 4 - i2);
            int ie = ArrayMath.min(8, 4 - i2 + n2);
            for (int i1 = 0; i1 < n1; ++i1) {
                g[i2][i1] = 0.0f;
            }
            for (int i = ib; i < ie; ++i) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float[] fArray = g[i2];
                    int n = i1;
                    fArray[n] = fArray[n] + S[i] * f[i2 + i - 4][i1];
                }
            }
        }
        i2b = 4;
        i2e = n2 - 3;
        for (i2 = i2b; i2 < i2e; ++i2) {
            float[] g2 = g[i2];
            float[] fm4 = f[i2 - 4];
            float[] fm3 = f[i2 - 3];
            float[] fm2 = f[i2 - 2];
            float[] fm1 = f[i2 - 1];
            float[] fp0 = f[i2];
            float[] fp1 = f[i2 + 1];
            float[] fp2 = f[i2 + 2];
            float[] fp3 = f[i2 + 3];
            for (int i1 = 0; i1 < n1; ++i1) {
                g2[i1] = S4 * (fm4[i1] + fp3[i1]) + S3 * (fm3[i1] + fp2[i1]) + S2 * (fm2[i1] + fp1[i1]) + S1 * (fm1[i1] + fp0[i1]);
            }
        }
        i2b = ArrayMath.max(0, n2 - 3);
        i2e = n2;
        for (i2 = i2b; i2 < i2e; ++i2) {
            int ib = ArrayMath.max(0, 4 - i2);
            int ie = ArrayMath.min(8, 4 - i2 + n2);
            for (int i1 = 0; i1 < n1; ++i1) {
                g[i2][i1] = 0.0f;
            }
            for (int i = ib; i < ie; ++i) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float[] fArray = g[i2];
                    int n = i1;
                    fArray[n] = fArray[n] + S[i] * f[i2 + i - 4][i1];
                }
            }
        }
    }

    private static void shift1(float[][][] f, float[][][] g) {
        int n3 = f.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            LocalCorrelationFilter.shift1(f[i3], g[i3]);
        }
    }

    private static void shift2(float[][][] f, float[][][] g) {
        int n3 = f.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            LocalCorrelationFilter.shift2(f[i3], g[i3]);
        }
    }

    private static void shift3(float[][][] f, float[][][] g) {
        int n3 = f.length;
        int n2 = f[0].length;
        float[][] f2 = new float[n3][];
        float[][] g2 = new float[n3][];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                f2[i3] = f[i3][i2];
                g2[i3] = g[i3][i2];
            }
            LocalCorrelationFilter.shift2(f2, g2);
        }
    }

    private void checkDimension(int dimension) {
        Check.state(this._dimension == dimension, "dimension is valid");
    }

    private void checkDimensions(float[] c) {
        Check.argument(this._n1 == c.length, "array length is valid");
        this.checkDimension(1);
    }

    private void checkDimensions(float[][] c) {
        Check.argument(ArrayMath.isRegular(c), "c is regular");
        Check.argument(this._n1 == c[0].length, "array dimension 1 is valid");
        Check.argument(this._n2 == c.length, "array dimension 2 is valid");
        this.checkDimension(2);
    }

    private void checkDimensions(float[][][] c) {
        Check.argument(ArrayMath.isRegular(c), "c is regular");
        Check.argument(this._n1 == c[0][0].length, "array dimension 1 is valid");
        Check.argument(this._n2 == c[0].length, "array dimension 2 is valid");
        Check.argument(this._n3 == c.length, "array dimension 3 is valid");
        this.checkDimension(3);
    }

    private class GaussianFilter
    implements Filter {
        private RecursiveGaussianFilter _rgf;

        public GaussianFilter(double sigma) {
            this._rgf = new RecursiveGaussianFilter(sigma);
        }

        @Override
        public void apply(float[] x, float[] y) {
            this._rgf.apply0(x, y);
        }

        @Override
        public void apply1(float[][] x, float[][] y) {
            this._rgf.apply0X(x, y);
        }

        @Override
        public void apply2(float[][] x, float[][] y) {
            this._rgf.applyX0(x, y);
        }

        @Override
        public void apply1(float[][][] x, float[][][] y) {
            this._rgf.apply0XX(x, y);
        }

        @Override
        public void apply2(float[][][] x, float[][][] y) {
            this._rgf.applyX0X(x, y);
        }

        @Override
        public void apply3(float[][][] x, float[][][] y) {
            this._rgf.applyXX0(x, y);
        }
    }

    private class RectangleFilter
    implements Filter {
        private RecursiveRectangleFilter _rrf;

        public RectangleFilter(double sigma) {
            this(sigma, 0);
        }

        public RectangleFilter(double sigma, int lag) {
            int n = (int)ArrayMath.round(1.0 + 2.0 * sigma);
            int m = ArrayMath.max(0, (n - 1 - ArrayMath.abs(lag)) / 2);
            int l = lag % 2 == 0 ? -m : -m - 1;
            this._rrf = new RecursiveRectangleFilter(l, m);
        }

        @Override
        public void apply(float[] x, float[] y) {
            this._rrf.apply(x, y);
        }

        @Override
        public void apply1(float[][] x, float[][] y) {
            this._rrf.apply1(x, y);
        }

        @Override
        public void apply2(float[][] x, float[][] y) {
            this._rrf.apply2(x, y);
        }

        @Override
        public void apply1(float[][][] x, float[][][] y) {
            this._rrf.apply1(x, y);
        }

        @Override
        public void apply2(float[][][] x, float[][][] y) {
            this._rrf.apply2(x, y);
        }

        @Override
        public void apply3(float[][][] x, float[][][] y) {
            this._rrf.apply3(x, y);
        }
    }

    private static interface Filter {
        public void apply(float[] var1, float[] var2);

        public void apply1(float[][] var1, float[][] var2);

        public void apply2(float[][] var1, float[][] var2);

        public void apply1(float[][][] var1, float[][][] var2);

        public void apply2(float[][][] var1, float[][][] var2);

        public void apply3(float[][][] var1, float[][][] var2);
    }

    public static enum Window {
        GAUSSIAN,
        RECTANGLE;

    }

    public static enum Type {
        SIMPLE,
        SYMMETRIC;

    }
}

