/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Parallel;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RecursiveGaussianFilterTest
extends TestCase {
    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("bench")) {
            boolean parallel = args.length <= 1 || !args[1].equals("serial");
            RecursiveGaussianFilterTest.bench(parallel);
        }
        TestSuite suite = new TestSuite(RecursiveGaussianFilterTest.class);
        TestRunner.run((Test)suite);
    }

    public void test1() {
        float sigma = 10.0f;
        int n = 1 + 2 * (int)(sigma * 4.0f);
        int k = (n - 1) / 2;
        float[] x = ArrayMath.zerofloat(n);
        float[] y = ArrayMath.zerofloat(n);
        x[k] = 1.0f;
        float tolerance = 0.01f * RecursiveGaussianFilterTest.gaussian(sigma, 0.0f);
        RecursiveGaussianFilter rf = new RecursiveGaussianFilter(sigma);
        rf.apply0(x, y);
        for (int i = 0; i < n; ++i) {
            float gi = RecursiveGaussianFilterTest.gaussian(sigma, i - k);
            RecursiveGaussianFilterTest.assertEquals((float)gi, (float)y[i], (float)tolerance);
        }
    }

    public void test2() {
        float sigma = 10.0f;
        int n1 = 1 + 2 * (int)(sigma * 4.0f);
        int n2 = n1 + 2;
        int k1 = (n1 - 1) / 2;
        int k2 = (n2 - 1) / 2;
        float[][] x = ArrayMath.zerofloat(n1, n2);
        float[][] y = ArrayMath.zerofloat(n1, n2);
        x[k2][k1] = 1.0f;
        float tolerance = 0.01f * RecursiveGaussianFilterTest.gaussian(sigma, 0.0f, 0.0f);
        RecursiveGaussianFilter rf = new RecursiveGaussianFilter(sigma);
        rf.apply00(x, y);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                float gi = RecursiveGaussianFilterTest.gaussian(sigma, i1 - k1, i2 - k2);
                RecursiveGaussianFilterTest.assertEquals((float)gi, (float)y[i2][i1], (float)tolerance);
            }
        }
    }

    public void test3() {
        float sigma = 10.0f;
        int n1 = 1 + 2 * (int)(sigma * 4.0f);
        int n2 = n1 + 2;
        int n3 = n2 + 2;
        int k1 = (n1 - 1) / 2;
        int k2 = (n2 - 1) / 2;
        int k3 = (n3 - 1) / 2;
        float[][][] x = ArrayMath.zerofloat(n1, n2, n3);
        float[][][] y = ArrayMath.zerofloat(n1, n2, n3);
        x[k3][k2][k1] = 1.0f;
        float tolerance = 0.01f * RecursiveGaussianFilterTest.gaussian(sigma, 0.0f, 0.0f);
        RecursiveGaussianFilter rf = new RecursiveGaussianFilter(sigma);
        rf.apply000(x, y);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float gi = RecursiveGaussianFilterTest.gaussian(sigma, i1 - k1, i2 - k2, i3 - k3);
                    RecursiveGaussianFilterTest.assertEquals((float)gi, (float)y[i3][i2][i1], (float)tolerance);
                }
            }
        }
    }

    private static float gaussian(float s, float x) {
        float xx = x * x;
        float ss = s * s;
        return ArrayMath.exp(-0.5f * xx / ss) / ArrayMath.sqrt((float)Math.PI * 2 * ss);
    }

    private static float gaussian(float s, float x1, float x2) {
        return RecursiveGaussianFilterTest.gaussian(s, x1) * RecursiveGaussianFilterTest.gaussian(s, x2);
    }

    private static float gaussian(float s, float x1, float x2, float x3) {
        return RecursiveGaussianFilterTest.gaussian(s, x1, x2) * RecursiveGaussianFilterTest.gaussian(s, x3);
    }

    private static void bench(boolean parallel) {
        Parallel.setParallel(parallel);
        RecursiveGaussianFilterTest.bench3();
    }

    private static void bench3() {
        int n1 = 501;
        int n2 = 502;
        int n3 = 503;
        Random r = new Random(314159L);
        float[][][] x = ArrayMath.randfloat(r, n1, n2, n3);
        float[][][] y = ArrayMath.randfloat(r, n1, n2, n3);
        RecursiveGaussianFilter rf = new RecursiveGaussianFilter(3.0);
        double maxtime = 5.0;
        double nsample = (double)n1 * (double)n2 * (double)n3;
        Stopwatch sw = new Stopwatch();
        for (int itest = 0; itest < 3; ++itest) {
            sw.restart();
            int niter = 0;
            while (sw.time() < maxtime) {
                rf.apply000(x, y);
                ++niter;
            }
            sw.stop();
            float sum = ArrayMath.sum(y);
            int rate = (int)(1.0E-6 * (double)niter * nsample / sw.time());
            System.out.println("rate = " + rate + "  sum = " + sum);
        }
    }
}

