/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.la;

public class TridiagonalFMatrix {
    private int _n;
    private float[] _a;
    private float[] _b;
    private float[] _c;
    private float[] _w;

    public TridiagonalFMatrix(int n) {
        this(n, new float[n], new float[n], new float[n]);
    }

    public TridiagonalFMatrix(int n, float[] a, float[] b, float[] c) {
        this._n = n;
        this._a = a;
        this._b = b;
        this._c = c;
    }

    public int n() {
        return this._n;
    }

    public float[] a() {
        return this._a;
    }

    public float[] b() {
        return this._b;
    }

    public float[] c() {
        return this._c;
    }

    public void solve(float[] r, float[] u) {
        int j;
        if (this._w == null) {
            this._w = new float[this._n];
        }
        float t = this._b[0];
        u[0] = r[0] / t;
        for (j = 1; j < this._n; ++j) {
            this._w[j] = this._c[j - 1] / t;
            t = this._b[j] - this._a[j] * this._w[j];
            u[j] = (r[j] - this._a[j] * u[j - 1]) / t;
        }
        for (j = this._n - 1; j > 0; --j) {
            int n = j - 1;
            u[n] = u[n] - this._w[j] * u[j];
        }
    }

    public float[] times(float[] x) {
        int n = x.length;
        float[] y = new float[n];
        this.times(x, y);
        return y;
    }

    public void times(float[] x, float[] y) {
        int n = x.length;
        int nm1 = n - 1;
        float xip1 = 0.0f;
        float xi = x[0];
        y[0] = this._b[0] * xi;
        if (n > 1) {
            xip1 = x[1];
            y[0] = y[0] + this._c[0] * xip1;
            y[n - 1] = this._a[n - 1] * x[n - 2] + this._b[n - 1] * x[n - 1];
        }
        for (int i = 1; i < nm1; ++i) {
            float xim1 = xi;
            xi = xip1;
            xip1 = x[i + 1];
            y[i] = this._a[i] * xim1 + this._b[i] * xi + this._c[i] * xip1;
        }
    }
}

