/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect2f;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArrayVect2fTest
extends TestCase {
    public void testAll() {
        float[][] a = new float[31][21];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                a[i][j] = (float)i + 2.5f * (float)j;
            }
        }
        ArrayVect2f v = new ArrayVect2f(a, 2.0);
        VectUtil.test(v);
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                a[i][j] = 1.0f;
            }
        }
        v = new ArrayVect2f(a, 3.0);
        Vect w = v.clone();
        w.multiplyInverseCovariance();
        assert (Almost.FLOAT.equal(0.3333333333333333, v.dot(w)));
        assert (Almost.FLOAT.equal(0.3333333333333333, v.magnitude()));
        Random random = new Random(352L);
        float[][] a2 = new float[201][];
        boolean oneWasShort = false;
        boolean oneWasLong = false;
        for (int i = 0; i < a2.length; ++i) {
            a2[i] = new float[random.nextInt(11)];
            if (a2[i].length == 0) {
                oneWasShort = true;
            }
            for (int j = 0; j < a2[i].length; ++j) {
                oneWasLong = true;
                a2[i][j] = 5.0f * random.nextFloat() - 2.0f;
            }
        }
        assert (oneWasShort);
        assert (oneWasLong);
        ArrayVect2f v2 = new ArrayVect2f(a2, 2.5);
        VectUtil.test(v2);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ArrayVect2fTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(ArrayVect2fTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ArrayVect2fTest.suite());
    }
}

