/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.State;
import java.awt.Color;

public class BlendState
implements State {
    private static Color _colorDefault = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color _color = _colorDefault;
    private boolean _colorSet;
    private static int _equationDefault = 32774;
    private int _equation = _equationDefault;
    private boolean _equationSet;
    private static int _sfactorDefault = 1;
    private static int _dfactorDefault = 0;
    private int _sfactor = _sfactorDefault;
    private int _dfactor = _dfactorDefault;
    private boolean _functionSet;

    public boolean hasColor() {
        return this._colorSet;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
        this._colorSet = true;
    }

    public void unsetColor() {
        this._color = _colorDefault;
        this._colorSet = false;
    }

    public boolean hasEquation() {
        return this._equationSet;
    }

    public int getEquation() {
        return this._equation;
    }

    public void setEquation(int mode) {
        this._equation = mode;
        this._equationSet = true;
    }

    public void unsetEquation() {
        this._equation = _equationDefault;
        this._equationSet = false;
    }

    public boolean hasBlendFunction() {
        return this._functionSet;
    }

    public int getSfactor() {
        return this._sfactor;
    }

    public int getDfactor() {
        return this._dfactor;
    }

    public void setFunction(int sfactor, int dfactor) {
        this._sfactor = sfactor;
        this._dfactor = dfactor;
        this._functionSet = true;
    }

    public void unsetFunction() {
        this._sfactor = _sfactorDefault;
        this._dfactor = _dfactorDefault;
        this._functionSet = false;
    }

    @Override
    public void apply() {
        Gl.glEnable(3042);
        if (this._colorSet) {
            float r = (float)this._color.getRed() / 255.0f;
            float g = (float)this._color.getGreen() / 255.0f;
            float b = (float)this._color.getBlue() / 255.0f;
            float a = (float)this._color.getAlpha() / 255.0f;
            Gl.glBlendColor(r, g, b, a);
        }
        if (this._equationSet) {
            Gl.glBlendEquation(this._equation);
        }
        if (this._functionSet) {
            Gl.glBlendFunc(this._sfactor, this._dfactor);
        }
    }

    @Override
    public int getAttributeBits() {
        return 24576;
    }
}

