/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Check;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;

public class Parallel {
    private static final int NSQT = 6;
    private static ForkJoinPool _pool = new ForkJoinPool();
    private static boolean _serial = false;

    public static void loop(int end, LoopInt body) {
        Parallel.loop(0, end, 1, 1, body);
    }

    public static void loop(int begin, int end, LoopInt body) {
        Parallel.loop(begin, end, 1, 1, body);
    }

    public static void loop(int begin, int end, int step, LoopInt body) {
        Parallel.loop(begin, end, step, 1, body);
    }

    public static void loop(int begin, int end, int step, int chunk, LoopInt body) {
        Parallel.checkArgs(begin, end, step, chunk);
        if (_serial || end <= begin + chunk * step) {
            for (int i = begin; i < end; i += step) {
                body.compute(i);
            }
        } else {
            LoopIntAction task = new LoopIntAction(begin, end, step, chunk, body);
            if (LoopIntAction.inForkJoinPool()) {
                task.invoke();
            } else {
                _pool.invoke(task);
            }
        }
    }

    public static <V> V reduce(int end, ReduceInt<V> body) {
        return Parallel.reduce(0, end, 1, 1, body);
    }

    public static <V> V reduce(int begin, int end, ReduceInt<V> body) {
        return Parallel.reduce(begin, end, 1, 1, body);
    }

    public static <V> V reduce(int begin, int end, int step, ReduceInt<V> body) {
        return Parallel.reduce(begin, end, step, 1, body);
    }

    public static <V> V reduce(int begin, int end, int step, int chunk, ReduceInt<V> body) {
        Parallel.checkArgs(begin, end, step, chunk);
        if (_serial || end <= begin + chunk * step) {
            V v = body.compute(begin);
            for (int i = begin + step; i < end; i += step) {
                V vi = body.compute(i);
                v = body.combine(v, vi);
            }
            return v;
        }
        ReduceIntTask<V> task = new ReduceIntTask<V>(begin, end, step, chunk, body);
        if (ReduceIntTask.inForkJoinPool()) {
            return task.invoke();
        }
        return _pool.invoke(task);
    }

    public static void setParallel(boolean parallel) {
        _serial = !parallel;
    }

    private static void checkArgs(int begin, int end, int step, int chunk) {
        Check.argument(begin < end, "begin<end");
        Check.argument(step > 0, "step>0");
        Check.argument(chunk > 0, "chunk>0");
    }

    private static int middle(int begin, int end, int step) {
        return begin + step + (end - begin - 1) / 2 / step * step;
    }

    private static class ReduceIntTask<V>
    extends RecursiveTask<V> {
        private int _begin;
        private int _end;
        private int _step;
        private int _chunk;
        private ReduceInt<V> _body;

        ReduceIntTask(int begin, int end, int step, int chunk, ReduceInt<V> body) {
            assert (begin < end) : "begin < end";
            this._begin = begin;
            this._end = end;
            this._step = step;
            this._chunk = chunk;
            this._body = body;
        }

        @Override
        protected V compute() {
            ReduceIntTask<V> r;
            if (this._end <= this._begin + this._chunk * this._step || ReduceIntTask.getSurplusQueuedTaskCount() > 6) {
                V v = this._body.compute(this._begin);
                for (int i = this._begin + this._step; i < this._end; i += this._step) {
                    V vi = this._body.compute(i);
                    v = this._body.combine(v, vi);
                }
                return v;
            }
            int middle = Parallel.middle(this._begin, this._end, this._step);
            ReduceIntTask<V> l = new ReduceIntTask<V>(this._begin, middle, this._step, this._chunk, this._body);
            ReduceIntTask<V> reduceIntTask = r = middle < this._end ? new ReduceIntTask<V>(middle, this._end, this._step, this._chunk, this._body) : null;
            if (r != null) {
                r.fork();
            }
            V v = l.compute();
            if (r != null) {
                v = this._body.combine(v, r.join());
            }
            return v;
        }
    }

    private static class LoopIntAction
    extends RecursiveAction {
        private int _begin;
        private int _end;
        private int _step;
        private int _chunk;
        private LoopInt _body;

        LoopIntAction(int begin, int end, int step, int chunk, LoopInt body) {
            assert (begin < end) : "begin < end";
            this._begin = begin;
            this._end = end;
            this._step = step;
            this._chunk = chunk;
            this._body = body;
        }

        @Override
        protected void compute() {
            if (this._end <= this._begin + this._chunk * this._step || LoopIntAction.getSurplusQueuedTaskCount() > 6) {
                for (int i = this._begin; i < this._end; i += this._step) {
                    this._body.compute(i);
                }
            } else {
                LoopIntAction r;
                int middle = Parallel.middle(this._begin, this._end, this._step);
                LoopIntAction l = new LoopIntAction(this._begin, middle, this._step, this._chunk, this._body);
                LoopIntAction loopIntAction = r = middle < this._end ? new LoopIntAction(middle, this._end, this._step, this._chunk, this._body) : null;
                if (r != null) {
                    r.fork();
                }
                l.compute();
                if (r != null) {
                    r.join();
                }
            }
        }
    }

    public static class Unsafe<T> {
        private ConcurrentHashMap<Thread, T> _map;

        public Unsafe() {
            int initialCapacity = 16;
            float loadFactor = 0.5f;
            int concurrencyLevel = 2 * _pool.getParallelism();
            this._map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }

        public T get() {
            return this._map.get(Thread.currentThread());
        }

        public void set(T object) {
            this._map.put(Thread.currentThread(), object);
        }

        public Collection<T> getAll() {
            return this._map.values();
        }
    }

    public static interface ReduceInt<V> {
        public V compute(int var1);

        public V combine(V var1, V var2);
    }

    public static interface LoopInt {
        public void compute(int var1);
    }
}

