/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.compute;

import edu.utexas.clm.archipelago.network.node.ClusterNode;
import java.io.Serializable;
import java.util.concurrent.Callable;

public class ProcessManager<T>
implements Runnable,
Serializable {
    private static final long serialVersionUID = -5729538939085054236L;
    private Callable<T> callable;
    private T output;
    private final long id;
    private Throwable remoteException;
    private long runningOn;
    private final float numCores;
    private final boolean isFractional;

    public ProcessManager(Callable<T> c, long idArg, float nc, boolean f) {
        this.callable = c;
        this.output = null;
        this.id = idArg;
        this.remoteException = null;
        this.runningOn = -1L;
        this.numCores = nc;
        this.isFractional = f;
    }

    @Override
    public void run() {
        try {
            this.output = this.callable.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.remoteException = e;
        }
        this.callable = null;
    }

    public synchronized void setRunningOn(ClusterNode node) {
        this.runningOn = node == null ? -1L : node.getID();
    }

    public long getRunningOn() {
        return this.runningOn;
    }

    public T getOutput() {
        return this.output;
    }

    public Callable<T> getCallable() {
        return this.callable;
    }

    public long getID() {
        return this.id;
    }

    public Throwable getRemoteException() {
        return this.remoteException;
    }

    public synchronized void setException(Throwable exception) {
        if (this.remoteException == null) {
            this.remoteException = exception;
        }
    }

    public int requestedCores(int totalCores) {
        int c = this.isFractional ? (int)(this.numCores * (float)totalCores) : (int)this.numCores;
        return c > 0 ? c : 1;
    }

    public int requestedCores(ClusterNode node) {
        return this.requestedCores(node.getThreadLimit());
    }

    public boolean equals(Object o) {
        return o instanceof ProcessManager && ((ProcessManager)o).getID() == this.getID();
    }
}

