/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.shell;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.exception.AuthenticationException;
import edu.utexas.clm.archipelago.exception.ShellExecutionException;
import edu.utexas.clm.archipelago.listen.NodeShellListener;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.shell.NodeShell;
import edu.utexas.clm.archipelago.network.shell.NodeShellParameters;
import edu.utexas.clm.archipelago.network.shell.ssh.JSchUtility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;

public class SSHNodeShell
implements NodeShell {
    private static final SSHNodeShell shell = new SSHNodeShell();

    protected String getArguments(NodeParameters param, NodeShellListener listener) {
        String eroot = param.getExecRoot();
        return "--allow-multiple --full-classpath  --main-class edu.utexas.clm.archipelago.Fiji_Archipelago " + param.getID();
    }

    protected void handleJSE(JSchException jse, NodeParameters param) throws ShellExecutionException {
        if (jse.getMessage().equals("Auth cancel")) {
            String keyfile;
            try {
                keyfile = param.getShellParams().getString("keyfile");
            }
            catch (Exception e) {
                keyfile = "";
            }
            throw new AuthenticationException("Could not authenticate on " + param.getHost() + " with user " + param.getUser() + ", and key " + keyfile, jse);
        }
        if (jse.getCause() != null && jse.getCause() instanceof UnknownHostException) {
            throw new ShellExecutionException("Unknown host " + param.getHost(), jse);
        }
        throw new ShellExecutionException(jse);
    }

    @Override
    public boolean startShell(NodeParameters param, NodeShellListener listener) throws ShellExecutionException {
        FijiArchipelago.debug("Starting SSH shell on " + param.getHost());
        try {
            String execFile = param.getExecRoot() + "/" + param.getShellParams().getString("executable");
            if (JSchUtility.verifyParameters(param, execFile)) {
                String command = execFile + " " + this.getArguments(param, listener);
                JSchUtility util = new JSchUtility(param, listener, command);
                int waitCount = 0;
                Channel c = util.getChannel();
                util.start();
                while (!c.isConnected()) {
                    if (waitCount > 600) {
                        throw new ShellExecutionException("Timed out waiting for ssh connection");
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        throw new ShellExecutionException(ie);
                    }
                    ++waitCount;
                }
                InputStream is = c.getInputStream();
                OutputStream os = c.getOutputStream();
                listener.ioStreamsReady(is, os);
                return true;
            }
            return false;
        }
        catch (JSchException jse) {
            this.handleJSE(jse, param);
            return false;
        }
        catch (IOException ioe) {
            throw new ShellExecutionException(ioe);
        }
        catch (ShellExecutionException see) {
            throw see;
        }
        catch (Exception e) {
            FijiArchipelago.debug("" + e, e);
            throw new ShellExecutionException(e);
        }
    }

    @Override
    public NodeShellParameters defaultParameters() {
        String userHome = System.getProperty("user.home");
        String sep = "/";
        NodeShellParameters nsp = new NodeShellParameters();
        nsp.addKey("ssh-port", 22);
        nsp.addKey("keyfile", new File(userHome + "/" + ".ssh" + "/" + "id_dsa"));
        nsp.addKey("executable", "fiji");
        return nsp;
    }

    @Override
    public String paramToString(NodeShellParameters nsp) {
        try {
            return ":" + nsp.getInteger("ssh-port");
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String name() {
        return "SSH Shell";
    }

    @Override
    public String description() {
        return "Uses ssh streams to connect to remote nodes";
    }

    public static SSHNodeShell getShell() {
        return shell;
    }
}

