/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.J3dHash;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point4d;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector4d;

public class BoundingPolytope
extends Bounds {
    Vector4d[] planes;
    double[] mag;
    double[] pDotN;
    Point3d[] verts;
    int nVerts;
    Point3d centroid = new Point3d();
    Point3d[] boxVerts;
    boolean allocBoxVerts = false;

    public BoundingPolytope(Vector4d[] planes) {
        if (planes.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.boundId = 4;
        this.planes = new Vector4d[planes.length];
        this.mag = new double[planes.length];
        this.pDotN = new double[planes.length];
        for (int i = 0; i < planes.length; ++i) {
            this.mag[i] = Math.sqrt(planes[i].x * planes[i].x + planes[i].y * planes[i].y + planes[i].z * planes[i].z);
            double invMag = 1.0 / this.mag[i];
            this.planes[i] = new Vector4d(planes[i].x * invMag, planes[i].y * invMag, planes[i].z * invMag, planes[i].w * invMag);
        }
        this.computeAllVerts();
    }

    public BoundingPolytope() {
        this.boundId = 4;
        this.planes = new Vector4d[6];
        this.mag = new double[this.planes.length];
        this.pDotN = new double[this.planes.length];
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.computeAllVerts();
    }

    public BoundingPolytope(Bounds boundsObject) {
        this.boundId = 4;
        if (boundsObject == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = boundsObject.boundsIsEmpty;
        this.boundsIsInfinite = boundsObject.boundsIsInfinite;
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(sphere.center.x + sphere.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, sphere.center.x - sphere.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(sphere.center.y + sphere.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, sphere.center.y - sphere.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(sphere.center.z + sphere.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, sphere.center.z - sphere.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            this.planes = new Vector4d[6];
            this.pDotN = new double[this.planes.length];
            this.mag = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -box.upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, box.lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -box.upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, box.lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -box.upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, box.lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsObject.boundId == 4) {
            int i;
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            this.planes = new Vector4d[polytope.planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = polytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (i = 0; i < this.planes.length; ++i) {
                this.planes[i] = new Vector4d(polytope.planes[i]);
                this.mag[i] = polytope.mag[i];
                this.pDotN[i] = polytope.pDotN[i];
            }
            for (i = 0; i < this.verts.length; ++i) {
                this.verts[i] = new Point3d(polytope.verts[i]);
            }
            this.centroid = polytope.centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope0"));
        }
    }

    public BoundingPolytope(Bounds[] boundsObjects) {
        int i;
        this.boundId = 4;
        if (boundsObjects == null || boundsObjects.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        for (i = 0; boundsObjects[i] == null && i < boundsObjects.length; ++i) {
        }
        if (i >= boundsObjects.length) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.initEmptyPolytope();
            this.computeAllVerts();
            return;
        }
        this.boundsIsEmpty = boundsObjects[i].boundsIsEmpty;
        this.boundsIsInfinite = boundsObjects[i].boundsIsInfinite;
        if (boundsObjects[i].boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -(sphere.center.x + sphere.radius));
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, sphere.center.x - sphere.radius);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -(sphere.center.y + sphere.radius));
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, sphere.center.y - sphere.radius);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -(sphere.center.z + sphere.radius));
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, sphere.center.z - sphere.radius);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsObjects[i].boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObjects[i];
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -box.upper.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, box.lower.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -box.upper.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, box.lower.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -box.upper.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, box.lower.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.computeAllVerts();
        } else if (boundsObjects[i].boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
            this.planes = new Vector4d[polytope.planes.length];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = polytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (i = 0; i < this.planes.length; ++i) {
                this.planes[i] = new Vector4d(polytope.planes[i]);
                this.pDotN[i] = polytope.pDotN[i];
                this.mag[i] = polytope.mag[i];
            }
            for (i = 0; i < this.verts.length; ++i) {
                this.verts[i] = new Point3d(polytope.verts[i]);
            }
            this.centroid = polytope.centroid;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope1"));
        }
        ++i;
        while (i < boundsObjects.length) {
            this.combine(boundsObjects[i]);
            ++i;
        }
    }

    public void setPlanes(Vector4d[] planes) {
        if (planes.length < 4) {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope11"));
        }
        this.planes = new Vector4d[planes.length];
        this.pDotN = new double[planes.length];
        this.mag = new double[planes.length];
        this.boundsIsEmpty = false;
        if (planes.length <= 0) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        for (int i = 0; i < planes.length; ++i) {
            this.mag[i] = Math.sqrt(planes[i].x * planes[i].x + planes[i].y * planes[i].y + planes[i].z * planes[i].z);
            double invMag = 1.0 / this.mag[i];
            this.planes[i] = new Vector4d(planes[i].x * invMag, planes[i].y * invMag, planes[i].z * invMag, planes[i].w * invMag);
        }
        this.computeAllVerts();
    }

    public void getPlanes(Vector4d[] planes) {
        for (int i = 0; i < planes.length; ++i) {
            planes[i].x = this.planes[i].x * this.mag[i];
            planes[i].y = this.planes[i].y * this.mag[i];
            planes[i].z = this.planes[i].z * this.mag[i];
            planes[i].w = this.planes[i].w * this.mag[i];
        }
    }

    public int getNumPlanes() {
        return this.planes.length;
    }

    @Override
    public void set(Bounds boundsObject) {
        if (boundsObject == null) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
        } else if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            for (int i = 0; i < this.planes.length; ++i) {
                this.planes[i].w = -(sphere.center.x * this.planes[i].x + sphere.center.y * this.planes[i].y + sphere.center.z * this.planes[i].z + sphere.radius);
            }
            this.boundsIsEmpty = boundsObject.boundsIsEmpty;
            this.boundsIsInfinite = boundsObject.boundsIsInfinite;
            this.computeAllVerts();
        } else if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            if (this.boundsIsEmpty) {
                this.initEmptyPolytope();
                this.computeAllVerts();
            }
            for (int i = 0; i < this.planes.length; ++i) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double ux = box.upper.x * this.planes[i].x;
                double uy = box.upper.y * this.planes[i].y;
                double uz = box.upper.z * this.planes[i].z;
                double lx = box.lower.x * this.planes[i].x;
                double ly = box.lower.y * this.planes[i].y;
                double lz = box.lower.z * this.planes[i].z;
                this.planes[i].w = -(ux + uy + uz);
                double newD = ux + uy + lz;
                if (d7 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -newD;
                }
                newD = ux + ly + uz;
                if (d6 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -newD;
                }
                newD = ux + ly + lz;
                if (d5 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -newD;
                }
                newD = lx + uy + uz;
                if (d4 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -newD;
                }
                newD = lx + uy + lz;
                if (d3 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -newD;
                }
                newD = lx + ly + uz;
                if (d2 + this.planes[i].w > 0.0) {
                    this.planes[i].w = -newD;
                }
                newD = lx + ly + lz;
                if (!(d + this.planes[i].w > 0.0)) continue;
                this.planes[i].w = -newD;
            }
            this.boundsIsEmpty = boundsObject.boundsIsEmpty;
            this.boundsIsInfinite = boundsObject.boundsIsInfinite;
            this.computeAllVerts();
        } else if (boundsObject.boundId == 4) {
            int k;
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            if (this.planes.length != polytope.planes.length) {
                this.planes = new Vector4d[polytope.planes.length];
                for (k = 0; k < polytope.planes.length; ++k) {
                    this.planes[k] = new Vector4d();
                }
                this.mag = new double[polytope.planes.length];
                this.pDotN = new double[polytope.planes.length];
            }
            for (int i = 0; i < polytope.planes.length; ++i) {
                this.planes[i].x = polytope.planes[i].x;
                this.planes[i].y = polytope.planes[i].y;
                this.planes[i].z = polytope.planes[i].z;
                this.planes[i].w = polytope.planes[i].w;
                this.mag[i] = polytope.mag[i];
            }
            this.nVerts = polytope.nVerts;
            this.verts = new Point3d[this.nVerts];
            for (k = 0; k < this.nVerts; ++k) {
                this.verts[k] = new Point3d(polytope.verts[k]);
            }
            this.boundsIsEmpty = boundsObject.boundsIsEmpty;
            this.boundsIsInfinite = boundsObject.boundsIsInfinite;
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope2"));
        }
    }

    @Override
    public Object clone() {
        return new BoundingPolytope(this.planes);
    }

    @Override
    public boolean equals(Object bounds) {
        try {
            BoundingPolytope polytope = (BoundingPolytope)bounds;
            if (this.planes.length != polytope.planes.length) {
                return false;
            }
            for (int i = 0; i < this.planes.length; ++i) {
                if (this.planes[i].equals(polytope.planes[i])) continue;
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        long bits = 1L;
        for (int i = 0; i < this.planes.length; ++i) {
            bits = J3dHash.mixDoubleBits(bits, this.planes[i].x);
            bits = J3dHash.mixDoubleBits(bits, this.planes[i].y);
            bits = J3dHash.mixDoubleBits(bits, this.planes[i].z);
            bits = J3dHash.mixDoubleBits(bits, this.planes[i].w);
        }
        return J3dHash.finish(bits);
    }

    @Override
    public void combine(Bounds boundsObject) {
        if (boundsObject == null || boundsObject.boundsIsEmpty || this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty || boundsObject.boundsIsInfinite) {
            this.set(boundsObject);
            return;
        }
        this.boundsIsEmpty = boundsObject.boundsIsEmpty;
        this.boundsIsInfinite = boundsObject.boundsIsInfinite;
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            for (int i = 0; i < this.planes.length; ++i) {
                double dis = sphere.radius + sphere.center.x * this.planes[i].x + sphere.center.y * this.planes[i].y + sphere.center.z * this.planes[i].z + this.planes[i].w;
                if (!(dis > 0.0)) continue;
                this.planes[i].w += -dis;
            }
        } else if (boundsObject instanceof BoundingBox) {
            BoundingBox b = (BoundingBox)boundsObject;
            if (!this.allocBoxVerts) {
                this.boxVerts = new Point3d[8];
                for (int j = 0; j < 8; ++j) {
                    this.boxVerts[j] = new Point3d();
                }
                this.allocBoxVerts = true;
            }
            this.boxVerts[0].set(b.lower.x, b.lower.y, b.lower.z);
            this.boxVerts[1].set(b.lower.x, b.upper.y, b.lower.z);
            this.boxVerts[2].set(b.upper.x, b.lower.y, b.lower.z);
            this.boxVerts[3].set(b.upper.x, b.upper.y, b.lower.z);
            this.boxVerts[4].set(b.lower.x, b.lower.y, b.upper.z);
            this.boxVerts[5].set(b.lower.x, b.upper.y, b.upper.z);
            this.boxVerts[6].set(b.upper.x, b.lower.y, b.upper.z);
            this.boxVerts[7].set(b.upper.x, b.upper.y, b.upper.z);
            this.combine(this.boxVerts);
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            this.combine(polytope.verts);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope3"));
        }
        this.computeAllVerts();
    }

    @Override
    public void combine(Bounds[] boundsObjects) {
        int i;
        if (boundsObjects == null || boundsObjects.length <= 0 || this.boundsIsInfinite) {
            return;
        }
        for (i = 0; i < boundsObjects.length && (boundsObjects[i] == null || boundsObjects[i].boundsIsEmpty); ++i) {
        }
        if (i >= boundsObjects.length) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.set(boundsObjects[i++]);
        }
        if (this.boundsIsInfinite) {
            return;
        }
        while (i < boundsObjects.length) {
            if (boundsObjects[i] != null && !boundsObjects[i].boundsIsEmpty) {
                int j;
                if (boundsObjects[i].boundsIsInfinite) {
                    this.set(boundsObjects[i]);
                    break;
                }
                if (boundsObjects[i].boundId == 2) {
                    BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                    for (j = 0; j < this.planes.length; ++j) {
                        double dis = sphere.radius + sphere.center.x * this.planes[j].x + sphere.center.y * this.planes[j].y + sphere.center.z * this.planes[j].z + this.planes[j].w;
                        if (!(dis > 0.0)) continue;
                        this.planes[j].w += -dis;
                    }
                } else if (boundsObjects[i].boundId == 1) {
                    BoundingBox b = (BoundingBox)boundsObjects[i];
                    if (!this.allocBoxVerts) {
                        this.boxVerts = new Point3d[8];
                        for (j = 0; j < 8; ++j) {
                            this.boxVerts[j] = new Point3d();
                        }
                        this.allocBoxVerts = true;
                    }
                    this.boxVerts[0].set(b.lower.x, b.lower.y, b.lower.z);
                    this.boxVerts[1].set(b.lower.x, b.upper.y, b.lower.z);
                    this.boxVerts[2].set(b.upper.x, b.lower.y, b.lower.z);
                    this.boxVerts[3].set(b.upper.x, b.upper.y, b.lower.z);
                    this.boxVerts[4].set(b.lower.x, b.lower.y, b.upper.z);
                    this.boxVerts[5].set(b.lower.x, b.upper.y, b.upper.z);
                    this.boxVerts[6].set(b.upper.x, b.lower.y, b.upper.z);
                    this.boxVerts[7].set(b.upper.x, b.upper.y, b.upper.z);
                    this.combine(this.boxVerts);
                } else if (boundsObjects[i] instanceof BoundingPolytope) {
                    BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                    this.combine(polytope.verts);
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope4"));
                }
            }
            this.computeAllVerts();
            ++i;
        }
    }

    @Override
    public void combine(Point3d point) {
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = 1;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(point.x, point.y, point.z);
            for (int i = 0; i < this.planes.length; ++i) {
                this.pDotN[i] = 0.0;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -point.x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, point.x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -point.y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, point.y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -point.z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, point.z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = point.x;
            this.centroid.y = point.y;
            this.centroid.z = point.z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        } else {
            for (int i = 0; i < this.planes.length; ++i) {
                double dis = point.x * this.planes[i].x + point.y * this.planes[i].y + point.z * this.planes[i].z + this.planes[i].w;
                if (!(dis > 0.0)) continue;
                this.planes[i].w += -dis;
            }
            this.computeAllVerts();
        }
    }

    @Override
    public void combine(Point3d[] points) {
        int i;
        if (this.boundsIsInfinite) {
            return;
        }
        if (this.boundsIsEmpty) {
            this.planes = new Vector4d[6];
            this.mag = new double[this.planes.length];
            this.pDotN = new double[this.planes.length];
            this.nVerts = points.length;
            this.verts = new Point3d[this.nVerts];
            this.verts[0] = new Point3d(points[0].x, points[0].y, points[0].z);
            for (i = 0; i < this.planes.length; ++i) {
                this.pDotN[i] = 0.0;
            }
            this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -points[0].x);
            this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, points[0].x);
            this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -points[0].y);
            this.planes[3] = new Vector4d(0.0, -1.0, 0.0, points[0].y);
            this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -points[0].z);
            this.planes[5] = new Vector4d(0.0, 0.0, -1.0, points[0].z);
            this.mag[0] = 1.0;
            this.mag[1] = 1.0;
            this.mag[2] = 1.0;
            this.mag[3] = 1.0;
            this.mag[4] = 1.0;
            this.mag[5] = 1.0;
            this.centroid.x = points[0].x;
            this.centroid.y = points[0].y;
            this.centroid.z = points[0].z;
            this.boundsIsEmpty = false;
            this.boundsIsInfinite = false;
        }
        for (int j = 0; j < points.length; ++j) {
            for (i = 0; i < this.planes.length; ++i) {
                double dis = points[j].x * this.planes[i].x + points[j].y * this.planes[i].y + points[j].z * this.planes[i].z + this.planes[i].w;
                if (!(dis > 0.0)) continue;
                this.planes[i].w += -dis;
            }
        }
        this.computeAllVerts();
    }

    @Override
    public void transform(Bounds boundsObject, Transform3D matrix) {
        if (boundsObject == null || boundsObject.boundsIsEmpty) {
            this.boundsIsEmpty = true;
            this.boundsIsInfinite = false;
            this.computeAllVerts();
            return;
        }
        if (boundsObject.boundsIsInfinite) {
            this.set(boundsObject);
            return;
        }
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = new BoundingSphere(boundsObject);
            sphere.transform(matrix);
            this.set(sphere);
        } else if (boundsObject.boundId == 1) {
            BoundingBox box = new BoundingBox(boundsObject);
            box.transform(matrix);
            this.set(box);
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = new BoundingPolytope(boundsObject);
            polytope.transform(matrix);
            this.set(polytope);
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope5"));
        }
    }

    @Override
    public void transform(Transform3D matrix) {
        int i;
        if (this.boundsIsInfinite) {
            return;
        }
        Transform3D invTrans = new Transform3D(matrix);
        invTrans.invert();
        invTrans.transpose();
        for (i = 0; i < this.planes.length; ++i) {
            this.planes[i].x *= this.mag[i];
            this.planes[i].y *= this.mag[i];
            this.planes[i].z *= this.mag[i];
            this.planes[i].w *= this.mag[i];
            invTrans.transform(this.planes[i]);
        }
        for (i = 0; i < this.planes.length; ++i) {
            this.mag[i] = Math.sqrt(this.planes[i].x * this.planes[i].x + this.planes[i].y * this.planes[i].y + this.planes[i].z * this.planes[i].z);
            double invMag = 1.0 / this.mag[i];
            this.planes[i] = new Vector4d(this.planes[i].x * invMag, this.planes[i].y * invMag, this.planes[i].z * invMag, this.planes[i].w * invMag);
        }
        for (i = 0; i < this.verts.length; ++i) {
            matrix.transform(this.verts[i]);
        }
    }

    boolean intersect(Point3d origin, Vector3d direction, Point3d intersectPoint) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            intersectPoint.x = origin.x;
            intersectPoint.y = origin.y;
            intersectPoint.z = origin.z;
            return true;
        }
        double invMag = 1.0 / Math.sqrt(direction.x * direction.x + direction.y * direction.y + direction.z * direction.z);
        double dx = direction.x * invMag;
        double dy = direction.y * invMag;
        double dz = direction.z * invMag;
        for (int i = 0; i < this.planes.length; ++i) {
            double z;
            double y;
            double x;
            double t;
            double vd = this.planes[i].x * dx + this.planes[i].y * dy + this.planes[i].z * dz;
            double v0 = -(this.planes[i].x * origin.x + this.planes[i].y * origin.y + this.planes[i].z * origin.z + this.planes[i].w);
            if (vd == 0.0 || !((t = v0 / vd) >= 0.0) || !this.pointInPolytope(x = origin.x + dx * t, y = origin.y + dy * t, z = origin.z + dz * t)) continue;
            intersectPoint.x = x;
            intersectPoint.y = y;
            intersectPoint.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d origin, Vector3d direction, Point4d position) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = origin.x;
            position.y = origin.y;
            position.z = origin.z;
            position.w = 0.0;
            return true;
        }
        double invMag = 1.0 / Math.sqrt(direction.x * direction.x + direction.y * direction.y + direction.z * direction.z);
        double dx = direction.x * invMag;
        double dy = direction.y * invMag;
        double dz = direction.z * invMag;
        for (int i = 0; i < this.planes.length; ++i) {
            double z;
            double y;
            double x;
            double t;
            double vd = this.planes[i].x * dx + this.planes[i].y * dy + this.planes[i].z * dz;
            double v0 = -(this.planes[i].x * origin.x + this.planes[i].y * origin.y + this.planes[i].z * origin.z + this.planes[i].w);
            if (vd == 0.0 || !((t = v0 / vd) >= 0.0) || !this.pointInPolytope(x = origin.x + dx * t, y = origin.y + dy * t, z = origin.z + dz * t)) continue;
            position.x = x;
            position.y = y;
            position.z = z;
            position.w = t;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d point, Point4d position) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = point.x;
            position.y = point.y;
            position.z = point.z;
            position.w = 0.0;
            return true;
        }
        for (int i = 0; i < this.planes.length; ++i) {
            if (!(point.x * this.planes[i].x + point.y * this.planes[i].y + point.z * this.planes[i].z + this.planes[i].w > 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean intersect(Point3d start, Point3d end, Point4d position) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            position.x = start.x;
            position.y = start.y;
            position.z = start.z;
            position.w = 0.0;
            return true;
        }
        Point3d direction = new Point3d();
        direction.x = end.x - start.x;
        direction.y = end.y - start.y;
        direction.z = end.z - start.z;
        for (int i = 0; i < this.planes.length; ++i) {
            double z;
            double y;
            double x;
            double t;
            double vd = this.planes[i].x * direction.x + this.planes[i].y * direction.y + this.planes[i].z * direction.z;
            double v0 = -(this.planes[i].x * start.x + this.planes[i].y * start.y + this.planes[i].z * start.z + this.planes[i].w);
            if (vd == 0.0 || !((t = v0 / vd) >= 0.0) || !this.pointInPolytope(x = start.x + direction.x * t, y = start.y + direction.y * t, z = start.z + direction.z * t) || !(t <= 1.0)) continue;
            position.x = x;
            position.y = y;
            position.z = z;
            position.w = t;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersect(Point3d origin, Vector3d direction) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < this.planes.length; ++i) {
            double z;
            double y;
            double x;
            double t;
            double vd = this.planes[i].x * direction.x + this.planes[i].y * direction.y + this.planes[i].z * direction.z;
            double v0 = -(this.planes[i].x * origin.x + this.planes[i].y * origin.y + this.planes[i].z * origin.z + this.planes[i].w);
            if (vd == 0.0 || !((t = v0 / vd) >= 0.0) || !this.pointInPolytope(x = origin.x + direction.x * t, y = origin.y + direction.y * t, z = origin.z + direction.z * t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.boundsIsEmpty || this.nVerts <= 0;
    }

    @Override
    public boolean intersect(Point3d point) {
        if (this.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite) {
            return true;
        }
        for (int i = 0; i < this.planes.length; ++i) {
            if (!(point.x * this.planes[i].x + point.y * this.planes[i].y + point.z * this.planes[i].z + this.planes[i].w > 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean intersect(Bounds boundsObject, Point4d position) {
        return this.intersect(boundsObject);
    }

    @Override
    public boolean intersect(Bounds boundsObject) {
        if (boundsObject == null) {
            return false;
        }
        if (this.boundsIsEmpty || boundsObject.boundsIsEmpty) {
            return false;
        }
        if (this.boundsIsInfinite || boundsObject.boundsIsInfinite) {
            return true;
        }
        if (boundsObject.boundId == 2) {
            return this.intersect_ptope_sphere(this, (BoundingSphere)boundsObject);
        }
        if (boundsObject.boundId == 1) {
            return this.intersect_ptope_abox(this, (BoundingBox)boundsObject);
        }
        if (boundsObject.boundId == 4) {
            return this.intersect_ptope_ptope(this, (BoundingPolytope)boundsObject);
        }
        throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope6"));
    }

    @Override
    public boolean intersect(Bounds[] boundsObjects) {
        if (boundsObjects == null || boundsObjects.length <= 0) {
            return false;
        }
        if (this.boundsIsEmpty) {
            return false;
        }
        for (int i = 0; i < boundsObjects.length; ++i) {
            if (boundsObjects[i] != null && !boundsObjects[i].boundsIsEmpty && (this.boundsIsInfinite || boundsObjects[i].boundsIsInfinite)) {
                return true;
            }
            if (boundsObjects[i].boundId == 2) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                double radsq = sphere.radius;
                radsq *= radsq;
                double distsq = sphere.center.distanceSquared(sphere.center);
                if (!(distsq < radsq)) continue;
                return true;
            }
            if (boundsObjects[i].boundId == 1) {
                if (!this.intersect(boundsObjects[i])) continue;
                return true;
            }
            if (boundsObjects[i].boundId == 4) {
                if (!this.intersect(boundsObjects[i])) continue;
                return true;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope7"));
        }
        return false;
    }

    public boolean intersect(Bounds boundsObject, BoundingPolytope newBoundPolytope) {
        if (boundsObject == null || this.boundsIsEmpty || boundsObject.boundsIsEmpty) {
            newBoundPolytope.boundsIsEmpty = true;
            newBoundPolytope.boundsIsInfinite = false;
            newBoundPolytope.computeAllVerts();
            return false;
        }
        if (this.boundsIsInfinite && !boundsObject.boundsIsInfinite) {
            newBoundPolytope.set(boundsObject);
            return true;
        }
        if (!this.boundsIsInfinite && boundsObject.boundsIsInfinite) {
            newBoundPolytope.set(this);
            return true;
        }
        if (this.boundsIsInfinite && boundsObject.boundsIsInfinite) {
            newBoundPolytope.set(this);
            return true;
        }
        BoundingBox tbox = new BoundingBox();
        if (boundsObject.boundId == 2) {
            BoundingSphere sphere = (BoundingSphere)boundsObject;
            if (this.intersect(sphere)) {
                BoundingBox sbox = new BoundingBox(sphere);
                BoundingBox pbox = new BoundingBox(this);
                pbox.intersect((Bounds)sbox, tbox);
                newBoundPolytope.set(tbox);
                return true;
            }
        } else if (boundsObject.boundId == 1) {
            BoundingBox box = (BoundingBox)boundsObject;
            if (this.intersect(box)) {
                BoundingBox pbox = new BoundingBox(this);
                pbox.intersect((Bounds)box, tbox);
                newBoundPolytope.set(tbox);
                return true;
            }
        } else if (boundsObject.boundId == 4) {
            BoundingPolytope polytope = (BoundingPolytope)boundsObject;
            if (this.intersect(polytope)) {
                int i;
                Vector4d[] newPlanes = new Vector4d[this.planes.length + polytope.planes.length];
                for (i = 0; i < this.planes.length; ++i) {
                    newPlanes[i] = new Vector4d(this.planes[i]);
                }
                for (i = 0; i < polytope.planes.length; ++i) {
                    newPlanes[this.planes.length + i] = new Vector4d(polytope.planes[i]);
                }
                BoundingPolytope newPtope = new BoundingPolytope(newPlanes);
                newBoundPolytope.set(newPtope);
                return true;
            }
        } else {
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
        }
        newBoundPolytope.boundsIsEmpty = true;
        newBoundPolytope.boundsIsInfinite = false;
        newBoundPolytope.computeAllVerts();
        return false;
    }

    public boolean intersect(Bounds[] boundsObjects, BoundingPolytope newBoundingPolytope) {
        int i;
        if (boundsObjects == null || boundsObjects.length <= 0 || this.boundsIsEmpty) {
            newBoundingPolytope.boundsIsEmpty = true;
            newBoundingPolytope.boundsIsInfinite = false;
            newBoundingPolytope.computeAllVerts();
            return false;
        }
        for (i = 0; boundsObjects[i] == null && i < boundsObjects.length; ++i) {
        }
        if (i >= boundsObjects.length) {
            newBoundingPolytope.boundsIsEmpty = true;
            newBoundingPolytope.boundsIsInfinite = false;
            newBoundingPolytope.computeAllVerts();
            return false;
        }
        boolean status = false;
        BoundingBox tbox = new BoundingBox();
        for (i = 0; i < boundsObjects.length; ++i) {
            if (boundsObjects[i] != null && !boundsObjects[i].boundsIsEmpty) {
                if (boundsObjects[i].boundId == 2) {
                    BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                    if (this.intersect(sphere)) {
                        BoundingBox sbox = new BoundingBox(sphere);
                        BoundingBox pbox = new BoundingBox(this);
                        pbox.intersect((Bounds)sbox, tbox);
                        if (status) {
                            newBoundingPolytope.combine(tbox);
                        } else {
                            newBoundingPolytope.set(tbox);
                            status = true;
                        }
                    }
                } else if (boundsObjects[i].boundId == 1) {
                    BoundingBox box = (BoundingBox)boundsObjects[i];
                    if (this.intersect(box)) {
                        BoundingBox pbox = new BoundingBox(this);
                        pbox.intersect((Bounds)box, tbox);
                        if (status) {
                            newBoundingPolytope.combine(tbox);
                        } else {
                            newBoundingPolytope.set(tbox);
                            status = true;
                        }
                    }
                } else if (boundsObjects[i].boundId == 4) {
                    BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                    if (this.intersect(polytope)) {
                        Vector4d[] newPlanes = new Vector4d[this.planes.length + polytope.planes.length];
                        for (i = 0; i < this.planes.length; ++i) {
                            newPlanes[i] = new Vector4d(this.planes[i]);
                        }
                        for (i = 0; i < polytope.planes.length; ++i) {
                            newPlanes[this.planes.length + i] = new Vector4d(polytope.planes[i]);
                        }
                        BoundingPolytope newPtope = new BoundingPolytope(newPlanes);
                        if (status) {
                            newBoundingPolytope.combine(newPtope);
                        } else {
                            newBoundingPolytope.set(newPtope);
                            status = true;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope8"));
                }
            }
            if (newBoundingPolytope.boundsIsInfinite) break;
        }
        if (!status) {
            newBoundingPolytope.boundsIsEmpty = true;
            newBoundingPolytope.boundsIsInfinite = false;
            newBoundingPolytope.computeAllVerts();
        }
        return status;
    }

    @Override
    public Bounds closestIntersection(Bounds[] boundsObjects) {
        if (boundsObjects == null || boundsObjects.length <= 0) {
            return null;
        }
        if (this.boundsIsEmpty) {
            return null;
        }
        boolean contains = false;
        double smallest_distance = Double.MAX_VALUE;
        int index = 0;
        double cenX = 0.0;
        double cenY = 0.0;
        double cenZ = 0.0;
        for (int i = 0; i < boundsObjects.length; ++i) {
            int j;
            boolean inside;
            double dis;
            if (boundsObjects[i] == null || !this.intersect(boundsObjects[i])) continue;
            if (boundsObjects[i] instanceof BoundingSphere) {
                BoundingSphere sphere = (BoundingSphere)boundsObjects[i];
                dis = Math.sqrt((this.centroid.x - sphere.center.x) * (this.centroid.x - sphere.center.x) + (this.centroid.y - sphere.center.y) * (this.centroid.y - sphere.center.y) + (this.centroid.z - sphere.center.z) * (this.centroid.z - sphere.center.z));
                inside = true;
                for (j = 0; j < this.planes.length; ++j) {
                    double disToPlane;
                    if (!(sphere.center.x * this.planes[j].x + sphere.center.y * this.planes[j].y + sphere.center.z * this.planes[j].z + this.planes[i].w > 0.0) || !((disToPlane = sphere.center.x * this.planes[j].x + sphere.center.y * this.planes[j].y + sphere.center.z * this.planes[j].z + this.planes[j].w) > sphere.radius)) continue;
                    inside = false;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            if (boundsObjects[i] instanceof BoundingBox) {
                BoundingBox box = (BoundingBox)boundsObjects[i];
                cenX = (box.upper.x + box.lower.x) / 2.0;
                cenY = (box.upper.y + box.lower.y) / 2.0;
                cenZ = (box.upper.z + box.lower.z) / 2.0;
                dis = Math.sqrt((this.centroid.x - cenX) * (this.centroid.x - cenX) + (this.centroid.y - cenY) * (this.centroid.y - cenY) + (this.centroid.z - cenZ) * (this.centroid.z - cenZ));
                inside = true;
                if (!this.pointInPolytope(box.upper.x, box.upper.y, box.upper.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.upper.x, box.upper.y, box.lower.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.upper.x, box.lower.y, box.upper.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.upper.x, box.lower.y, box.lower.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.lower.x, box.upper.y, box.upper.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.lower.x, box.upper.y, box.lower.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.lower.x, box.lower.y, box.upper.z)) {
                    inside = false;
                }
                if (!this.pointInPolytope(box.lower.x, box.lower.y, box.lower.z)) {
                    inside = false;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            if (boundsObjects[i] instanceof BoundingPolytope) {
                BoundingPolytope polytope = (BoundingPolytope)boundsObjects[i];
                dis = Math.sqrt((this.centroid.x - polytope.centroid.x) * (this.centroid.x - polytope.centroid.x) + (this.centroid.y - polytope.centroid.y) * (this.centroid.y - polytope.centroid.y) + (this.centroid.z - polytope.centroid.z) * (this.centroid.z - polytope.centroid.z));
                inside = true;
                for (j = 0; j < polytope.nVerts; ++j) {
                    if (this.pointInPolytope(polytope.verts[j].x, polytope.verts[j].y, polytope.verts[j].z)) continue;
                    inside = false;
                }
                if (inside) {
                    if (!contains) {
                        index = i;
                        smallest_distance = dis;
                        contains = true;
                        continue;
                    }
                    if (!(dis < smallest_distance)) continue;
                    index = i;
                    smallest_distance = dis;
                    continue;
                }
                if (contains || !(dis < smallest_distance)) continue;
                index = i;
                smallest_distance = dis;
                continue;
            }
            throw new IllegalArgumentException(J3dI18N.getString("BoundingPolytope10"));
        }
        return boundsObjects[index];
    }

    public String toString() {
        String description = new String("BoundingPolytope:\n Num Planes =" + this.planes.length);
        for (int i = 0; i < this.planes.length; ++i) {
            description = description + "\n" + this.mag[i] * this.planes[i].x + " " + this.mag[i] * this.planes[i].y + " " + this.mag[i] * this.planes[i].z + " " + this.mag[i] * this.planes[i].w;
        }
        return description;
    }

    private void computeVertex(int a, int b, int c) {
        double det = this.planes[a].x * this.planes[b].y * this.planes[c].z + this.planes[a].y * this.planes[b].z * this.planes[c].x + this.planes[a].z * this.planes[b].x * this.planes[c].y - this.planes[a].z * this.planes[b].y * this.planes[c].x - this.planes[a].y * this.planes[b].x * this.planes[c].z - this.planes[a].x * this.planes[b].z * this.planes[c].y;
        if (det * det < 1.0E-6) {
            return;
        }
        det = 1.0 / det;
        double x = (this.planes[b].y * this.planes[c].z - this.planes[b].z * this.planes[c].y) * this.pDotN[a];
        double y = (this.planes[b].z * this.planes[c].x - this.planes[b].x * this.planes[c].z) * this.pDotN[a];
        double z = (this.planes[b].x * this.planes[c].y - this.planes[b].y * this.planes[c].x) * this.pDotN[a];
        x += (this.planes[c].y * this.planes[a].z - this.planes[c].z * this.planes[a].y) * this.pDotN[b];
        y += (this.planes[c].z * this.planes[a].x - this.planes[c].x * this.planes[a].z) * this.pDotN[b];
        z += (this.planes[c].x * this.planes[a].y - this.planes[c].y * this.planes[a].x) * this.pDotN[b];
        x += (this.planes[a].y * this.planes[b].z - this.planes[a].z * this.planes[b].y) * this.pDotN[c];
        y += (this.planes[a].z * this.planes[b].x - this.planes[a].x * this.planes[b].z) * this.pDotN[c];
        z += (this.planes[a].x * this.planes[b].y - this.planes[a].y * this.planes[b].x) * this.pDotN[c];
        if (this.pointInPolytope(x *= det, y *= det, z *= det)) {
            if (this.nVerts >= this.verts.length) {
                Point3d[] newVerts = new Point3d[this.nVerts << 1];
                for (int i = 0; i < this.nVerts; ++i) {
                    newVerts[i] = this.verts[i];
                }
                this.verts = newVerts;
            }
            this.verts[this.nVerts++] = new Point3d(x, y, z);
        }
    }

    private void computeAllVerts() {
        int i;
        this.nVerts = 0;
        if (this.boundsIsEmpty) {
            this.verts = null;
            return;
        }
        this.verts = new Point3d[this.planes.length * this.planes.length];
        for (i = 0; i < this.planes.length; ++i) {
            this.pDotN[i] = -this.planes[i].x * this.planes[i].w * this.planes[i].x - this.planes[i].y * this.planes[i].w * this.planes[i].y - this.planes[i].z * this.planes[i].w * this.planes[i].z;
        }
        for (int a = 0; a < this.planes.length - 2; ++a) {
            for (int b = a + 1; b < this.planes.length - 1; ++b) {
                for (int c = b + 1; c < this.planes.length; ++c) {
                    this.computeVertex(a, b, c);
                }
            }
        }
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        Point3d[] newVerts = new Point3d[this.nVerts];
        for (i = 0; i < this.nVerts; ++i) {
            x += this.verts[i].x;
            y += this.verts[i].y;
            z += this.verts[i].z;
            newVerts[i] = this.verts[i];
        }
        this.verts = newVerts;
        this.centroid.x = x / (double)this.nVerts;
        this.centroid.y = y / (double)this.nVerts;
        this.centroid.z = z / (double)this.nVerts;
        this.checkBoundsIsEmpty();
    }

    private boolean pointInPolytope(double x, double y, double z) {
        for (int i = 0; i < this.planes.length; ++i) {
            if (!(x * this.planes[i].x + y * this.planes[i].y + z * this.planes[i].z + this.planes[i].w > 1.0E-6)) continue;
            return false;
        }
        return true;
    }

    private void checkBoundsIsEmpty() {
        this.boundsIsEmpty = this.planes.length < 4;
    }

    private void initEmptyPolytope() {
        this.planes = new Vector4d[6];
        this.pDotN = new double[6];
        this.mag = new double[6];
        this.verts = new Point3d[this.planes.length * this.planes.length];
        this.nVerts = 0;
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.mag[0] = 1.0;
        this.mag[1] = 1.0;
        this.mag[2] = 1.0;
        this.mag[3] = 1.0;
        this.mag[4] = 1.0;
        this.mag[5] = 1.0;
        this.checkBoundsIsEmpty();
    }

    @Override
    Point3d getCenter() {
        return this.centroid;
    }

    @Override
    public void getCenter(Point3d center) {
        center.set(this.centroid);
    }

    @Override
    Bounds copy(Bounds r) {
        if (r != null && this.boundId == r.boundId) {
            BoundingPolytope region = (BoundingPolytope)r;
            if (region.planes.length != this.planes.length) {
                int k;
                region.planes = new Vector4d[this.planes.length];
                for (k = 0; k < region.planes.length; ++k) {
                    region.planes[k] = new Vector4d();
                }
                region.mag = new double[this.planes.length];
                region.pDotN = new double[this.planes.length];
                region.verts = new Point3d[this.nVerts];
                region.nVerts = this.nVerts;
                for (k = 0; k < this.nVerts; ++k) {
                    region.verts[k] = new Point3d(this.verts[k]);
                }
            }
            for (int i = 0; i < this.planes.length; ++i) {
                region.planes[i].x = this.planes[i].x;
                region.planes[i].y = this.planes[i].y;
                region.planes[i].z = this.planes[i].z;
                region.planes[i].w = this.planes[i].w;
                region.mag[i] = this.mag[i];
            }
            region.boundsIsEmpty = this.boundsIsEmpty;
            region.boundsIsInfinite = this.boundsIsInfinite;
            return region;
        }
        return (Bounds)this.clone();
    }

    @Override
    int getPickType() {
        return 8;
    }
}

